/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class AutoIndentWriter
extends FilterWriter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private int previousChar = -1;
    private int indentation = 0;
    private String prefix = null;

    public AutoIndentWriter(Writer out) {
        super(out);
    }

    public void write(int c) throws IOException {
        if (AutoIndentWriter.isLineSeparatorChar(c)) {
            if (this.previousChar == 123) {
                this.indent();
            }
        } else if (AutoIndentWriter.isLineSeparatorChar(this.previousChar)) {
            if (c == 125) {
                this.unindent();
            }
            for (int i = 0; i < this.indentation; ++i) {
                this.out.write("    ");
            }
            if (this.prefix != null) {
                this.out.write(this.prefix);
            }
        }
        super.write(c);
        this.previousChar = c;
    }

    public void unindent() {
        --this.indentation;
    }

    public void indent() {
        ++this.indentation;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        while (len > 0) {
            this.write(cbuf[off++]);
            --len;
        }
    }

    public void write(String str, int off, int len) throws IOException {
        while (len > 0) {
            this.write(str.charAt(off++));
            --len;
        }
    }

    private static boolean isLineSeparatorChar(int c) {
        return LINE_SEPARATOR.indexOf(c) != -1;
    }
}

