/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.atomic.AtomicLongArray;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="AtomicInt64Array", source="")
public final class AtomicInt64Array {
    private AtomicInt64Array() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32"}, returnType="AtomicInt64Array.t")
    public static Value ocamljava_atomicint64array_make(Value value) throws FailException {
        try {
            return Value.createInstance(new AtomicLongArray(value.asInt32()));
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.AtomicInt64Array.make");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32", "int64"}, returnType="int64")
    public static Value ocamljava_atomicint64array_add_and_get(Value value, Value value2, Value value3) throws FailException {
        try {
            AtomicLongArray atomicLongArray = (AtomicLongArray)value.asCustom();
            long l = atomicLongArray.addAndGet(value2.asInt32(), value3.asInt64());
            return Value.createInt64(l);
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32", "int64", "int64"}, returnType="bool")
    public static Value ocamljava_atomicint64array_compare_and_set(Value value, Value value2, Value value3, Value value4) throws FailException {
        try {
            Value value5;
            AtomicLongArray atomicLongArray = (AtomicLongArray)value.asCustom();
            boolean bl = atomicLongArray.compareAndSet(value2.asInt32(), value3.asInt64(), value4.asInt64());
            if (bl) {
                value5 = Value.TRUE;
                return value5;
            }
            value5 = Value.FALSE;
            return value5;
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32"}, returnType="int64")
    public static Value ocamljava_atomicint64array_decrement_and_get(Value value, Value value2) throws FailException {
        try {
            AtomicLongArray atomicLongArray = (AtomicLongArray)value.asCustom();
            long l = atomicLongArray.decrementAndGet(value2.asInt32());
            return Value.createInt64(l);
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32"}, returnType="int64")
    public static Value ocamljava_atomicint64array_get(Value value, Value value2) throws FailException {
        try {
            AtomicLongArray atomicLongArray = (AtomicLongArray)value.asCustom();
            long l = atomicLongArray.get(value2.asInt32());
            return Value.createInt64(l);
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32", "int64"}, returnType="int64")
    public static Value ocamljava_atomicint64array_get_and_add(Value value, Value value2, Value value3) throws FailException {
        try {
            AtomicLongArray atomicLongArray = (AtomicLongArray)value.asCustom();
            long l = atomicLongArray.getAndAdd(value2.asInt32(), value3.asInt64());
            return Value.createInt64(l);
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32"}, returnType="int64")
    public static Value ocamljava_atomicint64array_get_and_decrement(Value value, Value value2) throws FailException {
        try {
            AtomicLongArray atomicLongArray = (AtomicLongArray)value.asCustom();
            long l = atomicLongArray.getAndDecrement(value2.asInt32());
            return Value.createInt64(l);
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32"}, returnType="int64")
    public static Value ocamljava_atomicint64array_get_and_increment(Value value, Value value2) throws FailException {
        try {
            AtomicLongArray atomicLongArray = (AtomicLongArray)value.asCustom();
            long l = atomicLongArray.getAndIncrement(value2.asInt32());
            return Value.createInt64(l);
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32", "int64"}, returnType="int64")
    public static Value ocamljava_atomicint64array_get_and_set(Value value, Value value2, Value value3) throws FailException {
        try {
            AtomicLongArray atomicLongArray = (AtomicLongArray)value.asCustom();
            long l = atomicLongArray.getAndSet(value2.asInt32(), value3.asInt64());
            return Value.createInt64(l);
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32"}, returnType="int64")
    public static Value ocamljava_atomicint64array_increment_and_get(Value value, Value value2) throws FailException {
        try {
            AtomicLongArray atomicLongArray = (AtomicLongArray)value.asCustom();
            long l = atomicLongArray.incrementAndGet(value2.asInt32());
            return Value.createInt64(l);
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32", "int64"}, returnType="unit")
    public static Value ocamljava_atomicint64array_lazy_set(Value value, Value value2, Value value3) throws FailException {
        try {
            AtomicLongArray atomicLongArray = (AtomicLongArray)value.asCustom();
            atomicLongArray.lazySet(value2.asInt32(), value3.asInt64());
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t"}, returnType="int32")
    public static Value ocamljava_atomicint64array_length(Value value) {
        AtomicLongArray atomicLongArray = (AtomicLongArray)value.asCustom();
        int n = atomicLongArray.length();
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32", "int64"}, returnType="unit")
    public static Value ocamljava_atomicint64array_set(Value value, Value value2, Value value3) throws FailException {
        try {
            AtomicLongArray atomicLongArray = (AtomicLongArray)value.asCustom();
            atomicLongArray.set(value2.asInt32(), value3.asInt64());
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64Array.t", "int32", "int64", "int64"}, returnType="bool")
    public static Value ocamljava_atomicint64array_weak_compare_and_set(Value value, Value value2, Value value3, Value value4) throws FailException {
        try {
            Value value5;
            AtomicLongArray atomicLongArray = (AtomicLongArray)value.asCustom();
            boolean bl = atomicLongArray.weakCompareAndSet(value2.asInt32(), value3.asInt64(), value4.asInt64());
            if (bl) {
                value5 = Value.TRUE;
                return value5;
            }
            value5 = Value.FALSE;
            return value5;
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }
}

