/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.ClosedChannelException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.stdlib.Sys;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Pervasives", source="byterun/io.c")
public final class Io {
    private Io() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="Pervasives.in_channel")
    public static Value caml_ml_open_descriptor_in(Value value) {
        return Value.createChannel(CurrentContext.FILES_STATE.getChannel(value.asCastedInt()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="Pervasives.out_channel")
    public static Value caml_ml_open_descriptor_out(Value value) {
        return Value.createChannel(CurrentContext.FILES_STATE.getChannel(value.asCastedInt()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="Pervasives.out_channel list")
    public static Value caml_ml_out_channels_list(Value value) {
        return CurrentContext.FILES_STATE.makeOutChannelsList();
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a"}, returnType="Unix.file_descr")
    public static Value caml_channel_descriptor(Value value) throws FailException {
        int n = ((Channel)value.asCustom()).getFD();
        if (n != -1) {
            return Value.createLong(n);
        }
        Sys.sysError(null, "invalid file descriptor");
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a"}, returnType="unit")
    public static Value caml_ml_close_channel(Value value) throws FailException, FalseExit {
        block4: {
            int n = ((Channel)value.asCustom()).getFD();
            if (n == -1) break block4;
            try {
                CurrentContext.FILES_STATE.closeChannel(n);
            }
            catch (InterruptedIOException interruptedIOException) {
                FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
                falseExit.fillInStackTrace();
                throw falseExit;
            }
            catch (IOException iOException) {
                Sys.sysError(null, iOException.toString());
            }
        }
        return Value.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a"}, returnType="int")
    public static Value caml_ml_channel_size(Value value) throws FailException, FalseExit {
        long l = ((Channel)value.asCustom()).size();
        if (l <= 0x3FFFFFFFFFFFFFFFL) return Value.createLong(l);
        try {
            Sys.sysError(null, "overflow");
            return Value.createLong(l);
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, "unable to determine channel size");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a"}, returnType="int64")
    public static Value caml_ml_channel_size_64(Value value) throws FailException, FalseExit {
        try {
            return Value.createInt64(((Channel)value.asCustom()).size());
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, "unable to determine channel size");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Does nothing."}, parameterTypes={"'a", "bool"}, returnType="unit")
    public static Value caml_ml_set_binary_mode(Value value, Value value2) {
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Exact synonym of [caml_ml_flush]."}, parameterTypes={"Pervasives.out_channel"}, returnType="unit")
    public static Value caml_ml_flush_partial(Value value) throws FailException, FalseExit {
        Io.caml_ml_flush(value);
        return Value.TRUE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.out_channel"}, returnType="unit")
    public static Value caml_ml_flush(Value value) throws FailException, FalseExit {
        try {
            ((Channel)value.asCustom()).flush();
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, iOException.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.out_channel", "char"}, returnType="unit")
    public static Value caml_ml_output_char(Value value, Value value2) throws FailException, FalseExit {
        try {
            ((Channel)value.asCustom()).write8u(value2.asCastedInt());
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, iOException.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.out_channel", "int"}, returnType="unit")
    public static Value caml_ml_output_int(Value value, Value value2) throws FailException, FalseExit {
        try {
            ((Channel)value.asCustom()).write32s(value2.asCastedInt());
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, iOException.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Exact synonym of [caml_ml_output]."}, parameterTypes={"Pervasives.out_channel", "string", "int", "int"}, returnType="unit")
    public static Value caml_ml_output_partial(Value value, Value value2, Value value3, Value value4) throws FailException, FalseExit {
        Io.caml_ml_output(value, value2, value3, value4);
        return value4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.out_channel", "string", "int", "int"}, returnType="unit")
    public static Value caml_ml_output(Value value, Value value2, Value value3, Value value4) throws FailException, FalseExit {
        try {
            if (value2.sizeBytes() <= Integer.MAX_VALUE) {
                ((Channel)value.asCustom()).write(value2.getBytes(), value3.asCastedInt(), value4.asCastedInt());
                return Value.UNIT;
            }
            int n = value4.asCastedInt();
            byte[] byArray = new byte[n];
            long l = value3.asLong();
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    ((Channel)value.asCustom()).write(byArray, 0, n);
                    return Value.UNIT;
                }
                byArray[n2] = value2.getByte(l + (long)n2);
                ++n2;
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, iOException.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.out_channel", "int"}, returnType="unit")
    public static Value caml_ml_seek_out(Value value, Value value2) throws FailException, FalseExit {
        try {
            ((Channel)value.asCustom()).seek(value2.asLong(), 0);
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, iOException.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.out_channel", "int64"}, returnType="unit")
    public static Value caml_ml_seek_out_64(Value value, Value value2) throws FailException, FalseExit {
        try {
            ((Channel)value.asCustom()).seek(value2.asInt64(), 0);
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, iOException.toString());
        }
        return Value.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.out_channel"}, returnType="int")
    public static Value caml_ml_pos_out(Value value) throws FailException, FalseExit {
        long l = ((Channel)value.asCustom()).position();
        if (l <= 0x3FFFFFFFFFFFFFFFL) return Value.createLong(l);
        try {
            Sys.sysError(null, "overflow");
            return Value.createLong(l);
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, "unable to determine channel position");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.out_channel"}, returnType="int64")
    public static Value caml_ml_pos_out_64(Value value) throws FailException, FalseExit {
        try {
            return Value.createInt64(((Channel)value.asCustom()).position());
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, "unable to determine channel position");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.in_channel"}, returnType="char")
    public static Value caml_ml_input_char(Value value) throws FailException, FalseExit {
        try {
            int n = ((Channel)value.asCustom()).read8u();
            return Value.createLong(n);
        }
        catch (ClosedChannelException closedChannelException) {
            Fail.raiseEndOfFile();
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, iOException.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.int_channel"}, returnType="int")
    public static Value caml_ml_input_int(Value value) throws FailException, FalseExit {
        try {
            int n = ((Channel)value.asCustom()).read32s();
            return Value.createLong(n);
        }
        catch (ClosedChannelException closedChannelException) {
            Fail.raiseEndOfFile();
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, iOException.toString());
        }
        return Value.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.in_channel", "string", "int", "int"}, returnType="int")
    public static Value caml_ml_input(Value value, Value value2, Value value3, Value value4) throws FailException, FalseExit {
        try {
            if (value2.sizeBytes() <= Integer.MAX_VALUE) {
                int n = ((Channel)value.asCustom()).read(value2.getBytesForModification(), value3.asCastedInt(), value4.asCastedInt());
                return Value.createLong(Math.max(n, 0));
            }
            int n = value4.asCastedInt();
            byte[] byArray = new byte[n];
            int n2 = ((Channel)value.asCustom()).read(byArray, 0, n);
            long l = value3.asLong();
            int n3 = 0;
            while (n3 < n) {
                value2.setByte(l + (long)n3, byArray[n3]);
                ++n3;
            }
            return Value.createLong(Math.max(n2, 0));
        }
        catch (ClosedChannelException closedChannelException) {
            Fail.raiseEndOfFile();
            return Value.UNIT;
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, iOException.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.in_channel", "int"}, returnType="unit")
    public static Value caml_ml_seek_in(Value value, Value value2) throws FailException, FalseExit {
        try {
            ((Channel)value.asCustom()).seek(value2.asLong(), 0);
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, iOException.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.in_channel", "int64"}, returnType="unit")
    public static Value caml_ml_seek_in_64(Value value, Value value2) throws FailException, FalseExit {
        try {
            ((Channel)value.asCustom()).seek(value2.asInt64(), 0);
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, iOException.toString());
        }
        return Value.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.in_channel"}, returnType="int")
    public static Value caml_ml_pos_in(Value value) throws FailException, FalseExit {
        long l = ((Channel)value.asCustom()).position();
        if (l <= 0x3FFFFFFFFFFFFFFFL) return Value.createLong(l);
        try {
            Sys.sysError(null, "overflow");
            return Value.createLong(l);
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, "unable to determine channel position");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.in_channel"}, returnType="int64")
    public static Value caml_ml_pos_in_64(Value value) throws FailException, FalseExit {
        try {
            return Value.createInt64(((Channel)value.asCustom()).position());
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, "unable to determine channel position");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.in_channel"}, returnType="int")
    public static Value caml_ml_input_scan_line(Value value) throws FailException, FalseExit {
        Channel channel = (Channel)value.asCustom();
        try {
            int n = channel.inputScanline();
            return Value.createLong(n);
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Sys.sysError(null, iOException.toString());
            return Value.UNIT;
        }
    }
}

