/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.util.Arrays;
import java.util.Map;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.values.Value;

public abstract class AbstractCodeRunner
implements CodeRunner {
    protected final Context context;
    protected Value closure;
    protected Value[] args;
    protected Value threadStatus;
    protected Map<String, Value> bindings;

    AbstractCodeRunner(Context context) {
        assert (context != null) : "null context";
        this.context = context;
        this.closure = null;
        this.args = null;
    }

    @Override
    public final Context getContext() {
        return this.context;
    }

    @Override
    public final boolean isNative() {
        return this.context.getCodeState().isNative();
    }

    @Override
    public final void setBindings(Map<String, Value> b) {
        this.bindings = b;
    }

    @Override
    public final Map<String, Value> getBindings() {
        return this.bindings;
    }

    @Override
    public final void setup(Value closure, Value ... args) {
        this.closure = closure;
        this.args = args != null ? Arrays.copyOf(args, args.length) : null;
    }

    @Override
    public final Value getThreadStatus() {
        return this.threadStatus;
    }

    @Override
    public final void setThreadStatus(Value ts) {
        assert (ts != null) : "null ts";
        this.threadStatus = ts;
    }

    @Override
    public final Value callback(String function, Value ... params) throws FailException, FatalError, FalseExit, OCamlJavaException {
        assert (function != null) : "null function";
        assert (params != null) : "null params";
        assert (params.length + 4 <= 256) : "params is too long";
        Value closure = this.context.getCodeState().getCallback(function);
        if (closure == null) {
            throw new OCamlJavaException("unknown callback " + function);
        }
        return this.callback(closure, params);
    }

    public static Value getMethod(Value obj, long tag) {
        Value meths = obj.get0();
        long li = 3L;
        long hi = meths.get0().getRawValue();
        while (li < hi) {
            long mi = li + hi >> 1 | 1L;
            if (tag < meths.get(mi).getRawValue()) {
                hi = mi - 2L;
                continue;
            }
            li = mi;
        }
        return tag == meths.get(li).getRawValue() ? meths.get(li - 1L) : Value.ZERO;
    }
}

