/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.threads;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.St_stubs;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.ThreadStatus;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="threads", module="Thread", source="otherlibs/threads/scheduler.c")
public final class Scheduler {
    private static final long TERMINATED = 2L;
    private static final Value RESUMED_IO = Value.THREE;
    private static final double MILLISECS_PER_SEC = 1000.0;

    private Scheduler() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value thread_initialize(Value value) {
        return St_stubs.caml_thread_initialize(value);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value thread_initialize_preemption(Value value) {
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"(unit -> unit)"}, returnType="Thread.t")
    public static Value thread_new(Value value) {
        return St_stubs.caml_thread_new(value);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Thread.t"}, returnType="int")
    public static Value thread_id(Value value) {
        return St_stubs.caml_thread_id(value);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value thread_yield(Value value) throws FalseExit, FailException {
        return St_stubs.caml_thread_yield(value);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value thread_request_reschedule(Value value) throws FalseExit, FailException {
        return Scheduler.thread_yield(value);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value thread_sleep(Value value) throws FalseExit, FailException {
        Context context = CurrentContext.CONTEXT;
        Thread thread = Thread.currentThread();
        if (thread instanceof OCamlJavaThread) {
            ((OCamlJavaThread)thread).pause();
        } else assert (false) : "current thread should be an OCamlJavaThread";
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_desct"}, returnType="unit")
    public static Value thread_wait_read(Value value) {
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr"}, returnType="unit")
    public static Value thread_wait_write(Value value) {
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr * float"}, returnType="Thread.resumption_status")
    public static Value thread_wait_timed_read(Value value) {
        return RESUMED_IO;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr * float"}, returnType="Thread.resumption_status")
    public static Value thread_wait_timed_write(Value value) {
        return RESUMED_IO;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr list * Unix.file_descr list * Unix.file_descr list * float"}, returnType="Thread.resumption_status")
    public static Value thread_select(Value value) throws FalseExit, FailException {
        return Scheduler.thread_yield(value);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Always returns [true]."}, parameterTypes={"Pervasives.in_channel"}, returnType="bool")
    public static Value thread_inchan_ready(Value value) {
        return Value.TRUE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Always returns [true]."}, parameterTypes={"Pervasives.out_channel", "int"}, returnType="bool")
    public static Value thread_outchan_ready(Value value, Value value2) {
        return Value.TRUE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="unit")
    public static Value thread_delay(Value value) throws FalseExit, FailException {
        Context context = CurrentContext.CONTEXT;
        try {
            Thread.sleep((long)(value.asDouble() * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            FalseExit falseExit = FalseExit.createFromContext(context);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Thread.t"}, returnType="unit")
    public static Value thread_join(Value value) throws FalseExit, FailException {
        return St_stubs.caml_thread_join(value);
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Does nothing, returning immediately."}, parameterTypes={"int"}, returnType="Thread.resumption_status")
    public static Value thread_wait_pid(Value value) {
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Thread.t"}, returnType="unit")
    public static Value thread_wakeup(Value value) throws FailException {
        ThreadStatus threadStatus = (ThreadStatus)value.get(2L).asCustom();
        if (!threadStatus.isAlive()) {
            Fail.failWith("Thread.wakeup: killed thread");
        } else if (!threadStatus.isSuspended()) {
            Fail.failWith("Thread.wakeup: thread not suspended");
        } else {
            threadStatus.resume();
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="Thread.t")
    public static Value thread_self(Value value) throws FailException {
        return St_stubs.caml_thread_self(value);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Thread.t"}, returnType="unit")
    public static Value thread_kill(Value value) {
        ((ThreadStatus)value.get(2L).asCustom()).terminate();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"exn"}, returnType="unit")
    public static Value thread_uncaught_exception(Value value) throws FalseExit, FailException {
        return St_stubs.caml_thread_uncaught_exception(value);
    }
}

