/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Iterator;
import java.util.Map;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.WrappedCommand;

class InterpAliasCmd
implements CommandWithDispose {
    TclObject name;
    private Interp targetInterp;
    private TclObject prefix;
    private WrappedCommand slaveCmd;
    private String aliasEntry;
    private Interp slaveInterp;

    InterpAliasCmd() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        this.targetInterp.preserve();
        try {
            ++this.targetInterp.nestLevel;
            this.targetInterp.resetResult();
            this.targetInterp.allowExceptions();
            TclObject[] prefv = TclList.getElements(interp, this.prefix);
            TclObject cmd = TclList.newInstance();
            cmd.preserve();
            TclList.replace(interp, cmd, 0, 0, prefv, 0, prefv.length - 1);
            TclList.replace(interp, cmd, prefv.length, 0, argv, 1, argv.length - 1);
            TclObject[] cmdv = TclList.getElements(interp, cmd);
            int result = this.targetInterp.invoke(cmdv, 4);
            cmd.release();
            --this.targetInterp.nestLevel;
            if (this.targetInterp.nestLevel == 0) {
                if (result == 2) {
                    result = this.targetInterp.updateReturnInfo();
                }
                if (result != 0 && result != 1) {
                    try {
                        this.targetInterp.processUnexpectedResult(result);
                    }
                    catch (TclException e) {
                        result = e.getCompletionCode();
                    }
                }
            }
            interp.transferResult(this.targetInterp, result);
        }
        finally {
            this.targetInterp.release();
        }
    }

    public void disposeCmd() {
        if (this.aliasEntry != null) {
            this.slaveInterp.aliasTable.remove(this.aliasEntry);
        }
        if (this.slaveCmd != null) {
            this.targetInterp.targetTable.remove(this.slaveCmd);
        }
        this.name.release();
        this.prefix.release();
    }

    static void create(Interp interp, Interp slaveInterp, Interp masterInterp, TclObject name, TclObject targetName, int objIx, TclObject[] objv) throws TclException {
        String string = name.toString();
        InterpAliasCmd alias = new InterpAliasCmd();
        alias.name = name;
        name.preserve();
        alias.slaveInterp = slaveInterp;
        alias.targetInterp = masterInterp;
        alias.prefix = TclList.newInstance();
        alias.prefix.preserve();
        TclList.append(interp, alias.prefix, targetName);
        TclList.insert(interp, alias.prefix, 1, objv, objIx, objv.length - 1);
        slaveInterp.createCommand(string, (Command)alias);
        alias.slaveCmd = Namespace.findCommand(slaveInterp, string, null, 0);
        try {
            interp.preventAliasLoop(slaveInterp, alias.slaveCmd);
        }
        catch (TclException e) {
            slaveInterp.deleteCommandFromToken(alias.slaveCmd);
            throw e;
        }
        if (slaveInterp.aliasTable.containsKey(string)) {
            InterpAliasCmd oldAlias = (InterpAliasCmd)slaveInterp.aliasTable.get(string);
            slaveInterp.deleteCommandFromToken(oldAlias.slaveCmd);
        }
        alias.aliasEntry = string;
        slaveInterp.aliasTable.put(string, alias);
        masterInterp.targetTable.put(alias.slaveCmd, slaveInterp);
        interp.setResult(name);
    }

    static void delete(Interp interp, Interp slaveInterp, TclObject name) throws TclException {
        String string = name.toString();
        if (!slaveInterp.aliasTable.containsKey(string)) {
            throw new TclException(interp, "alias \"" + string + "\" not found");
        }
        InterpAliasCmd alias = (InterpAliasCmd)slaveInterp.aliasTable.get(string);
        slaveInterp.deleteCommandFromToken(alias.slaveCmd);
    }

    static void describe(Interp interp, Interp slaveInterp, TclObject name) throws TclException {
        String string = name.toString();
        if (slaveInterp.aliasTable.containsKey(string)) {
            InterpAliasCmd alias = (InterpAliasCmd)slaveInterp.aliasTable.get(string);
            interp.setResult(alias.prefix);
        }
    }

    static void list(Interp interp, Interp slaveInterp) throws TclException {
        TclObject result = TclList.newInstance();
        Iterator iter = slaveInterp.aliasTable.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            InterpAliasCmd alias = (InterpAliasCmd)entry.getValue();
            TclList.append(interp, result, alias.name);
        }
        interp.setResult(result);
    }

    WrappedCommand getTargetCmd(Interp interp) throws TclException {
        TclObject[] objv = TclList.getElements(interp, this.prefix);
        String targetName = objv[0].toString();
        return Namespace.findCommand(this.targetInterp, targetName, null, 0);
    }

    static Interp getTargetInterp(Interp slaveInterp, String aliasName) {
        if (!slaveInterp.aliasTable.containsKey(aliasName)) {
            return null;
        }
        InterpAliasCmd alias = (InterpAliasCmd)slaveInterp.aliasTable.get(aliasName);
        return alias.targetInterp;
    }
}

