/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import tcl.lang.CallFrame;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.SearchId;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TclVarException;
import tcl.lang.TraceRecord;
import tcl.lang.Util;
import tcl.lang.VarTrace;

public class Var {
    static final int SCALAR = 1;
    static final int ARRAY = 2;
    static final int LINK = 4;
    static final int UNDEFINED = 8;
    static final int IN_HASHTABLE = 16;
    static final int TRACE_ACTIVE = 32;
    static final int ARRAY_ELEMENT = 64;
    static final int NAMESPACE_VAR = 128;
    static final int NO_CACHE = 256;
    static final int NON_LOCAL = 512;
    static final int TRACE_EXISTS = 1024;
    static final int EXPLICIT_LOCAL_NAME = 4096;
    TclObject tobj = null;
    HashMap arraymap = null;
    Var linkto = null;
    ArrayList traces = null;
    ArrayList sidVec = null;
    int flags = 25;
    HashMap table = null;
    String hashKey = null;
    int refCount = 0;
    Namespace ns = null;
    static final String noSuchVar = "no such variable";
    static final String isArray = "variable is array";
    static final String needArray = "variable isn't array";
    static final String noSuchElement = "no such element in array";
    static final String danglingElement = "upvar refers to element in deleted array";
    static final String danglingVar = "upvar refers to variable in deleted namespace";
    static final String badNamespace = "parent namespace doesn't exist";
    static final String missingName = "missing variable name";

    final boolean isVarScalar() {
        return (this.flags & 1) != 0;
    }

    final boolean isVarLink() {
        return (this.flags & 4) != 0;
    }

    final boolean isVarArray() {
        return (this.flags & 2) != 0;
    }

    final boolean isVarUndefined() {
        return (this.flags & 8) != 0;
    }

    final boolean isVarArrayElement() {
        return (this.flags & 0x40) != 0;
    }

    final boolean isVarNamespace() {
        return (this.flags & 0x80) != 0;
    }

    final boolean isVarInHashtable() {
        return (this.flags & 0x10) != 0;
    }

    final boolean isVarTraceExists() {
        return (this.flags & 0x400) != 0;
    }

    final boolean isVarNoCache() {
        return (this.flags & 0x100) != 0;
    }

    final boolean isVarNonLocal() {
        return (this.flags & 0x200) != 0;
    }

    final void setVarScalar() {
        this.flags = this.flags & 0xFFFFFFF9 | 1;
    }

    final void setVarArray() {
        this.flags = this.flags & 0xFFFFFFFA | 2;
    }

    final void setVarLink() {
        this.flags = this.flags & 0xFFFFFFFC | 4;
    }

    final void setVarArrayElement() {
        this.flags = this.flags & 0xFFFFFFFD | 0x40;
    }

    final void setVarUndefined() {
        this.flags |= 8;
    }

    final void setVarNamespace() {
        this.flags |= 0x80;
    }

    final void setVarInHashtable() {
        this.flags |= 0x10;
    }

    final void setVarNonLocal() {
        this.flags |= 0x200;
    }

    final void setVarNoCache() {
        this.flags |= 0x100;
    }

    final void setVarTraceExists() {
        this.flags |= 0x400;
    }

    final void clearVarUndefined() {
        this.flags &= 0xFFFFFFF7;
    }

    final void clearVarInHashtable() {
        this.flags &= 0xFFFFFFEF;
    }

    final void clearVarTraceExists() {
        this.flags &= 0xFFFFFBFF;
    }

    Var() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.ns != null) {
            sb.append(this.ns.fullName);
            if (this.ns.fullName.equals("::")) {
                sb.append(this.hashKey);
            } else {
                sb.append("::");
                sb.append(this.hashKey);
            }
        } else {
            sb.append(this.hashKey);
        }
        if (this.isVarScalar()) {
            sb.append(" ");
            sb.append("SCALAR");
        }
        if (this.isVarLink()) {
            sb.append(" ");
            sb.append("LINK");
        }
        if (this.isVarArray()) {
            sb.append(" ");
            sb.append("ARRAY");
        }
        if (this.isVarUndefined()) {
            sb.append(" ");
            sb.append("UNDEFINED");
        }
        if (this.isVarArrayElement()) {
            sb.append(" ");
            sb.append("ARRAY_ELEMENT");
        }
        if (this.isVarNamespace()) {
            sb.append(" ");
            sb.append("NAMESPACE_VAR");
        }
        if (this.isVarInHashtable()) {
            sb.append(" ");
            sb.append("IN_HASHTABLE");
        }
        if (this.isVarTraceExists()) {
            sb.append(" ");
            sb.append("TRACE_EXISTS");
        }
        if (this.isVarNoCache()) {
            sb.append(" ");
            sb.append("NO_CACHE");
        }
        return sb.toString();
    }

    protected int getNextIndex() {
        int size = this.sidVec.size();
        if (size == 0) {
            return 1;
        }
        SearchId sid = (SearchId)this.sidVec.get(size - 1);
        return sid.getIndex() + 1;
    }

    protected Iterator getSearch(String s) {
        for (int i = 0; i < this.sidVec.size(); ++i) {
            SearchId sid = (SearchId)this.sidVec.get(i);
            if (!sid.equals(s)) continue;
            return sid.getIterator();
        }
        return null;
    }

    protected boolean removeSearch(String sid) {
        for (int i = 0; i < this.sidVec.size(); ++i) {
            SearchId curSid = (SearchId)this.sidVec.get(i);
            if (!curSid.equals(sid)) continue;
            this.sidVec.remove(i);
            return true;
        }
        return false;
    }

    public static final boolean isArrayVarname(String varName) {
        int lastInd = varName.length() - 1;
        return varName.charAt(lastInd) == ')' && varName.indexOf(40) != -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Var[] lookupVar(Interp interp, String part1, String part2, int flags, String msg, boolean createPart1, boolean createPart2) throws TclException {
        CallFrame varFrame = interp.varFrame;
        Var var = null;
        Namespace varNs = null;
        String elName = part2;
        int openParen = -1;
        int lastInd = part1.length() - 1;
        if (lastInd > 0 && part1.charAt(lastInd) == ')') {
            openParen = part1.indexOf(40);
        }
        if (openParen != -1) {
            if (part2 != null) {
                if ((flags & 0x200) != 0) {
                    throw new TclVarException(interp, part1, part2, msg, needArray);
                }
                return null;
            }
            part2 = elName = part1.substring(openParen + 1, lastInd);
            part1 = part1.substring(0, openParen);
        }
        Namespace cxtNs = (flags & 1) != 0 || interp.varFrame == null ? interp.globalNs : interp.varFrame.ns;
        if (cxtNs.resolver != null || interp.resolvers != null) {
            try {
                if (cxtNs.resolver != null) {
                    var = cxtNs.resolver.resolveVar(interp, part1, cxtNs, flags);
                    if (var != null) {
                        var.setVarNoCache();
                    }
                } else {
                    var = null;
                }
                if (var == null && interp.resolvers != null) {
                    ListIterator iter = interp.resolvers.listIterator();
                    while (var == null && iter.hasNext()) {
                        Interp.ResolverScheme res = (Interp.ResolverScheme)iter.next();
                        var = res.resolver.resolveVar(interp, part1, cxtNs, flags);
                        if (var == null) continue;
                        var.setVarNoCache();
                    }
                }
            }
            catch (TclException e) {
                var = null;
            }
        }
        if ((flags & 3) != 0 || varFrame == null || !varFrame.isProcCallFrame || part1.indexOf("::") != -1) {
            var = Namespace.findNamespaceVar(interp, part1, null, flags & 0xFFFFFDFF);
            if (var == null) {
                if (createPart1) {
                    Namespace.GetNamespaceForQualNameResult gnfqnr = interp.getnfqnResult;
                    Namespace.getNamespaceForQualName(interp, part1, null, flags, gnfqnr);
                    varNs = gnfqnr.ns;
                    String tail = gnfqnr.simpleName;
                    if (varNs == null) {
                        if ((flags & 0x200) != 0) {
                            throw new TclVarException(interp, part1, part2, msg, badNamespace);
                        }
                        return null;
                    }
                    if (tail == null) {
                        if ((flags & 0x200) != 0) {
                            throw new TclVarException(interp, part1, part2, msg, missingName);
                        }
                        return null;
                    }
                    var = new Var();
                    varNs.varTable.put(tail, var);
                    var.hashKey = tail;
                    var.table = varNs.varTable;
                    var.ns = varNs;
                } else {
                    if ((flags & 0x200) != 0) {
                        throw new TclVarException(interp, part1, part2, msg, noSuchVar);
                    }
                    return null;
                }
            }
        } else {
            if (varFrame.compiledLocals != null) {
                Var[] compiledLocals = varFrame.compiledLocals;
                String[] compiledLocalsNames = varFrame.compiledLocalsNames;
                int MAX = compiledLocals.length;
                for (int i = 0; i < MAX; ++i) {
                    if (!compiledLocalsNames[i].equals(part1)) continue;
                    Var clocal = compiledLocals[i];
                    if (clocal == null) {
                        if (!createPart1) break;
                        var = new Var();
                        var.hashKey = part1;
                        var.clearVarInHashtable();
                        compiledLocals[i] = var;
                        break;
                    }
                    if (clocal.isVarNonLocal()) {
                        throw new TclRuntimeError("can't lookup scoped variable \"" + part1 + "\" in local table");
                    }
                    var = clocal;
                    break;
                }
            }
            if (var == null) {
                HashMap<String, Var> table = varFrame.varTable;
                if (createPart1) {
                    if (table == null) {
                        varFrame.varTable = table = new HashMap<String, Var>();
                    }
                    if ((var = (Var)table.get(part1)) == null) {
                        var = new Var();
                        table.put(part1, var);
                        var.hashKey = part1;
                        var.table = table;
                    }
                } else {
                    if (table != null) {
                        var = (Var)table.get(part1);
                    }
                    if (var == null) {
                        if ((flags & 0x200) != 0) {
                            throw new TclVarException(interp, part1, part2, msg, noSuchVar);
                        }
                        return null;
                    }
                }
            }
        }
        while (var.isVarLink()) {
            var = var.linkto;
        }
        if (elName == null) {
            Var[] ret = interp.lookupVarResult;
            ret[0] = var;
            ret[1] = null;
            return ret;
        }
        return Var.lookupArrayElement(interp, part1, elName, flags, msg, createPart1, createPart2, var);
    }

    static Var[] lookupArrayElement(Interp interp, String part1, String part2, int flags, String msg, boolean createPart1, boolean createPart2, Var var) throws TclException {
        if (var.isVarUndefined() && !var.isVarArrayElement()) {
            if (!createPart1) {
                if ((flags & 0x200) != 0) {
                    throw new TclVarException(interp, part1, part2, msg, noSuchVar);
                }
                return null;
            }
            if ((var.flags & 0x10) != 0 && var.table == null) {
                if ((flags & 0x200) != 0) {
                    throw new TclVarException(interp, part1, part2, msg, danglingVar);
                }
                return null;
            }
            var.setVarArray();
            var.clearVarUndefined();
            var.arraymap = new HashMap();
        } else if (!var.isVarArray()) {
            if ((flags & 0x200) != 0) {
                throw new TclVarException(interp, part1, part2, msg, needArray);
            }
            return null;
        }
        Var arrayVar = var;
        HashMap arrayTable = var.arraymap;
        if (createPart2) {
            Var searchvar = (Var)arrayTable.get(part2);
            if (searchvar == null) {
                if (var.sidVec != null) {
                    Var.deleteSearches(var);
                }
                var = new Var();
                arrayTable.put(part2, var);
                var.hashKey = part2;
                var.table = arrayTable;
                var.ns = arrayVar.ns;
                var.setVarArrayElement();
            } else {
                var = searchvar;
            }
        } else {
            var = (Var)arrayTable.get(part2);
            if (var == null) {
                if ((flags & 0x200) != 0) {
                    throw new TclVarException(interp, part1, part2, msg, noSuchElement);
                }
                return null;
            }
        }
        Var[] ret = interp.lookupVarResult;
        ret[0] = var;
        ret[1] = arrayVar;
        return ret;
    }

    static TclObject getVar(Interp interp, String part1, String part2, int flags) throws TclException {
        Var[] result = Var.lookupVar(interp, part1, part2, flags, "read", false, true);
        if (result == null) {
            return null;
        }
        return Var.getVarPtr(interp, result[0], result[1], part1, part2, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TclObject getVarPtr(Interp interp, Var var, Var array, String part1, String part2, int flags) throws TclException {
        try {
            Object msg;
            if ((var.traces != null || array != null && array.traces != null) && (msg = Var.callTraces(interp, array, var, part1, part2, flags & 3 | 0x10)) != null) {
                if ((flags & 0x200) != 0) {
                    throw new TclVarException(interp, part1, part2, "read", (String)msg);
                }
                TclObject tclObject = null;
                return tclObject;
            }
            if (var.isVarScalar() && !var.isVarUndefined()) {
                msg = var.tobj;
                return msg;
            }
            if ((flags & 0x200) != 0) {
                msg = var.isVarUndefined() && array != null && !array.isVarUndefined() ? noSuchElement : (var.isVarArray() ? isArray : noSuchVar);
                throw new TclVarException(interp, part1, part2, "read", (String)msg);
            }
        }
        finally {
            if (var.isVarUndefined()) {
                Var.cleanupVar(var, array);
            }
        }
        return null;
    }

    static TclObject setVar(Interp interp, String part1, String part2, TclObject newValue, int flags) throws TclException {
        Var[] result = Var.lookupVar(interp, part1, part2, flags, "set", true, true);
        if (result == null) {
            return null;
        }
        return Var.setVarPtr(interp, result[0], result[1], part1, part2, newValue, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TclObject setVarPtr(Interp interp, Var var, Var array, String part1, String part2, TclObject newValue, int flags) throws TclException {
        if ((var.flags & 0x10) != 0 && var.table == null) {
            if ((flags & 0x200) != 0) {
                if (var.isVarArrayElement()) {
                    throw new TclVarException(interp, part1, part2, "set", danglingElement);
                }
                throw new TclVarException(interp, part1, part2, "set", danglingVar);
            }
            return null;
        }
        if (var.isVarArray() && !var.isVarUndefined()) {
            if ((flags & 0x200) != 0) {
                throw new TclVarException(interp, part1, part2, "set", isArray);
            }
            return null;
        }
        try {
            String msg;
            TclObject oldValue = var.tobj;
            if ((flags & 4) != 0) {
                if (var.isVarUndefined() && oldValue != null) {
                    oldValue.release();
                    var.tobj = null;
                    oldValue = null;
                }
                if ((flags & 8) != 0) {
                    if (oldValue == null) {
                        var.tobj = oldValue = TclList.newInstance();
                        oldValue.preserve();
                    } else if (oldValue.isShared()) {
                        var.tobj = oldValue.duplicate();
                        oldValue.release();
                        oldValue = var.tobj;
                        oldValue.preserve();
                    }
                    TclList.append(interp, oldValue, newValue);
                } else {
                    String bytes = newValue.toString();
                    if (oldValue == null) {
                        var.tobj = TclString.newInstance((String)bytes);
                        var.tobj.preserve();
                    } else {
                        if (oldValue.isShared()) {
                            var.tobj = oldValue.duplicate();
                            oldValue.release();
                            oldValue = var.tobj;
                            oldValue.preserve();
                        }
                        TclString.append((TclObject)oldValue, (String)bytes);
                    }
                }
            } else if ((flags & 8) != 0) {
                if (oldValue != null) {
                    oldValue.release();
                }
                String bytes = newValue.toString();
                int listFlags = Util.scanElement(interp, bytes);
                StringBuffer sb = new StringBuffer(64);
                Util.convertElement(bytes, listFlags, sb);
                var.tobj = oldValue = TclString.newInstance((String)sb.toString());
                var.tobj.preserve();
            } else if (newValue != oldValue) {
                var.tobj = newValue;
                newValue.preserve();
                if (oldValue != null) {
                    oldValue.release();
                }
            }
            var.setVarScalar();
            var.clearVarUndefined();
            if (array != null) {
                array.clearVarUndefined();
            }
            if ((var.traces != null || array != null && array.traces != null) && (msg = Var.callTraces(interp, array, var, part1, part2, flags & 3 | 0x20)) != null) {
                if ((flags & 0x200) != 0) {
                    throw new TclVarException(interp, part1, part2, "set", msg);
                }
                TclObject tclObject = null;
                return tclObject;
            }
            if (var.isVarScalar() && !var.isVarUndefined()) {
                TclObject tclObject = var.tobj;
                return tclObject;
            }
            TclObject tclObject = TclString.newInstance((String)"");
            return tclObject;
        }
        finally {
            if (var.isVarUndefined()) {
                Var.cleanupVar(var, array);
            }
        }
    }

    static TclObject initVarCompiledLocalScalar(Interp interp, String varname, TclObject newValue, Var[] compiledLocals, int localIndex) throws TclException {
        boolean validate = false;
        Var var = new Var();
        var.flags = 1;
        var.hashKey = varname;
        var.tobj = newValue;
        newValue.preserve();
        compiledLocals[localIndex] = var;
        return newValue;
    }

    static TclObject setVarCompiledLocalScalarInvalid(Interp interp, String varname, TclObject newValue) throws TclException {
        boolean validate = false;
        return Var.setVar(interp, varname, null, newValue, 512);
    }

    static TclObject getVarCompiledLocalScalarInvalid(Interp interp, String varname) throws TclException {
        boolean validate = false;
        return Var.getVar(interp, varname, null, 512);
    }

    static TclObject initVarCompiledLocalArray(Interp interp, String varname, String key, TclObject newValue, Var[] compiledLocals, int localIndex) throws TclException {
        boolean validate = false;
        Var var = new Var();
        var.clearVarInHashtable();
        var.hashKey = varname;
        compiledLocals[localIndex] = var;
        return Var.setVar(interp, varname, key, newValue, 512);
    }

    static TclObject setVarCompiledLocalArrayInvalid(Interp interp, String varname, String key, TclObject newValue) throws TclException {
        boolean validate = false;
        return Var.setVar(interp, varname, key, newValue, 512);
    }

    static TclObject getVarCompiledLocalArrayInvalid(Interp interp, String varname, String key) throws TclException {
        boolean validate = false;
        return Var.getVar(interp, varname, key, 512);
    }

    static TclObject getVarCompiledLocalArray(Interp interp, String varname, String key, Var resolved, boolean leaveErrMsg) throws TclException {
        Var[] result;
        int flags = 0;
        if (leaveErrMsg) {
            flags = 512;
        }
        if ((result = Var.lookupArrayElement(interp, varname, key, flags, "read", false, false, resolved)) == null) {
            return null;
        }
        return Var.getVarPtr(interp, result[0], result[1], varname, key, 512);
    }

    static TclObject setVarCompiledLocalArray(Interp interp, String varname, String key, TclObject newValue, Var resolved) throws TclException {
        int flags = 512;
        Var[] result = Var.lookupArrayElement(interp, varname, key, 512, "set", false, true, resolved);
        return Var.setVarPtr(interp, result[0], result[1], varname, key, newValue, 512);
    }

    static TclObject incrVar(Interp interp, String part1, String part2, int incrAmount, int flags) throws TclException {
        TclObject varValue = null;
        boolean err = false;
        try {
            try {
                varValue = Var.getVar(interp, part1, part2, flags);
            }
            catch (TclException e) {
                err = true;
                throw e;
            }
            Object var11_7 = null;
            if (err || varValue == null) {
                interp.addErrorInfo("\n    (reading value of variable to increment)");
            }
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            if (err || varValue == null) {
                interp.addErrorInfo("\n    (reading value of variable to increment)");
            }
            throw throwable;
        }
        boolean createdNewObj = false;
        if (varValue.isShared()) {
            varValue = varValue.duplicate();
            createdNewObj = true;
        }
        try {
            TclInteger.incr((Interp)interp, (TclObject)varValue, (int)incrAmount);
        }
        catch (TclException e) {
            if (createdNewObj) {
                varValue.release();
            }
            throw e;
        }
        return Var.setVar(interp, part1, part2, varValue, flags);
    }

    static void unsetVar(Interp interp, String part1, String part2, int flags) throws TclException {
        boolean result;
        Var[] lookup_result = Var.lookupVar(interp, part1, part2, flags, "unset", false, false);
        if (lookup_result == null) {
            throw new TclRuntimeError("unexpected null reference");
        }
        Var var = lookup_result[0];
        Var array = lookup_result[1];
        boolean bl = result = var.isVarUndefined();
        if (array != null && array.sidVec != null) {
            Var.deleteSearches(array);
        }
        Var dummyVar = new Var();
        dummyVar.tobj = var.tobj;
        dummyVar.arraymap = var.arraymap;
        dummyVar.linkto = var.linkto;
        dummyVar.traces = var.traces;
        dummyVar.flags = var.flags;
        dummyVar.hashKey = var.hashKey;
        dummyVar.table = var.table;
        dummyVar.refCount = var.refCount;
        dummyVar.ns = var.ns;
        var.setVarUndefined();
        var.setVarScalar();
        var.tobj = null;
        var.arraymap = null;
        var.linkto = null;
        var.traces = null;
        var.sidVec = null;
        if (dummyVar.traces != null || array != null && array.traces != null) {
            ++var.refCount;
            dummyVar.flags &= 0xFFFFFFDF;
            Var.callTraces(interp, array, dummyVar, part1, part2, flags & 3 | 0x40);
            dummyVar.traces = null;
            --var.refCount;
        }
        if (dummyVar.isVarArray() && !dummyVar.isVarUndefined()) {
            Var.deleteArray(interp, part1, dummyVar, flags & 3 | 0x40);
        }
        if (dummyVar.isVarScalar() && dummyVar.tobj != null) {
            TclObject obj = dummyVar.tobj;
            obj.release();
            dummyVar.tobj = null;
        }
        if ((var.flags & 0x80) != 0) {
            var.flags &= 0xFFFFFF7F;
            --var.refCount;
        }
        Var.cleanupVar(var, array);
        Var.setUndefinedToNull(interp, part1, part2);
        if (result && (flags & 0x200) != 0) {
            throw new TclVarException(interp, part1, part2, "unset", array == null ? noSuchVar : noSuchElement);
        }
    }

    static void traceVar(Interp interp, String part1, String part2, int flags, VarTrace proc) throws TclException {
        Var[] result = Var.lookupVar(interp, part1, part2, flags | 0x200, "trace", true, true);
        if (result == null) {
            throw new TclException(interp, "");
        }
        Var var = result[0];
        Var array = result[1];
        if (var.traces == null) {
            var.setVarTraceExists();
            var.traces = new ArrayList();
        }
        TraceRecord rec = new TraceRecord();
        rec.trace = proc;
        rec.flags = flags & 0x870;
        var.traces.add(0, rec);
    }

    static void untraceVar(Interp interp, String part1, String part2, int flags, VarTrace proc) {
        Var[] result = null;
        try {
            result = Var.lookupVar(interp, part1, part2, flags & 3, null, false, false);
            if (result == null) {
                return;
            }
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
        }
        Var var = result[0];
        if (var.traces != null) {
            int len = var.traces.size();
            for (int i = 0; i < len; ++i) {
                TraceRecord rec = (TraceRecord)var.traces.get(i);
                if (rec.trace != proc) continue;
                var.traces.remove(i);
                break;
            }
            if (var.traces.size() == 0) {
                var.traces = null;
                var.clearVarTraceExists();
            }
        }
        if (var.isVarUndefined()) {
            Var.cleanupVar(var, null);
        }
    }

    protected static ArrayList getTraces(Interp interp, String part1, String part2, int flags) throws TclException {
        Var[] result = Var.lookupVar(interp, part1, part2, flags & 3, null, false, false);
        if (result == null) {
            return null;
        }
        return result[0].traces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void makeUpvar(Interp interp, CallFrame frame, String otherP1, String otherP2, int otherFlags, String myName, int myFlags, int localIndex) throws TclException {
        Var var;
        Var[] result = null;
        CallFrame savedFrame = null;
        boolean newvar = false;
        boolean foundInCompiledLocalsArray = false;
        boolean foundInLocalTable = false;
        Var[] compiledLocals = null;
        try {
            if ((otherFlags & 2) == 0) {
                savedFrame = interp.varFrame;
                interp.varFrame = frame;
            }
            int otherLookupFlags = otherFlags | 0x200;
            if ((myFlags & 0x1000) != 0) {
                otherLookupFlags = otherFlags;
            }
            result = Var.lookupVar(interp, otherP1, otherP2, otherLookupFlags, "access", true, true);
            Object var24_17 = null;
            if ((otherFlags & 2) == 0) {
                interp.varFrame = savedFrame;
            }
        }
        catch (Throwable throwable) {
            Object var24_18 = null;
            if ((otherFlags & 2) == 0) {
                interp.varFrame = savedFrame;
            }
            throw throwable;
        }
        if (result == null) {
            return;
        }
        Var other = result[0];
        Var array = result[1];
        if (other == null) {
            throw new TclRuntimeError("unexpected null reference");
        }
        if (other.isVarLink()) {
            throw new TclRuntimeError("other var resolved to a link var");
        }
        CallFrame varFrame = interp.varFrame;
        if ((myFlags & 3) != 0 || varFrame == null || !varFrame.isProcCallFrame || myName.indexOf("::") != -1 && (myFlags & 0x1000) == 0) {
            Namespace.GetNamespaceForQualNameResult gnfqnr = interp.getnfqnResult;
            Namespace.getNamespaceForQualName(interp, myName, null, myFlags, gnfqnr);
            Namespace ns = gnfqnr.ns;
            Namespace altNs = gnfqnr.altNs;
            String tail = gnfqnr.simpleName;
            if (ns == null) {
                ns = altNs;
            }
            if (ns == null) {
                throw new TclException(interp, "bad variable name \"" + myName + "\": unknown namespace");
            }
            if ((otherP2 != null ? array.ns : other.ns) == null) {
                throw new TclException(interp, "bad variable name \"" + myName + "\": upvar won't create namespace variable that refers to procedure variable");
            }
            var = (Var)ns.varTable.get(tail);
            if (var == null) {
                newvar = true;
                var = new Var();
                ns.varTable.put(tail, var);
                var.hashKey = tail;
                var.table = ns.varTable;
                var.ns = ns;
            }
        } else {
            var = null;
            compiledLocals = varFrame.compiledLocals;
            if (compiledLocals != null) {
                if (localIndex == -1) {
                    int MAX = compiledLocals.length;
                    String[] compiledLocalsNames = varFrame.compiledLocalsNames;
                    for (int i = 0; i < MAX; ++i) {
                        if (!compiledLocalsNames[i].equals(myName)) continue;
                        foundInCompiledLocalsArray = true;
                        localIndex = i;
                        var = compiledLocals[i];
                        break;
                    }
                } else {
                    foundInCompiledLocalsArray = true;
                    var = compiledLocals[localIndex];
                }
            }
            if (!foundInCompiledLocalsArray) {
                HashMap<String, Var> table = varFrame.varTable;
                if (table == null) {
                    varFrame.varTable = table = new HashMap<String, Var>();
                }
                if (table != null) {
                    var = (Var)table.get(myName);
                }
                if (var == null) {
                    newvar = true;
                    var = new Var();
                    table.put(myName, var);
                    var.hashKey = myName;
                    var.table = table;
                }
                if (var != null) {
                    foundInLocalTable = true;
                }
            }
            if (foundInCompiledLocalsArray && var == null) {
                newvar = true;
                var = new Var();
                var.hashKey = myName;
                var.clearVarInHashtable();
            }
        }
        if (!newvar) {
            if (var == other) {
                throw new TclException(interp, "can't upvar from variable to itself");
            }
            if (var.isVarLink()) {
                Var link = var.linkto;
                if (link == other) {
                    return;
                }
                --link.refCount;
                if (link.isVarUndefined()) {
                    Var.cleanupVar(link, null);
                }
            } else {
                if (!var.isVarUndefined()) {
                    throw new TclException(interp, "variable \"" + myName + "\" already exists");
                }
                if (var.traces != null) {
                    throw new TclException(interp, "variable \"" + myName + "\" has traces: can't use for upvar");
                }
            }
        }
        var.setVarLink();
        var.clearVarUndefined();
        var.linkto = other;
        ++other.refCount;
        if (foundInCompiledLocalsArray) {
            if (newvar) {
                compiledLocals[localIndex] = var;
            }
            if ((myFlags & 0x1000) != 0) {
                var.setVarNonLocal();
            }
        }
    }

    public static String getVariableFullName(Interp interp, Var var) {
        StringBuffer buff = new StringBuffer();
        if (var != null && !var.isVarArrayElement()) {
            if (var.ns != null) {
                buff.append(var.ns.fullName);
                if (var.ns != interp.globalNs) {
                    buff.append("::");
                }
            }
            if (var.hashKey != null) {
                buff.append(var.hashKey);
            }
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String callTraces(Interp interp, Var array, Var var, String part1, String part2, int flags) {
        int i;
        int len;
        if ((var.flags & 0x20) != 0) {
            return null;
        }
        var.flags |= 0x20;
        ++var.refCount;
        if (part2 == null && (len = part1.length()) > 0 && part1.charAt(len - 1) == ')') {
            for (i = 0; i < len - 1 && part1.charAt(i) != '('; ++i) {
            }
            if (i < len - 1 && i < len - 2) {
                part2 = part1.substring(i + 1, len - 1);
                part1 = part1.substring(0, i);
            }
        }
        TclObject oldResult = interp.getResult();
        oldResult.preserve();
        interp.resetResult();
        try {
            if (array != null) {
                ++array.refCount;
            }
            if (array != null && array.traces != null) {
                for (i = 0; array.traces != null && i < array.traces.size(); ++i) {
                    TraceRecord rec = (TraceRecord)array.traces.get(i);
                    if ((rec.flags & flags) == 0) continue;
                    try {
                        rec.trace.traceProc(interp, part1, part2, flags);
                        continue;
                    }
                    catch (TclException e) {
                        if ((flags & 0x40) != 0) continue;
                        String string = interp.getResult().toString();
                        Object var12_17 = null;
                        if (array != null) {
                            --array.refCount;
                        }
                        var.flags &= 0xFFFFFFDF;
                        --var.refCount;
                        interp.setResult(oldResult);
                        oldResult.release();
                        return string;
                    }
                }
            }
            if ((flags & 0x40) != 0) {
                flags |= 0x80;
            }
            for (i = 0; var.traces != null && i < var.traces.size(); ++i) {
                TraceRecord rec = (TraceRecord)var.traces.get(i);
                if ((rec.flags & flags) == 0) continue;
                try {
                    rec.trace.traceProc(interp, part1, part2, flags);
                    continue;
                }
                catch (TclException e) {
                    if ((flags & 0x40) != 0) continue;
                    String string = interp.getResult().toString();
                    Object var12_18 = null;
                    if (array != null) {
                        --array.refCount;
                    }
                    var.flags &= 0xFFFFFFDF;
                    --var.refCount;
                    interp.setResult(oldResult);
                    oldResult.release();
                    return string;
                }
            }
            String string = null;
            Object var12_19 = null;
            if (array != null) {
                --array.refCount;
            }
            var.flags &= 0xFFFFFFDF;
            --var.refCount;
            interp.setResult(oldResult);
            oldResult.release();
            return string;
        }
        catch (Throwable throwable) {
            Object var12_20 = null;
            if (array != null) {
                --array.refCount;
            }
            var.flags &= 0xFFFFFFDF;
            --var.refCount;
            interp.setResult(oldResult);
            oldResult.release();
            throw throwable;
        }
    }

    protected static void deleteSearches(Var arrayVar) {
        arrayVar.sidVec = null;
    }

    protected static void deleteVars(Interp interp, HashMap table) {
        Namespace currNs = Namespace.getCurrentNamespace(interp);
        int flags = 64;
        if (table == interp.globalNs.varTable) {
            flags |= 0x101;
        } else if (table == currNs.varTable) {
            flags |= 2;
        }
        Iterator iter = table.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Var.deleteVar(interp, (Var)entry.getValue(), flags);
        }
        table.clear();
    }

    protected static void deleteVars(Interp interp, Var[] compiledLocals) {
        int flags = 64;
        int max = compiledLocals.length;
        for (int i = 0; i < max; ++i) {
            Var clocal = compiledLocals[i];
            if (clocal == null) continue;
            Var.deleteVar(interp, clocal, 64);
            compiledLocals[i] = null;
        }
    }

    protected static void deleteVar(Interp interp, Var var, int flags) {
        if ((var.flags & 4) != 0) {
            Var link = var.linkto;
            --link.refCount;
            if (link.refCount == 0 && link.traces == null && (link.flags & 0x18) == 24) {
                if (link.hashKey == null) {
                    var.linkto = null;
                } else if (link.table != var.table) {
                    link.table.remove(link.hashKey);
                    link.table = null;
                    var.linkto = null;
                }
            }
        }
        if (var.traces != null) {
            String fullname = Var.getVariableFullName(interp, var);
            Var.callTraces(interp, null, var, fullname, null, flags);
        }
        if ((var.flags & 2) != 0) {
            Var.deleteArray(interp, var.hashKey, var, flags);
            var.arraymap = null;
        } else if ((var.flags & 1) != 0 && var.tobj != null) {
            TclObject obj = var.tobj;
            obj.release();
            var.tobj = null;
        }
        var.hashKey = null;
        var.table = null;
        var.traces = null;
        var.setVarUndefined();
        var.setVarScalar();
        if ((var.flags & 0x80) != 0) {
            var.flags &= 0xFFFFFF7F;
            --var.refCount;
        }
    }

    protected static void deleteArray(Interp interp, String arrayName, Var var, int flags) {
        Var.deleteSearches(var);
        HashMap table = var.arraymap;
        Iterator iter = table.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Var el = (Var)entry.getValue();
            if (el.isVarScalar() && el.tobj != null) {
                TclObject obj = el.tobj;
                obj.release();
                el.tobj = null;
            }
            String tmpkey = el.hashKey;
            el.hashKey = null;
            el.table = null;
            if (el.traces != null) {
                el.flags &= 0xFFFFFFDF;
                Var.callTraces(interp, null, el, arrayName, tmpkey, flags);
                el.traces = null;
            }
            el.setVarUndefined();
            el.setVarScalar();
            if (el.refCount != 0) continue;
        }
        table.clear();
        var.arraymap = null;
    }

    protected static void cleanupVar(Var var, Var array) {
        if (var.isVarUndefined() && var.refCount == 0 && var.traces == null && (var.flags & 0x10) != 0 && var.table != null) {
            var.table.remove(var.hashKey);
            var.table = null;
            var.hashKey = null;
        }
        if (array != null && array.isVarUndefined() && array.refCount == 0 && array.traces == null && (array.flags & 0x10) != 0 && array.table != null) {
            array.table.remove(array.hashKey);
            array.table = null;
            array.hashKey = null;
        }
    }

    static Var resolveScalar(Var v) {
        int flags = v.flags;
        if ((flags & 4) != 0) {
            v = v.linkto;
            flags = v.flags;
        }
        if ((flags & 0x54E) != 0) {
            return null;
        }
        return v;
    }

    static Var resolveArray(Var v) {
        int flags = v.flags;
        if ((flags & 4) != 0) {
            v = v.linkto;
            flags = v.flags;
        }
        if ((flags & 0x10D) != 0) {
            return null;
        }
        return v;
    }

    static void setUndefinedToNull(Interp interp, String part1, String part2) {
        CallFrame varFrame = interp.varFrame;
        if (varFrame == null) {
            return;
        }
        if (varFrame.compiledLocals != null) {
            Var[] compiledLocals = varFrame.compiledLocals;
            int MAX = compiledLocals.length;
            for (int i = 0; i < MAX; ++i) {
                Var clocal = compiledLocals[i];
                if (clocal == null || clocal.isVarNonLocal() || !clocal.hashKey.equals(part1)) continue;
                if (!clocal.isVarLink() && clocal.isVarUndefined() && clocal.refCount == 0) {
                    compiledLocals[i] = null;
                }
                return;
            }
        }
    }

    static void AppendLocals(Interp interp, TclObject list, String pattern, boolean includeLinks) throws TclException {
        Var[] compiledLocals;
        Var var;
        String varName;
        CallFrame frame = interp.varFrame;
        HashMap localVarTable = frame.varTable;
        if (localVarTable != null) {
            Iterator iter = localVarTable.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                varName = (String)entry.getKey();
                var = (Var)entry.getValue();
                if (var.isVarUndefined() || !includeLinks && var.isVarLink() || pattern != null && !Util.stringMatch(varName, pattern)) continue;
                TclList.append(interp, list, TclString.newInstance((String)varName));
            }
        }
        if ((compiledLocals = frame.compiledLocals) != null) {
            int max = compiledLocals.length;
            for (int i = 0; i < max; ++i) {
                Var clocal = compiledLocals[i];
                if (clocal == null || clocal.isVarNonLocal()) continue;
                var = clocal;
                varName = var.hashKey;
                if (var.isVarUndefined() || !includeLinks && var.isVarLink() || pattern != null && !Util.stringMatch(varName, pattern)) continue;
                TclList.append(interp, list, TclString.newInstance((String)varName));
            }
        }
    }
}

