/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.num;

import java.math.BigInteger;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.primitives.otherlibs.num.CustomNat;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="num", module="Nat", source="otherlibs/num/nat_stubs.c")
public final class Nat {
    static final int DIGIT_SIZE_IN_BYTES = 8;
    private static final int BNG_BITS_PER_DIGIT = 64;
    private static final int BNG_BITS_PER_HALF_DIGIT = 32;
    private static final BigInteger BNG_LOW_HALF_MASK = Nat.createDigit(0xFFFFFFFFL);
    private static final BigInteger BNG_DIGIT_MASK = Nat.createDigit(-1L);
    private static final BigInteger MAX_LONG = Nat.createDigit(0x3FFFFFFFFFFFFFFFL);

    private Nat() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="unit")
    public static Value initialize_nat(Value value) {
        CurrentContext.CODE_STATE.registerCustom(CustomNat.OPS);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="Nat.nat")
    public static Value create_nat(Value value) {
        int n = value.asCastedInt();
        long[] lArray = new long[n + 1];
        return Value.createCustom(CustomNat.OPS, n * 8, lArray);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat"}, returnType="int")
    public static Value length_nat(Value value) {
        return Value.createLong(value.getWoSize() - 1L);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int"}, returnType="unit")
    public static Value set_to_zero_nat(Value value, Value value2, Value value3) {
        long[] lArray = (long[])value.asCustom();
        int n = value2.asCastedInt();
        int n2 = value3.asCastedInt();
        for (int i = 0; i < n2; ++i) {
            lArray[n + i] = 0L;
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "Nat.nat", "int", "int"}, returnType="unit")
    public static Value blit_nat(Value value, Value value2, Value value3, Value value4, Value value5) {
        System.arraycopy((long[])value3.asCustom(), value4.asCastedInt(), (long[])value.asCustom(), value2.asCastedInt(), value5.asCastedInt());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int"}, returnType="unit")
    public static Value set_digit_nat(Value value, Value value2, Value value3) {
        ((long[])value.asCustom())[value2.asCastedInt()] = value3.asLong();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int"}, returnType="int")
    public static Value nth_digit_nat(Value value, Value value2) {
        return Value.createLong(((long[])value.asCustom())[value2.asCastedInt()]);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "nativeint"}, returnType="unit")
    public static Value set_digit_nat_native(Value value, Value value2, Value value3) {
        ((long[])value.asCustom())[value2.asCastedInt()] = value3.asNativeInt();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int"}, returnType="nativeint")
    public static Value nth_digit_nat_native(Value value, Value value2) {
        return Value.createNativeInt(((long[])value.asCustom())[value2.asCastedInt()]);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int"}, returnType="int")
    public static Value num_digits_nat(Value value, Value value2, Value value3) {
        long[] lArray = (long[])value.asCustom();
        int n = value2.asCastedInt();
        int n2 = value3.asCastedInt();
        while (n2 != 0) {
            if (lArray[n + n2 - 1] != 0L) {
                return Value.createLong(n2);
            }
            --n2;
        }
        return Value.ONE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int"}, returnType="int")
    public static Value num_leading_zero_bits_in_digit(Value value, Value value2) {
        return Value.createLong(Nat.numLeadingZeroBitsInDigit(((long[])value.asCustom())[value2.asCastedInt()]));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int"}, returnType="bool")
    public static Value is_digit_int(Value value, Value value2) {
        BigInteger bigInteger = Nat.createDigit(((long[])value.asCustom())[value2.asCastedInt()]);
        return bigInteger.compareTo(MAX_LONG) <= 0 ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int"}, returnType="bool")
    public static Value is_digit_zero(Value value, Value value2) {
        return ((long[])value.asCustom())[value2.asCastedInt()] == 0L ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int"}, returnType="bool")
    public static Value is_digit_normalized(Value value, Value value2) {
        return (((long[])value.asCustom())[value2.asCastedInt()] & Long.MIN_VALUE) != 0L ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int"}, returnType="bool")
    public static Value is_digit_odd(Value value, Value value2) {
        return (((long[])value.asCustom())[value2.asCastedInt()] & 1L) != 0L ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value incr_nat(Value value, Value value2, Value value3, Value value4) {
        long[] lArray = (long[])value.asCustom();
        int n = value2.asCastedInt();
        int n2 = value3.asCastedInt();
        if (value4 == Value.ZERO || n2 == 0) {
            return value4;
        }
        do {
            int n3 = n++;
            lArray[n3] = lArray[n3] + 1L;
            if (lArray[n3] == 0L) continue;
            return Value.ZERO;
        } while (--n2 != 0);
        return Value.ONE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value add_nat(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7) {
        long[] lArray = (long[])value.asCustom();
        long[] lArray2 = (long[])value4.asCustom();
        int n = value2.asCastedInt();
        int n2 = value5.asCastedInt();
        int n3 = value3.asCastedInt();
        int n4 = value6.asCastedInt();
        long l = value7.asLong();
        n3 -= n4;
        while (n4 > 0) {
            BigInteger bigInteger = Nat.createDigit(lArray[n]);
            BigInteger bigInteger2 = Nat.addDigit(bigInteger, Nat.createDigit(lArray2[n2]));
            BigInteger bigInteger3 = Nat.addDigit(bigInteger2, Nat.createDigit(l));
            l = (bigInteger2.compareTo(bigInteger) < 0 ? 1 : 0) + (bigInteger3.compareTo(bigInteger2) < 0 ? 1 : 0);
            lArray[n] = bigInteger3.longValue();
            --n4;
            ++n;
            ++n2;
        }
        if (l == 0L || n3 == 0) {
            return Value.createLong(l);
        }
        do {
            int n5 = n++;
            lArray[n5] = lArray[n5] + 1L;
            if (lArray[n5] == 0L) continue;
            return Value.ZERO;
        } while (--n3 != 0);
        return Value.ONE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value add_nat_native(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7) {
        return Nat.add_nat(value, value2, value3, value4, value5, value6, value7);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int"}, returnType="unit")
    public static Value complement_nat(Value value, Value value2, Value value3) {
        long[] lArray = (long[])value.asCustom();
        int n = value2.asCastedInt();
        int n2 = value3.asCastedInt();
        for (int i = 0; i < n2; ++i) {
            lArray[i + n] = lArray[i + n] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value decr_nat(Value value, Value value2, Value value3, Value value4) {
        long[] lArray = (long[])value.asCustom();
        int n = value2.asCastedInt();
        int n2 = value3.asCastedInt();
        long l = 1L ^ value4.asLong();
        if (l == 0L || n2 == 0) {
            return value4;
        }
        do {
            int n3 = n++;
            long l2 = lArray[n3];
            lArray[n3] = l2 - 1L;
            if (l2 == 0L) continue;
            return Value.ONE;
        } while (--n2 != 0);
        return Value.ZERO;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value sub_nat(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7) {
        return Value.createLong(Nat.subNat((long[])value.asCustom(), value2.asCastedInt(), value3.asCastedInt(), (long[])value4.asCustom(), value5.asCastedInt(), value6.asCastedInt(), Nat.createDigit(value7.asLong())));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value sub_nat_native(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7) {
        return Nat.sub_nat(value, value2, value3, value4, value5, value6, value7);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "Nat.nat", "int"}, returnType="int")
    public static Value mult_digit_nat(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7, Value value8) {
        return Value.createLong(Nat.multDigitNat((long[])value.asCustom(), value2.asCastedInt(), value3.asCastedInt(), (long[])value4.asCustom(), value5.asCastedInt(), value6.asCastedInt(), (long[])value7.asCustom(), value8.asCastedInt()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "Nat.nat", "int"}, returnType="int")
    public static Value mult_digit_nat_native(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7, Value value8) {
        return Nat.mult_digit_nat(value, value2, value3, value4, value5, value6, value7, value8);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="int")
    public static Value mult_nat(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7, Value value8, Value value9) {
        long[] lArray = (long[])value.asCustom();
        long[] lArray2 = (long[])value4.asCustom();
        long[] lArray3 = (long[])value7.asCustom();
        int n = value2.asCastedInt();
        int n2 = value5.asCastedInt();
        int n3 = value8.asCastedInt();
        int n4 = value3.asCastedInt();
        int n5 = value6.asCastedInt();
        int n6 = value9.asCastedInt();
        BigInteger bigInteger = Nat.createDigit(0L);
        while (n6 > 0) {
            bigInteger = Nat.addDigit(bigInteger, Nat.createDigit(Nat.multDigitNat(lArray, n, n4, lArray2, n2, n5, lArray3, n3)));
            --n6;
            ++n3;
            --n4;
            ++n;
        }
        return Value.createLong(bigInteger.longValue());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="int")
    public static Value mult_nat_native(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7, Value value8, Value value9) {
        return Nat.mult_nat(value, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="int")
    public static Value square_nat(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) {
        long[] lArray = (long[])value.asCustom();
        long[] lArray2 = (long[])value4.asCustom();
        int n = value2.asCastedInt();
        int n2 = value5.asCastedInt();
        int n3 = value3.asCastedInt();
        int n4 = value6.asCastedInt();
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 1; i < n4; ++i) {
            int n5 = 2 * i - 1;
            bigInteger = Nat.addDigit(bigInteger, Nat.createDigit(Nat.multDigitNat(lArray, n + n5, n3 - n5, lArray2, n2 + i, n4 - i, lArray2, n2 + i - 1)));
        }
        bigInteger = bigInteger.shiftLeft(1).and(BNG_DIGIT_MASK).or(Nat.createDigit(Nat.shiftLeft(lArray, n, n3, 1)).and(BNG_DIGIT_MASK));
        BigInteger bigInteger2 = BigInteger.ZERO;
        for (int i = 0; i < n4; ++i) {
            BigInteger bigInteger3 = Nat.createDigit(lArray2[n2 + i]);
            BigInteger bigInteger4 = Nat.multDigit(bigInteger3.and(BNG_LOW_HALF_MASK), bigInteger3.and(BNG_LOW_HALF_MASK));
            BigInteger bigInteger5 = Nat.multDigit(bigInteger3.and(BNG_LOW_HALF_MASK), bigInteger3.shiftRight(32));
            BigInteger bigInteger6 = Nat.multDigit(bigInteger3.shiftRight(32), bigInteger3.and(BNG_LOW_HALF_MASK));
            BigInteger bigInteger7 = Nat.multDigit(bigInteger3.shiftRight(32), bigInteger3.shiftRight(32));
            BigInteger bigInteger8 = Nat.addDigit(bigInteger7, Nat.addDigit(bigInteger5.shiftRight(32), bigInteger6.shiftRight(32)));
            BigInteger bigInteger9 = bigInteger4;
            BigInteger bigInteger10 = Nat.addDigit(bigInteger9, bigInteger5.shiftLeft(32).and(BNG_DIGIT_MASK));
            bigInteger8 = Nat.addDigit(bigInteger8, bigInteger10.compareTo(bigInteger9) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            BigInteger bigInteger11 = Nat.addDigit(bigInteger10, bigInteger6.shiftLeft(32).and(BNG_DIGIT_MASK));
            bigInteger8 = Nat.addDigit(bigInteger8, bigInteger11.compareTo(bigInteger10) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            BigInteger bigInteger12 = bigInteger11;
            bigInteger4 = Nat.createDigit(lArray[n]);
            bigInteger5 = Nat.addDigit(bigInteger4, bigInteger12);
            bigInteger6 = Nat.addDigit(bigInteger5, bigInteger2);
            bigInteger2 = Nat.addDigit(bigInteger5.compareTo(bigInteger4) < 0 ? BigInteger.ONE : BigInteger.ZERO, bigInteger6.compareTo(bigInteger5) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            lArray[n] = bigInteger6.longValue();
            bigInteger4 = Nat.createDigit(lArray[++n]);
            bigInteger5 = Nat.addDigit(bigInteger4, bigInteger8);
            bigInteger6 = Nat.addDigit(bigInteger5, bigInteger2);
            bigInteger2 = Nat.addDigit(bigInteger5.compareTo(bigInteger4) < 0 ? BigInteger.ONE : BigInteger.ZERO, bigInteger6.compareTo(bigInteger5) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            lArray[n] = bigInteger6.longValue();
            ++n;
        }
        if ((n3 -= 2 * n4) > 0 && bigInteger2.compareTo(BigInteger.ZERO) != 0) {
            do {
                int n6 = n++;
                lArray[n6] = lArray[n6] + 1L;
                if (lArray[n6] == 0L) continue;
                bigInteger2 = BigInteger.ZERO;
                break;
            } while (--n3 != 0);
        }
        return Value.createLong(Nat.addDigit(bigInteger, bigInteger2).longValue());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="int")
    public static Value square_nat_native(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) {
        return Nat.square_nat(value, value2, value3, value4, value5, value6);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="unit")
    public static Value shift_left_nat(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) {
        ((long[])value4.asCustom())[value5.asCastedInt()] = Nat.shiftLeft((long[])value.asCustom(), value2.asCastedInt(), value3.asCastedInt(), value6.asCastedInt());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="unit")
    public static Value shift_left_nat_native(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) {
        return Nat.shift_left_nat(value, value2, value3, value4, value5, value6);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "Nat.nat", "int", "Nat.nat", "int", "int", "Nat.nat", "int"}, returnType="unit")
    public static Value div_digit_nat(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7, Value value8, Value value9) {
        long[] lArray = (long[])value.asCustom();
        int n = value2.asCastedInt();
        long[] lArray2 = (long[])value5.asCustom();
        int n2 = value6.asCastedInt();
        int n3 = value7.asCastedInt();
        long l = ((long[])value8.asCustom())[value9.asCastedInt()];
        int n4 = Nat.numLeadingZeroBitsInDigit(l);
        BigInteger bigInteger = Nat.createDigit(l);
        bigInteger = bigInteger.shiftLeft(n4).and(BNG_DIGIT_MASK);
        Nat.shiftLeft(lArray2, n2, n3, n4);
        BigInteger bigInteger2 = Nat.divRemNormDigit(lArray, n, lArray2, n2, n3, bigInteger);
        Nat.shiftRight(lArray2, n2, n3, n4);
        ((long[])value3.asCustom())[value4.asCastedInt()] = bigInteger2.shiftRight(n4).longValue();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "Nat.nat", "int", "Nat.nat", "int", "int", "Nat.nat", "int"}, returnType="unit")
    public static Value div_digit_nat_native(Value value, Value value2, Value value3, Value value4, Value value5, Value value6, Value value7, Value value8, Value value9) {
        return Nat.div_digit_nat(value, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="unit")
    public static Value div_nat(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) {
        long[] lArray = (long[])value.asCustom();
        long[] lArray2 = (long[])value4.asCustom();
        int n = value2.asCastedInt();
        int n2 = value5.asCastedInt();
        int n3 = value3.asCastedInt();
        int n4 = value6.asCastedInt();
        int n5 = Nat.numLeadingZeroBitsInDigit(lArray2[n2 + n4 - 1]);
        Nat.shiftLeft(lArray, n, n3, n5);
        Nat.shiftLeft(lArray2, n2, n4, n5);
        if (n4 == 1) {
            lArray[n] = Nat.divRemNormDigit(lArray, n + 1, lArray, n, n3, Nat.createDigit(lArray2[n2])).longValue();
        } else {
            BigInteger bigInteger = Nat.createDigit(lArray2[n2 + n4 - 1]);
            for (int i = n3 - 1; i >= n4; --i) {
                BigInteger bigInteger2;
                int n6 = i - n4;
                if (Nat.addDigit(bigInteger, BigInteger.ONE).compareTo(BigInteger.ZERO) == 0) {
                    bigInteger2 = Nat.createDigit(lArray[n + i]);
                } else {
                    BigInteger bigInteger3 = Nat.createDigit(lArray[n + i]);
                    BigInteger bigInteger4 = Nat.createDigit(lArray[n + i - 1]);
                    BigInteger bigInteger5 = Nat.addDigit(bigInteger, BigInteger.ONE);
                    BigInteger bigInteger6 = bigInteger5.and(BNG_LOW_HALF_MASK);
                    BigInteger bigInteger7 = bigInteger5.shiftRight(32);
                    BigInteger bigInteger8 = Nat.divDigit(bigInteger3, Nat.addDigit(bigInteger7, BigInteger.ONE));
                    BigInteger bigInteger9 = bigInteger4.and(BNG_LOW_HALF_MASK);
                    BigInteger bigInteger10 = Nat.multDigit(bigInteger8, bigInteger7);
                    BigInteger bigInteger11 = Nat.multDigit(bigInteger8, bigInteger6);
                    bigInteger3 = Nat.subtractDigit(bigInteger3, bigInteger10);
                    bigInteger4 = bigInteger4.shiftRight(32).or(bigInteger3.shiftLeft(32)).and(BNG_DIGIT_MASK);
                    bigInteger3 = bigInteger3.shiftRight(32);
                    bigInteger3 = Nat.subtractDigit(bigInteger3, bigInteger4.compareTo(bigInteger11) < 0 ? BigInteger.ONE : BigInteger.ZERO);
                    bigInteger4 = Nat.subtractDigit(bigInteger4, bigInteger11);
                    while (bigInteger3.compareTo(BigInteger.ZERO) != 0 || bigInteger4.compareTo(bigInteger5) >= 0) {
                        bigInteger3 = Nat.subtractDigit(bigInteger3, bigInteger4.compareTo(bigInteger5) < 0 ? BigInteger.ONE : BigInteger.ZERO);
                        bigInteger4 = Nat.subtractDigit(bigInteger4, bigInteger5);
                        bigInteger8 = Nat.addDigit(bigInteger8, BigInteger.ONE);
                    }
                    BigInteger bigInteger12 = Nat.divDigit(bigInteger4, Nat.addDigit(bigInteger7, BigInteger.ONE));
                    bigInteger10 = Nat.multDigit(bigInteger12, bigInteger7);
                    bigInteger11 = Nat.multDigit(bigInteger12, bigInteger6);
                    bigInteger4 = Nat.subtractDigit(bigInteger4, bigInteger10);
                    bigInteger3 = bigInteger4.shiftRight(32);
                    bigInteger3 = Nat.subtractDigit(bigInteger3, (bigInteger4 = bigInteger4.shiftLeft(32).or(bigInteger9).and(BNG_DIGIT_MASK)).compareTo(bigInteger11) < 0 ? BigInteger.ONE : BigInteger.ZERO);
                    bigInteger4 = Nat.subtractDigit(bigInteger4, bigInteger11);
                    while (bigInteger3.compareTo(BigInteger.ZERO) != 0 || bigInteger4.compareTo(bigInteger5) >= 0) {
                        bigInteger3 = Nat.subtractDigit(bigInteger3, bigInteger4.compareTo(bigInteger5) < 0 ? BigInteger.ONE : BigInteger.ZERO);
                        bigInteger4 = Nat.subtractDigit(bigInteger4, bigInteger5);
                        bigInteger12 = Nat.addDigit(bigInteger12, BigInteger.ONE);
                    }
                    bigInteger2 = bigInteger8.shiftLeft(32).or(bigInteger12).and(BNG_DIGIT_MASK);
                }
                lArray[n + i] = Nat.subtractDigit(Nat.createDigit(lArray[n + i]), Nat.multSubDigit(lArray, n + n6, n4, lArray2, n2, n4, bigInteger2)).longValue();
                while (lArray[n + i] != 0L || Nat.compareNat(lArray, n + n6, n4, lArray2, n2, n4) >= 0) {
                    bigInteger2 = Nat.addDigit(bigInteger2, BigInteger.ONE);
                    lArray[n + i] = Nat.subtractDigit(Nat.createDigit(lArray[n + i]), BigInteger.ONE.xor(Nat.createDigit(Nat.subNat(lArray, n + n6, n4, lArray2, n2, n4, BigInteger.ZERO))).and(BNG_DIGIT_MASK)).longValue();
                }
                lArray[n + i] = bigInteger2.longValue();
            }
        }
        Nat.shiftRight(lArray, n, n4, n5);
        Nat.shiftRight(lArray2, n2, n4, n5);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="unit")
    public static Value div_nat_native(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) {
        return Nat.div_nat(value, value2, value3, value4, value5, value6);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="unit")
    public static Value shift_right_nat(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) {
        ((long[])value4.asCustom())[value5.asCastedInt()] = Nat.shiftRight((long[])value.asCustom(), value2.asCastedInt(), value3.asCastedInt(), value6.asCastedInt());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int"}, returnType="unit")
    public static Value shift_right_nat_native(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) {
        return Nat.shift_right_nat(value, value2, value3, value4, value5, value6);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "Nat.nat", "int"}, returnType="int")
    public static Value compare_digits_nat(Value value, Value value2, Value value3, Value value4) {
        BigInteger bigInteger = Nat.createDigit(((long[])value.asCustom())[value2.asCastedInt()]);
        BigInteger bigInteger2 = Nat.createDigit(((long[])value3.asCustom())[value4.asCastedInt()]);
        return Value.createLong(bigInteger.compareTo(bigInteger2));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value compare_nat(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) {
        return Value.createLong(Nat.compareNat((long[])value.asCustom(), value2.asCastedInt(), value3.asCastedInt(), (long[])value4.asCustom(), value5.asCastedInt(), value6.asCastedInt()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "int", "Nat.nat", "int", "int", "int"}, returnType="int")
    public static Value compare_nat_native(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) {
        return Nat.compare_nat(value, value2, value3, value4, value5, value6);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "Nat.nat", "int"}, returnType="unit")
    public static Value land_digit_nat(Value value, Value value2, Value value3, Value value4) {
        long[] lArray = (long[])value.asCustom();
        int n = value2.asCastedInt();
        lArray[n] = lArray[n] & ((long[])value3.asCustom())[value4.asCastedInt()];
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "Nat.nat", "int"}, returnType="unit")
    public static Value lor_digit_nat(Value value, Value value2, Value value3, Value value4) {
        long[] lArray = (long[])value.asCustom();
        int n = value2.asCastedInt();
        lArray[n] = lArray[n] | ((long[])value3.asCustom())[value4.asCastedInt()];
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Nat.nat", "int", "Nat.nat", "int"}, returnType="unit")
    public static Value lxor_digit_nat(Value value, Value value2, Value value3, Value value4) {
        long[] lArray = (long[])value.asCustom();
        int n = value2.asCastedInt();
        lArray[n] = lArray[n] ^ ((long[])value3.asCustom())[value4.asCastedInt()];
        return Value.UNIT;
    }

    private static int numLeadingZeroBitsInDigit(long l) {
        long l2 = l;
        int n = 64;
        if ((l2 & 0xFFFFFFFF00000000L) != 0L) {
            n -= 32;
            l2 >>>= 32;
        }
        if ((l2 & 0xFFFF0000L) != 0L) {
            n -= 16;
            l2 >>>= 16;
        }
        if ((l2 & 0xFF00L) != 0L) {
            n -= 8;
            l2 >>>= 8;
        }
        if ((l2 & 0xF0L) != 0L) {
            n -= 4;
            l2 >>>= 4;
        }
        if ((l2 & 0xCL) != 0L) {
            n -= 2;
            l2 >>>= 2;
        }
        if ((l2 & 2L) != 0L) {
            --n;
            l2 >>>= 1;
        }
        return n - (int)l2;
    }

    private static int compareNat(long[] lArray, int n, int n2, long[] lArray2, int n3, int n4) {
        int n5;
        int n6 = n;
        int n7 = n3;
        int n8 = n4;
        for (n5 = n2; n5 > 0 && lArray[n6 + n5 - 1] == 0L; --n5) {
        }
        while (n8 > 0 && lArray2[n7 + n8 - 1] == 0L) {
            --n8;
        }
        if (n5 > n8) {
            return 1;
        }
        if (n5 < n8) {
            return -1;
        }
        while (n5 > 0) {
            BigInteger bigInteger;
            BigInteger bigInteger2;
            int n9;
            if ((n9 = (bigInteger2 = Nat.createDigit(lArray[n6 + --n5])).compareTo(bigInteger = Nat.createDigit(lArray2[n7 + n5]))) == 0) continue;
            return n9;
        }
        return 0;
    }

    private static long subNat(long[] lArray, int n, int n2, long[] lArray2, int n3, int n4, BigInteger bigInteger) {
        int n5 = n;
        int n6 = n3;
        int n7 = n2;
        int n8 = n4;
        BigInteger bigInteger2 = BigInteger.ONE.xor(bigInteger).and(BNG_DIGIT_MASK);
        n7 -= n8;
        while (n8 > 0) {
            BigInteger bigInteger3 = Nat.createDigit(lArray[n5]);
            BigInteger bigInteger4 = Nat.createDigit(lArray2[n6]);
            BigInteger bigInteger5 = Nat.subtractDigit(bigInteger3, bigInteger4);
            lArray[n5] = Nat.subtractDigit(bigInteger5, bigInteger2).longValue();
            bigInteger2 = Nat.addDigit(bigInteger3.compareTo(bigInteger4) < 0 ? BigInteger.ONE : BigInteger.ZERO, bigInteger5.compareTo(bigInteger2) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            --n8;
            ++n5;
            ++n6;
        }
        if (bigInteger2.compareTo(BigInteger.ZERO) == 0 || n7 == 0) {
            return bigInteger.longValue();
        }
        do {
            int n9 = n5++;
            long l = lArray[n9];
            lArray[n9] = l - 1L;
            if (l == 0L) continue;
            return 1L;
        } while (--n7 != 0);
        return 0L;
    }

    private static long multDigitNat(long[] lArray, int n, int n2, long[] lArray2, int n3, int n4, long[] lArray3, int n5) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        int n6 = n2;
        int n7 = n4;
        int n8 = n;
        int n9 = n3;
        BigInteger bigInteger3 = Nat.createDigit(lArray3[n5]);
        n6 -= n7;
        BigInteger bigInteger4 = BigInteger.ZERO;
        while (n7 > 0) {
            bigInteger2 = Nat.createDigit(lArray2[n9]);
            bigInteger = Nat.multDigit(bigInteger2.and(BNG_LOW_HALF_MASK), bigInteger3.and(BNG_LOW_HALF_MASK));
            BigInteger bigInteger5 = Nat.multDigit(bigInteger2.and(BNG_LOW_HALF_MASK), bigInteger3.shiftRight(32));
            BigInteger bigInteger6 = Nat.multDigit(bigInteger2.shiftRight(32), bigInteger3.and(BNG_LOW_HALF_MASK));
            BigInteger bigInteger7 = Nat.multDigit(bigInteger2.shiftRight(32), bigInteger3.shiftRight(32));
            BigInteger bigInteger8 = Nat.addDigit(bigInteger7, Nat.addDigit(bigInteger5.shiftRight(32), bigInteger6.shiftRight(32)));
            BigInteger bigInteger9 = bigInteger;
            BigInteger bigInteger10 = Nat.addDigit(bigInteger9, bigInteger5.shiftLeft(32).and(BNG_DIGIT_MASK));
            bigInteger8 = Nat.addDigit(bigInteger8, bigInteger10.compareTo(bigInteger9) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            BigInteger bigInteger11 = Nat.addDigit(bigInteger10, bigInteger6.shiftLeft(32).and(BNG_DIGIT_MASK));
            bigInteger8 = Nat.addDigit(bigInteger8, bigInteger11.compareTo(bigInteger10) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            BigInteger bigInteger12 = bigInteger11;
            bigInteger = Nat.createDigit(lArray[n8]);
            bigInteger5 = Nat.addDigit(bigInteger, bigInteger12);
            bigInteger8 = Nat.addDigit(bigInteger8, bigInteger5.compareTo(bigInteger) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            bigInteger6 = Nat.addDigit(bigInteger5, bigInteger4);
            bigInteger8 = Nat.addDigit(bigInteger8, bigInteger6.compareTo(bigInteger5) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            lArray[n8] = bigInteger6.longValue();
            bigInteger4 = bigInteger8;
            --n7;
            ++n8;
            ++n9;
        }
        if (n6 == 0) {
            return bigInteger4.longValue();
        }
        BigInteger bigInteger13 = BigInteger.ZERO;
        bigInteger2 = Nat.createDigit(lArray[n8]);
        bigInteger = Nat.addDigit(bigInteger2, bigInteger4);
        bigInteger13 = bigInteger.compareTo(bigInteger2) < 0 ? BigInteger.ONE : BigInteger.ZERO;
        lArray[n8] = bigInteger.longValue();
        ++n8;
        if (bigInteger13.compareTo(BigInteger.ZERO) == 0 || --n6 == 0) {
            return bigInteger13.longValue();
        }
        do {
            int n10 = n8++;
            lArray[n10] = lArray[n10] + 1L;
            if (lArray[n10] == 0L) continue;
            return 0L;
        } while (--n6 != 0);
        return 1L;
    }

    private static long shiftLeft(long[] lArray, int n, int n2, int n3) {
        int n4 = n;
        int n5 = 64 - n3;
        long l = 0L;
        if (n3 > 0) {
            int n6 = n2;
            while (n6 > 0) {
                long l2 = lArray[n4];
                lArray[n4] = l2 << n3 | l;
                l = l2 >>> n5;
                --n6;
                ++n4;
            }
        }
        return l;
    }

    private static long shiftRight(long[] lArray, int n, int n2, int n3) {
        int n4 = n2;
        int n5 = 64 - n3;
        long l = 0L;
        if (n3 > 0) {
            int n6 = n + n4 - 1;
            while (n4 > 0) {
                long l2 = lArray[n6];
                lArray[n6] = l2 >>> n3 | l;
                l = l2 << n5;
                --n4;
                --n6;
            }
        }
        return l;
    }

    private static BigInteger divRemNormDigit(long[] lArray, int n, long[] lArray2, int n2, int n3, BigInteger bigInteger) {
        BigInteger bigInteger2 = Nat.createDigit(lArray2[n2 + n3 - 1]);
        for (int i = n3 - 2; i >= 0; --i) {
            BigInteger bigInteger3 = bigInteger2;
            BigInteger bigInteger4 = Nat.createDigit(lArray2[n2 + i]);
            BigInteger bigInteger5 = bigInteger.and(BNG_LOW_HALF_MASK);
            BigInteger bigInteger6 = bigInteger.shiftRight(32);
            BigInteger bigInteger7 = Nat.divDigit(bigInteger3, Nat.addDigit(bigInteger6, BigInteger.ONE));
            BigInteger bigInteger8 = bigInteger4.and(BNG_LOW_HALF_MASK);
            BigInteger bigInteger9 = Nat.multDigit(bigInteger7, bigInteger6);
            BigInteger bigInteger10 = Nat.multDigit(bigInteger7, bigInteger5);
            bigInteger3 = Nat.subtractDigit(bigInteger3, bigInteger9);
            bigInteger4 = bigInteger4.shiftRight(32).or(bigInteger3.shiftLeft(32)).and(BNG_DIGIT_MASK);
            bigInteger3 = bigInteger3.shiftRight(32);
            bigInteger3 = Nat.subtractDigit(bigInteger3, bigInteger4.compareTo(bigInteger10) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            bigInteger4 = Nat.subtractDigit(bigInteger4, bigInteger10);
            while (bigInteger3.compareTo(BigInteger.ZERO) != 0 || bigInteger4.compareTo(bigInteger) >= 0) {
                bigInteger3 = Nat.subtractDigit(bigInteger3, bigInteger4.compareTo(bigInteger) < 0 ? BigInteger.ONE : BigInteger.ZERO);
                bigInteger4 = Nat.subtractDigit(bigInteger4, bigInteger);
                bigInteger7 = Nat.addDigit(bigInteger7, BigInteger.ONE);
            }
            BigInteger bigInteger11 = Nat.divDigit(bigInteger4, bigInteger6.add(BigInteger.ONE));
            bigInteger9 = Nat.multDigit(bigInteger11, bigInteger6);
            bigInteger10 = Nat.multDigit(bigInteger11, bigInteger5);
            bigInteger4 = Nat.subtractDigit(bigInteger4, bigInteger9);
            bigInteger3 = bigInteger4.shiftRight(32);
            bigInteger3 = Nat.subtractDigit(bigInteger3, (bigInteger4 = bigInteger4.shiftLeft(32).or(bigInteger8).and(BNG_DIGIT_MASK)).compareTo(bigInteger10) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            bigInteger4 = Nat.subtractDigit(bigInteger4, bigInteger10);
            while (bigInteger3.compareTo(BigInteger.ZERO) != 0 || bigInteger4.compareTo(bigInteger) >= 0) {
                bigInteger3 = Nat.subtractDigit(bigInteger3, bigInteger4.compareTo(bigInteger) < 0 ? BigInteger.ONE : BigInteger.ZERO);
                bigInteger4 = Nat.subtractDigit(bigInteger4, bigInteger);
                bigInteger11 = Nat.addDigit(bigInteger11, BigInteger.ONE);
            }
            BigInteger bigInteger12 = bigInteger7.shiftLeft(32).or(bigInteger11).and(BNG_DIGIT_MASK);
            BigInteger bigInteger13 = bigInteger4;
            lArray[n + i] = bigInteger12.longValue();
            bigInteger2 = bigInteger13;
        }
        return bigInteger2;
    }

    private static BigInteger multSubDigit(long[] lArray, int n, int n2, long[] lArray2, int n3, int n4, BigInteger bigInteger) {
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        int n5 = n2;
        int n6 = n4;
        int n7 = n;
        int n8 = n3;
        n5 -= n6;
        BigInteger bigInteger4 = BigInteger.ZERO;
        while (n6 > 0) {
            bigInteger3 = Nat.createDigit(lArray2[n8]);
            bigInteger2 = Nat.multDigit(bigInteger3.and(BNG_LOW_HALF_MASK), bigInteger.and(BNG_LOW_HALF_MASK));
            BigInteger bigInteger5 = Nat.multDigit(bigInteger3.and(BNG_LOW_HALF_MASK), bigInteger.shiftRight(32));
            BigInteger bigInteger6 = Nat.multDigit(bigInteger3.shiftRight(32), bigInteger.and(BNG_LOW_HALF_MASK));
            BigInteger bigInteger7 = Nat.multDigit(bigInteger3.shiftRight(32), bigInteger.shiftRight(32));
            BigInteger bigInteger8 = Nat.addDigit(bigInteger7, Nat.addDigit(bigInteger5.shiftRight(32), bigInteger6.shiftRight(32)));
            BigInteger bigInteger9 = bigInteger2;
            BigInteger bigInteger10 = Nat.addDigit(bigInteger9, bigInteger5.shiftLeft(32).and(BNG_DIGIT_MASK));
            bigInteger8 = Nat.addDigit(bigInteger8, bigInteger10.compareTo(bigInteger9) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            BigInteger bigInteger11 = Nat.addDigit(bigInteger10, bigInteger6.shiftLeft(32).and(BNG_DIGIT_MASK));
            bigInteger8 = Nat.addDigit(bigInteger8, bigInteger11.compareTo(bigInteger10) < 0 ? BigInteger.ONE : BigInteger.ZERO);
            BigInteger bigInteger12 = bigInteger11;
            bigInteger2 = Nat.createDigit(lArray[n7]);
            bigInteger5 = bigInteger12;
            bigInteger6 = bigInteger4;
            bigInteger7 = Nat.subtractDigit(bigInteger2, bigInteger5);
            lArray[n7] = Nat.subtractDigit(bigInteger7, bigInteger6).longValue();
            bigInteger4 = bigInteger8 = Nat.addDigit(bigInteger8, Nat.addDigit(bigInteger2.compareTo(bigInteger5) < 0 ? BigInteger.ONE : BigInteger.ZERO, bigInteger7.compareTo(bigInteger6) < 0 ? BigInteger.ONE : BigInteger.ZERO));
            --n6;
            ++n7;
            ++n8;
        }
        if (n5 == 0) {
            return bigInteger4;
        }
        bigInteger3 = Nat.createDigit(lArray[n7]);
        bigInteger2 = bigInteger4;
        lArray[n7] = Nat.subtractDigit(bigInteger3, bigInteger2).longValue();
        BigInteger bigInteger13 = bigInteger3.compareTo(bigInteger2) < 0 ? BigInteger.ONE : BigInteger.ZERO;
        ++n7;
        if (bigInteger13.compareTo(BigInteger.ZERO) == 0 || --n5 == 0) {
            return bigInteger13;
        }
        do {
            int n9 = n7++;
            long l = lArray[n9];
            lArray[n9] = l - 1L;
            if (l == 0L) continue;
            return BigInteger.ZERO;
        } while (--n5 != 0);
        return BigInteger.ONE;
    }

    private static BigInteger createDigit(long l) {
        byte[] byArray = new byte[8];
        long l2 = l;
        for (int i = 0; i < 8; ++i) {
            byArray[7 - i] = (byte)(l2 & 0xFFL);
            l2 >>= 8;
        }
        return new BigInteger(1, byArray);
    }

    private static BigInteger addDigit(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger.add(bigInteger2);
        return bigInteger3.and(BNG_DIGIT_MASK);
    }

    private static BigInteger multDigit(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger2);
        return bigInteger3.and(BNG_DIGIT_MASK);
    }

    private static BigInteger subtractDigit(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
        return bigInteger3.and(BNG_DIGIT_MASK);
    }

    private static BigInteger divDigit(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger.divide(bigInteger2);
        return bigInteger3.and(BNG_DIGIT_MASK);
    }
}

