/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.lang.reflect.Method;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Dynlink", source="byterun/dynlink.c")
public final class Dynlink {
    private Dynlink() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"If the specified filename denotes a jar file, its", "entries are loaded and will be checked during", "primitive lookup. If it denotes a file that is not a", "jar one, the library is opened and it is supposed that", "primitives will be provided by another way", "({e.g.} builtin primitives). If it is not a file, a", "try is made to consider the passed path as a fully", "qualified class name used as a primitive provider."}, parameterTypes={"Dll.dll_open", "string"}, returnType="Dll.dll_handle")
    public static Value caml_dynlink_open_lib(Value mode, Value filename) throws FailException {
        return CurrentContext.getCodeState().openLib(filename);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Does only remove the element from the list of opened libraries."}, parameterTypes={"Dll.dll_handle"}, returnType="unit")
    public static Value caml_dynlink_close_lib(Value handle) {
        CurrentContext.getCodeState().closeLib((String)handle.asCustom());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Looks for primitive in OCaml-Java primitive providers", "as well as primitive providers registered with the", "interpreter, then using loaded libraries."}, parameterTypes={"Dll.dll_handle", "string"}, returnType="Dll.dll_address")
    public static Value caml_dynlink_lookup_symbol(Value libHandle, Value symbName) {
        String lib = (String)libHandle.asCustom();
        String name = symbName.asString();
        return CurrentContext.getCodeState().lookupPrimitive(lib, name);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Dll.dll_address"}, returnType="int")
    public static Value caml_dynlink_add_primitive(Value prim) throws FailException {
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        if (runner.isNative()) {
            Fail.invalidArgument("dynlink_add_primitive");
        }
        Method meth = (Method)prim.asCustom();
        String name = meth.getName();
        try {
            return Value.createLong(runner.getContext().getCodeState().addPrimitive(name, meth));
        }
        catch (IllegalAccessException iae) {
            Fail.failWith("Java method cannot be accessed");
            return null;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="Dll.dll_handle array")
    public static Value caml_dynlink_get_current_libs(Value unit) throws FailException {
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        if (runner.isNative()) {
            Fail.invalidArgument("dynlink_get_current_libs");
        }
        return runner.getContext().getCodeState().makeLibsArray();
    }
}

