/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.lang.reflect.Method;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Dynlink", source="byterun/dynlink.c")
public final class Dynlink {
    private Dynlink() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"If the specified filename denotes a jar file, its", "entries are loaded and will be checked during", "primitive lookup. If it denotes a file that is not a", "jar one, the library is opened and it is supposed that", "primitives will be provided by another way", "({e.g.} builtin primitives). If it is not a file, a", "try is made to consider the passed path as a fully", "qualified class name used as a primitive provider."}, parameterTypes={"Dll.dll_open", "string"}, returnType="Dll.dll_handle")
    public static Value caml_dynlink_open_lib(Value value, Value value2) throws FailException {
        return CurrentContext.CODE_STATE.openLib(value2);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Does only remove the element from the list of opened libraries."}, parameterTypes={"Dll.dll_handle"}, returnType="unit")
    public static Value caml_dynlink_close_lib(Value value) {
        CurrentContext.CODE_STATE.closeLib((String)value.asCustom());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Looks for primitive in OCaml-Java primitive providers", "as well as primitive providers registered with the", "interpreter, then using loaded libraries."}, parameterTypes={"Dll.dll_handle", "string"}, returnType="Dll.dll_address")
    public static Value caml_dynlink_lookup_symbol(Value value, Value value2) {
        String string = (String)value.asCustom();
        String string2 = value2.asString();
        return CurrentContext.CODE_STATE.lookupPrimitive(string, string2);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Dll.dll_address"}, returnType="int")
    public static Value caml_dynlink_add_primitive(Value value) throws FailException {
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        if (codeRunner.isNative()) {
            Fail.invalidArgument("dynlink_add_primitive");
        }
        Method method = (Method)value.asCustom();
        String string = method.getName();
        try {
            return Value.createLong(codeRunner.getContext().getCodeState().addPrimitive(string, method));
        }
        catch (IllegalAccessException illegalAccessException) {
            Fail.failWith("Java method cannot be accessed");
            return null;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="Dll.dll_handle array")
    public static Value caml_dynlink_get_current_libs(Value value) throws FailException {
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        if (codeRunner.isNative()) {
            Fail.invalidArgument("dynlink_get_current_libs");
        }
        return codeRunner.getContext().getCodeState().makeLibsArray();
    }
}

