/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.HashMap;
import tcl.lang.CallFrame;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.Procedure;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;

public class ItclAccess {
    public static boolean isProcCallFrame(CallFrame frame) {
        return frame.isProcCallFrame;
    }

    public static void setProcCallFrameFalse(CallFrame frame) {
        frame.isProcCallFrame = false;
    }

    public static TclObject[] getCallFrameObjv(CallFrame frame) {
        return frame.objv;
    }

    public static Namespace getCallFrameNamespace(CallFrame frame) {
        return frame.ns;
    }

    public static void setCallFrameObjv(CallFrame frame, TclObject[] objv) {
        frame.objv = objv;
    }

    public static CallFrame getCallFrame(Interp interp, int level) {
        CallFrame frame = interp.varFrame;
        while (frame != null && level > 0) {
            frame = frame.callerVar;
            --level;
        }
        return frame;
    }

    public static CallFrame activateCallFrame(Interp interp, CallFrame frame) {
        CallFrame oldFrame = interp.varFrame;
        interp.varFrame = frame;
        return oldFrame;
    }

    public static CallFrame newCallFrame(Interp i) {
        return new CallFrame(i);
    }

    public static CallFrame getVarFrame(Interp i) {
        return i.varFrame;
    }

    public static HashMap getVarTable(CallFrame frame) {
        return frame.varTable;
    }

    public static void setVarTable(CallFrame frame, HashMap table) {
        frame.varTable = table;
    }

    public static Var newVar() {
        return new Var();
    }

    public static void deleteVars(Interp interp, HashMap varTable) {
        Var.deleteVars((Interp)interp, (HashMap)varTable);
    }

    public static int decrVarRefCount(Var var) {
        --var.refCount;
        return var.refCount;
    }

    public static Procedure newProcedure(Interp interp, Namespace ns, String name, TclObject args, TclObject b, String sFileName, int sLineNumber) throws TclException {
        return new Procedure(interp, ns, name, args, b, sFileName, sLineNumber);
    }

    public static TclObject[][] getArgList(Procedure proc) {
        return proc.argList;
    }

    public static void setWrappedCommand(Procedure proc, WrappedCommand wcmd) {
        proc.wcmd = wcmd;
    }

    public static void assignLocalVar(Interp interp, String name, TclObject val, CallFrame frame) throws TclException {
        if (frame.varTable == null) {
            frame.varTable = new HashMap();
        }
        Var var = new Var();
        var.clearVarInHashtable();
        var.table = frame.varTable;
        frame.varTable.put(name, var);
        interp.setVar(name, null, val, 0);
    }

    public static void createObjVar(Var var, String key, Namespace ns, HashMap table) {
        var.hashKey = key;
        var.ns = ns;
        var.table = table;
        var.refCount = 1;
    }

    public static void createCommonVar(Var var, String key, Namespace ns, HashMap table) {
        var.table = table;
        var.hashKey = key;
        var.ns = ns;
        var.setVarNamespace();
        ++var.refCount;
        ++var.refCount;
    }

    public static Object FirstHashEntry(HashMap table) {
        return Namespace.FirstHashEntry((HashMap)table);
    }
}

