/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="Condition", source="")
public final class Condition {
    private Condition() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Condition.t"}, returnType="unit")
    public static Value ocamljava_condition_await(Value value) throws FailException {
        java.util.concurrent.locks.Condition condition = (java.util.concurrent.locks.Condition)value.asCustom();
        try {
            condition.await();
            return Value.UNIT;
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.Condition.await");
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Condition.await");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Condition.t", "int64", "TimeUnit.t"}, returnType="unit")
    public static Value ocamljava_condition_await_time(Value value, Value value2, Value value3) throws FailException {
        java.util.concurrent.locks.Condition condition = (java.util.concurrent.locks.Condition)value.asCustom();
        try {
            condition.await(value2.asInt64(), TimeUnit.decode(value3));
            return Value.UNIT;
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.Condition.await_time");
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Condition.await_time");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Condition.t", "int64"}, returnType="int64")
    public static Value ocamljava_condition_await_nanos(Value value, Value value2) throws FailException {
        java.util.concurrent.locks.Condition condition = (java.util.concurrent.locks.Condition)value.asCustom();
        try {
            long l = condition.awaitNanos(value2.asInt64());
            return Value.createInt64(l);
        }
        catch (InterruptedException interruptedException) {
            Runtime.raiseInterrupted("Concurrent.Condition.await_nanos");
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Condition.await_nanos");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Condition.t"}, returnType="unit")
    public static Value ocamljava_condition_await_uninterruptibly(Value value) throws FailException {
        java.util.concurrent.locks.Condition condition = (java.util.concurrent.locks.Condition)value.asCustom();
        try {
            condition.awaitUninterruptibly();
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Condition.await_uninterruptibly");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Condition.t"}, returnType="unit")
    public static Value ocamljava_condition_signal(Value value) throws FailException {
        java.util.concurrent.locks.Condition condition = (java.util.concurrent.locks.Condition)value.asCustom();
        try {
            condition.signal();
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Condition.signal");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Condition.t"}, returnType="unit")
    public static Value ocamljava_condition_signal_all(Value value) throws FailException {
        java.util.concurrent.locks.Condition condition = (java.util.concurrent.locks.Condition)value.asCustom();
        try {
            condition.signalAll();
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.Condition.signal_all");
            return Value.UNIT;
        }
    }
}

