/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.image.BufferedImage;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="graph", module="Graphics", source="otherlibs/graph/dump_img.c")
public final class DumpImage {
    private DumpImage() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Graphics.image"}, returnType="Graphics.color array array")
    public static Value caml_gr_dump_image(Value value) throws FailException {
        GraphSlot.checkGraph();
        BufferedImage bufferedImage = (BufferedImage)value.asCustom();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        Value value2 = Value.createBlock(0, n2);
        int[] nArray = bufferedImage.getRGB(0, 0, n, n2, null, 0, n);
        for (int i = 0; i < n2; ++i) {
            Value value3 = Value.createBlock(0, n);
            for (int j = 0; j < n; ++j) {
                int n3 = nArray[j * n + i];
                if ((n3 & 0xFF000000) != 0) {
                    value3.set(j, Value.createLong(n3 & 0xFFFFFF));
                    continue;
                }
                value3.set(j, Value.MINUS_ONE);
            }
            value2.set(i, value3);
        }
        return value2;
    }
}

