/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.systhreads;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.LockSupport;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.Mutex;

final class Condition {
    private final Queue<Thread> waiters = new ConcurrentLinkedQueue<Thread>();
    private static final Object LOCK = new Object();

    Condition() {
    }

    void signal() {
        LockSupport.unpark(this.waiters.poll());
    }

    void broadcast() {
        Thread th = this.waiters.poll();
        while (th != null) {
            LockSupport.unpark(th);
            th = this.waiters.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wait(Context ctxt, Mutex mut) throws FailException, FalseExit {
        Object object = LOCK;
        synchronized (object) {
            try {
                mut.unlock();
            }
            catch (IllegalMonitorStateException imse) {
                Fail.raiseSysError("Condition.wait: " + imse.toString());
            }
            Thread current = Thread.currentThread();
            this.waiters.add(current);
        }
        Thread.yield();
        CurrentContext.enterBlockingSection();
        LockSupport.park();
        mut.lock(ctxt);
        CurrentContext.leaveBlockingSection();
    }
}

