/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.NativeApply;
import org.ocamljava.runtime.primitives.stdlib.Array;
import org.ocamljava.runtime.values.Value;

public final class ArrayFunctions {
    private ArrayFunctions() {
    }

    public static Value init_int(long l, Value value) throws FailException, FatalError, Throwable {
        long l2 = l >> 1;
        if (l2 == 0L) {
            return CurrentContext.CODE_STATE.getAtom(0);
        }
        if (l2 > 0x3FFFFFFFFFFFFFL) {
            Fail.invalidArgument("Array.make");
        }
        Value value2 = Value.createLongBlockFromSize(0, l2);
        long l3 = 1L;
        int n = 0;
        while ((long)n < l2) {
            Value value3 = NativeApply.apply(value, Value.createFromRawLong(l3));
            value2.setRawLong(n, value3.getRawValue());
            l3 += 2L;
            ++n;
        }
        return value2;
    }

    public static Value of_list_int(Value value) {
        if (value.isBlock()) {
            long l = ArrayFunctions.list_length(value);
            Value value2 = Value.createLongBlockFromSize(0, l);
            long l2 = 0L;
            Value value3 = value;
            while (value3.isBlock()) {
                value2.setRawLong(l2++, value3.get0().getRawValue());
                value3 = value3.get1();
            }
            return value2;
        }
        return CurrentContext.CODE_STATE.getAtom(0);
    }

    public static long list_length(Value value) {
        long l = 0L;
        Value value2 = value;
        while (value2.isBlock()) {
            value2 = value2.get1();
            ++l;
        }
        return l;
    }

    public static Value map_int(Value value, Value value2) throws FailException, FatalError, Throwable {
        long l = value2.sizeValues();
        if (l == 0L) {
            return CurrentContext.CODE_STATE.getAtom(0);
        }
        Value value3 = Value.createLongBlockFromSize(0, l);
        int n = 0;
        while ((long)n < l) {
            Value value4 = NativeApply.apply(value, value2.get(n));
            value3.setRawLong(n, value4.getRawValue());
            ++n;
        }
        return value3;
    }

    public static Value mapi_int(Value value, Value value2) throws FailException, FatalError, Throwable {
        long l = value2.sizeValues();
        if (l == 0L) {
            return CurrentContext.CODE_STATE.getAtom(0);
        }
        Value value3 = Value.createLongBlockFromSize(0, l);
        long l2 = 1L;
        int n = 0;
        while ((long)n < l) {
            Value value4 = NativeApply.apply(value, Value.createFromRawLong(l2), value2.get(n));
            value3.setRawLong(n, value4.getRawValue());
            l2 += 2L;
            ++n;
        }
        return value3;
    }

    public static Value make_matrix_int(long l, long l2, long l3) throws FailException {
        long l4 = l >> 1;
        if (l4 == 0L) {
            return CurrentContext.CODE_STATE.getAtom(0);
        }
        Value value = Value.createBlock(0, l4);
        int n = 0;
        while ((long)n < l4) {
            value.set(n, Array.caml_make_vect_int$(l2, l3));
            ++n;
        }
        return value;
    }

    public static Value create_matrix_int(long l, long l2, long l3) throws FailException {
        return ArrayFunctions.make_matrix_int(l, l2, l3);
    }
}

