/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.javabase;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.AbstractCodeRunner;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.NativeApply;
import org.ocamljava.runtime.kernel.NativeArithmetic;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.javalibs.javabase.MethodMapping;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="[XXX]", module="[XXX]", source="XXX.c")
public final class Java {
    private Java() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="JavaString.t array")
    public static Value ocamljava_get_argv(Value value) {
        String[] stringArray = CurrentContext.PARAMETERS.getArguments();
        int n = stringArray.length;
        Value value2 = Value.createBlock(0, n);
        for (int i = 0; i < n; ++i) {
            value2.set(i, Value.createInstance(stringArray[i]));
        }
        return value2;
    }

    public static Object ocamljava_java_make_proxy(Class<?>[] classArray, Value value, MethodMapping methodMapping) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        ProxyInvocationHandler proxyInvocationHandler = new ProxyInvocationHandler(value, codeRunner, methodMapping);
        Object object = Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)proxyInvocationHandler);
        return object;
    }

    private static Object unconvert(Value value, Class<?> clazz) {
        if (Value.class.equals(clazz)) {
            return value;
        }
        if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            return value != Value.FALSE ? Boolean.TRUE : Boolean.FALSE;
        }
        if (Byte.class.equals(clazz) || Byte.TYPE.equals(clazz)) {
            return (byte)value.asLong();
        }
        if (Character.class.equals(clazz) || Character.TYPE.equals(clazz)) {
            return Character.valueOf((char)value.asLong());
        }
        if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
            return value.asDouble();
        }
        if (Float.class.equals(clazz) || Float.TYPE.equals(clazz)) {
            return Float.valueOf((float)value.asDouble());
        }
        if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
            return value.asInt32();
        }
        if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
            return value.asInt64();
        }
        if (Short.class.equals(clazz) || Short.TYPE.equals(clazz)) {
            return (short)value.asLong();
        }
        if (Void.TYPE.equals(clazz)) {
            return null;
        }
        return value.asCustom();
    }

    private static Value convert(Object object, Class<?> clazz) {
        if (Value.class.equals(clazz)) {
            return (Value)object;
        }
        if (Boolean.class.equals(clazz)) {
            return (Boolean)object != false ? Value.TRUE : Value.FALSE;
        }
        if (Byte.class.equals(clazz) || Byte.TYPE.equals(clazz)) {
            return Value.createLong(((Byte)object).byteValue());
        }
        if (Character.class.equals(clazz) || Character.TYPE.equals(clazz)) {
            return Value.createLong(((Character)object).charValue());
        }
        if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
            return Value.createDouble((Double)object);
        }
        if (Float.class.equals(clazz) || Float.TYPE.equals(clazz)) {
            return Value.createDouble(((Float)object).floatValue());
        }
        if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
            return Value.createInt32((Integer)object);
        }
        if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
            return Value.createInt64((Long)object);
        }
        if (Short.class.equals(clazz) || Short.TYPE.equals(clazz)) {
            return Value.createLong(((Short)object).shortValue());
        }
        return Value.createInstance(object);
    }

    private static final long methodTag(String string) {
        long l = 1L;
        long l2 = 447L;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            long l3 = IntegerUtils.signedToUnsignedByte(EncodingUtils.convertCharToByte(string.charAt(i)));
            l = NativeArithmetic.mulint(447L, l);
            l = NativeArithmetic.addint(l, l3 << 1 | 1L);
        }
        long l4 = l >> 1;
        l4 = (l4 &= Integer.MAX_VALUE) > 0x3FFFFFFFL ? l4 - 0x80000000L : l4;
        return l4 << 1 | 1L;
    }

    static class ProxyInvocationHandler
    implements InvocationHandler {
        private final Value instance;
        private final CodeRunner runner;
        private final MethodMapping mapping;
        private final Map<Method, Value> cache;

        ProxyInvocationHandler(Value value, CodeRunner codeRunner, MethodMapping methodMapping) {
            assert (value != null) : "null i";
            assert (codeRunner != null) : "null cr";
            assert (methodMapping != null) : "null mm";
            this.instance = value;
            this.runner = codeRunner;
            this.mapping = methodMapping;
            this.cache = new HashMap<Method, Value>();
        }

        private Value getClosure(Method method) {
            Value value = this.cache.get(method);
            if (value == null) {
                String string = this.mapping.get(method);
                if (string == null) {
                    return null;
                }
                Value value2 = AbstractCodeRunner.getMethod(this.instance, Java.methodTag(string));
                this.cache.put(method, value2);
                return value2;
            }
            return value;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Object object2;
            Value value = this.getClosure(method);
            if (value == null) {
                return method.invoke((Object)this, objectArray);
            }
            int n = objectArray == null ? 0 : objectArray.length;
            Value[] valueArray = new Value[n + 1];
            Class<?>[] classArray = method.getParameterTypes();
            valueArray[0] = this.instance;
            for (int i = 0; i < n; ++i) {
                object2 = Java.convert(objectArray[i], classArray[i]);
                valueArray[i + 1] = object2;
            }
            OCamlJavaThread.registerCodeRunner(Thread.currentThread(), this.runner);
            Value value2 = NativeApply.apply(value, valueArray);
            object2 = Java.unconvert(value2, method.getReturnType());
            return object2;
        }
    }
}

