/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.javalibs.concurrent.FutureCallable;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="ExecutorCompletionService", source="")
public final class ExecutorCompletionService {
    private ExecutorCompletionService() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadPoolExecutor.t"}, returnType="ExecutorCompletionService.t")
    public static Value ocamljava_executorcompletionservice_make(Value exec) {
        java.util.concurrent.ExecutorCompletionService inst = new java.util.concurrent.ExecutorCompletionService((ThreadPoolExecutor)exec.asCustom());
        return Value.createInstance(inst);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ExecutorCompletionService.t"}, returnType="'a Future.t option")
    public static Value ocamljava_executorcompletionservice_poll(Value obj) {
        java.util.concurrent.ExecutorCompletionService inst = (java.util.concurrent.ExecutorCompletionService)obj.asCustom();
        Future res = inst.poll();
        return res == null ? Value.ZERO : Value.createBlock(0, Value.createInstance(res));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ExecutorCompletionService.t", "int64", "TimeUnit.t"}, returnType="'a Future.t option")
    public static Value ocamljava_executorcompletionservice_poll_time(Value obj, Value timeout, Value unit) throws FailException {
        java.util.concurrent.ExecutorCompletionService inst = (java.util.concurrent.ExecutorCompletionService)obj.asCustom();
        try {
            Future res = inst.poll(timeout.asInt64(), TimeUnit.decode(unit));
            return res == null ? Value.ZERO : Value.createBlock(0, Value.createInstance(res));
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.ExecutorCompletionService.poll_time");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ExecutorCompletionService.t", "('a -> 'b)", "'a"}, returnType="'b Future.t")
    public static Value ocamljava_executorcompletionservice_submit(Value obj, Value task, Value value) {
        java.util.concurrent.ExecutorCompletionService inst = (java.util.concurrent.ExecutorCompletionService)obj.asCustom();
        return Value.createInstance(inst.submit(new FutureCallable(task, value)));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ExecutorCompletionService.t"}, returnType="'a Future.t")
    public static Value ocamljava_executorcompletionservice_take(Value obj) throws FailException {
        java.util.concurrent.ExecutorCompletionService inst = (java.util.concurrent.ExecutorCompletionService)obj.asCustom();
        try {
            return Value.createInstance(inst.take());
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.ExecutorCompletionService.take");
            return Value.UNIT;
        }
    }
}

