/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="Runtime", source="")
public final class Runtime {
    private Runtime() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="int64")
    public static Value ocamljava_runtime_current_time_millis(Value unit) {
        return Value.createInt64(System.currentTimeMillis());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="int64")
    public static Value ocamljava_runtime_nano_time(Value unit) {
        return Value.createInt64(System.nanoTime());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="int32")
    public static Value ocamljava_runtime_available_processors(Value unit) {
        return Value.createInt32(java.lang.Runtime.getRuntime().availableProcessors());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="int64")
    public static Value ocamljava_runtime_free_memory(Value unit) {
        return Value.createInt64(java.lang.Runtime.getRuntime().freeMemory());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="int64")
    public static Value ocamljava_runtime_max_memory(Value unit) {
        return Value.createInt64(java.lang.Runtime.getRuntime().maxMemory());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="int64")
    public static Value ocamljava_runtime_total_memory(Value unit) {
        return Value.createInt64(java.lang.Runtime.getRuntime().totalMemory());
    }

    static void raiseInterrupted(String arg) throws FailException {
        Value exn = CurrentContext.getCodeState().getCallback("Concurrent.Runtime.Interrupted");
        if (exn != null) {
            Fail.raiseWithString(exn, arg);
        } else {
            Fail.invalidArgument("Exception Concurrent.Runtime.Interrupted not initialized");
        }
    }

    static void raiseTimeout(String arg) throws FailException {
        Value exn = CurrentContext.getCodeState().getCallback("Concurrent.Runtime.Timeout");
        if (exn != null) {
            Fail.raiseWithString(exn, arg);
        } else {
            Fail.invalidArgument("Exception Concurrent.Runtime.Timeout not initialized");
        }
    }

    static void raiseRaised(FailException raised) throws FailException {
        Value exn = CurrentContext.getCodeState().getCallback("Concurrent.Runtime.Raised");
        if (exn != null) {
            Fail.raiseWithArg(exn, raised.getValue());
        } else {
            Fail.invalidArgument("Exception Concurrent.Runtime.Raised not initialized");
        }
    }
}

