/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.values.Value;

public final class NativeArithmetic {
    private NativeArithmetic() {
    }

    public static long negint(long x) {
        return 2L - x;
    }

    public static long incrint(long x) {
        return x + 2L;
    }

    public static long decrint(long x) {
        return x - 2L;
    }

    public static long addint(long x, long y) {
        return x + y - 1L;
    }

    public static long subint(long x, long y) {
        return x - y + 1L;
    }

    public static long mulint(long x, long y) {
        return (x >> 1) * (y >> 1) << 1 | 1L;
    }

    public static long divint(long x, long y) throws FailException {
        try {
            return (x >> 1) / (y >> 1) << 1 | 1L;
        }
        catch (Throwable t) {
            Fail.raiseZeroDivide();
            return 0L;
        }
    }

    public static int divint32(int x, int y) throws FailException {
        try {
            return x / y;
        }
        catch (Throwable t) {
            Fail.raiseZeroDivide();
            return 0;
        }
    }

    public static long modint(long x, long y) throws FailException {
        try {
            return (x >> 1) % (y >> 1) << 1 | 1L;
        }
        catch (Throwable t) {
            Fail.raiseZeroDivide();
            return 0L;
        }
    }

    public static int modint32(int x, int y) throws FailException {
        try {
            return x % y;
        }
        catch (Throwable t) {
            Fail.raiseZeroDivide();
            return 0;
        }
    }

    public static long lslint(long x, long y) {
        return (x - 1L << (int)y) + 1L;
    }

    public static long lsrint(long x, long y) {
        return x - 1L >>> (int)y | 1L;
    }

    public static long asrint(long x, long y) {
        return x - 1L >> (int)y | 1L;
    }

    public static long divint64(long x, long y) throws FailException {
        try {
            return x / y;
        }
        catch (Throwable t) {
            Fail.raiseZeroDivide();
            return 0L;
        }
    }

    public static long modint64(long x, long y) throws FailException {
        try {
            return x % y;
        }
        catch (Throwable t) {
            Fail.raiseZeroDivide();
            return 0L;
        }
    }

    public static long offsetint(long x, long n) {
        return x + n - 1L;
    }

    public static void offsetref(Value v, long n) {
        v.set0(Value.createFromRawValue(v.get0().getRawValue() + n));
    }
}

