/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.ocamljava.runtime.gui.CopyThread;
import org.ocamljava.runtime.kernel.Executable;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.OCamlJavaException;

public final class InOutPanel
extends JPanel
implements Runnable {
    static final long serialVersionUID = 2411640127352426825L;
    private static final String OUTPUT_FONT = "Monospaced";
    private static final String SEND = "send";
    private static final String HISTORY = "history";
    private static final String SAVE = "save";
    private static final String CLOSE = "close";
    private static final String ERROR_TITLE = "Error";
    private static final String ERROR_MESSAGE = "Unable to write to file";
    private static final int BORDER = 16;
    private final transient Executable executable;
    private final JTextArea output;
    private final JScrollPane scroll;
    private final JTextArea source;
    private final List<String> history;
    private int position;
    private final transient PrintStream standardInput;
    private final transient InputStream standardOutput;
    private final transient InputStream standardError;
    private final Action sendAction = new AbstractAction(){
        static final long serialVersionUID = 3237743495969414638L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = InOutPanel.this.source.getText();
            InOutPanel.this.standardInput.println(string);
            JTextArea jTextArea = InOutPanel.this.output;
            synchronized (jTextArea) {
                InOutPanel.this.output.append(string);
                InOutPanel.this.output.append("\n");
            }
            InOutPanel.this.source.setText("");
            InOutPanel.this.source.grabFocus();
            InOutPanel.this.history.add(0, string);
            InOutPanel.this.position = -1;
            InOutPanel.this.repaint();
        }
    };

    public InOutPanel(Executable executable, PrintStream printStream, InputStream inputStream, InputStream inputStream2) {
        super(new BorderLayout());
        assert (executable != null) : "null exec";
        assert (printStream != null) : "null in";
        assert (inputStream != null) : "null out";
        assert (inputStream2 != null) : "null err";
        this.executable = executable;
        this.standardInput = printStream;
        this.standardOutput = inputStream;
        this.standardError = inputStream2;
        this.history = new LinkedList<String>();
        this.position = -1;
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 4, 4));
        this.output = new JTextArea();
        this.output.setName("org.ocamljava.runtime.gui.InOutPanel.output");
        this.output.setFont(new Font(OUTPUT_FONT, 0, this.output.getFont().getSize()));
        this.output.setEditable(false);
        this.source = new JTextArea();
        this.source.setName("org.ocamljava.runtime.gui.InOutPanel.source");
        Object object = new Object();
        this.source.getInputMap().put(KeyStroke.getKeyStroke(10, 2, true), object);
        this.source.getActionMap().put(object, this.sendAction);
        Object object2 = new Object();
        this.source.getInputMap().put(KeyStroke.getKeyStroke(38, 2, true), object2);
        this.source.getActionMap().put(object2, new HistoryNavigator(1));
        Object object3 = new Object();
        this.source.getInputMap().put(KeyStroke.getKeyStroke(40, 2, true), object3);
        this.source.getActionMap().put(object3, new HistoryNavigator(-1));
        this.scroll = new JScrollPane(this.output, 20, 30);
        jPanel.add(this.scroll);
        jPanel.add(new JScrollPane(this.source, 20, 30));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JButton jButton = new JButton(HISTORY);
        jButton.setName("org.ocamljava.runtime.gui.InOutPanel.history");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new HistoryDialog();
            }
        });
        JButton jButton2 = new JButton(SEND);
        jButton2.setName("org.ocamljava.runtime.gui.InOutPanel.send");
        jButton2.addActionListener(this.sendAction);
        jPanel2.add((Component)jButton, "West");
        jPanel2.add(Box.createHorizontalGlue(), "Center");
        jPanel2.add((Component)jButton2, "East");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jPanel2, "South");
        this.add(Box.createVerticalStrut(16), "North");
        this.add(Box.createVerticalStrut(16), "South");
        this.add(Box.createHorizontalStrut(16), "East");
        this.add(Box.createHorizontalStrut(16), "West");
        this.add((Component)jPanel3, "Center");
        this.source.requestFocus();
        new CopyThread(inputStream, this.output, this.scroll).start();
        new CopyThread(inputStream2, this.output, this.scroll).start();
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block13: {
            try {
                this.executable.executeSilently();
            }
            catch (OCamlJavaException oCamlJavaException) {
                Throwable throwable = oCamlJavaException.getCause();
                if (throwable instanceof FailException || throwable instanceof FatalError) break block13;
                JTextArea jTextArea = this.output;
                synchronized (jTextArea) {
                    this.output.append("error: " + oCamlJavaException.getMessage());
                }
            }
            catch (Exception exception) {
                JTextArea jTextArea = this.output;
                synchronized (jTextArea) {
                    this.output.append("internal error: " + exception.getMessage());
                }
            }
            catch (Throwable throwable) {
                JTextArea jTextArea = this.output;
                synchronized (jTextArea) {
                    this.output.append("Java error: " + throwable.getMessage());
                }
            }
        }
    }

    private final class HistoryNavigator
    extends AbstractAction {
        static final long serialVersionUID = 123654288864806406L;
        private final int delta;

        private HistoryNavigator(int n) {
            this.delta = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InOutPanel.this.position += this.delta;
            int n = InOutPanel.this.history.size();
            if (InOutPanel.this.position >= n) {
                InOutPanel.this.position = n - 1;
            }
            if (InOutPanel.this.position < 0) {
                InOutPanel.this.position = 0;
            }
            if (InOutPanel.this.position >= 0 && InOutPanel.this.position < n) {
                String string = (String)InOutPanel.this.history.get(InOutPanel.this.position);
                InOutPanel.this.source.setText(string);
                InOutPanel.this.repaint();
            }
        }
    }

    private final class HistoryDialog
    extends JDialog {
        static final long serialVersionUID = -1057305832727479511L;

        private HistoryDialog() {
            super((Frame)null, "History", true);
            this.setDefaultCloseOperation(2);
            int n = InOutPanel.this.history.size();
            String[] stringArray = new String[n];
            InOutPanel.this.history.toArray(stringArray);
            final JList<String> jList = new JList<String>(stringArray);
            jList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        int n = jList.locationToIndex(mouseEvent.getPoint());
                        Object e = jList.getModel().getElementAt(n);
                        InOutPanel.this.source.setText(e.toString());
                    }
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            JButton jButton = new JButton(InOutPanel.SAVE);
            jButton.addActionListener(new ActionListener(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    if (jFileChooser.showSaveDialog(HistoryDialog.this) != 0) return;
                    try {
                        FileWriter fileWriter = new FileWriter(jFileChooser.getSelectedFile());
                        ListIterator listIterator = InOutPanel.this.history.listIterator(InOutPanel.this.history.size());
                        while (true) {
                            if (!listIterator.hasPrevious()) {
                                fileWriter.close();
                                return;
                            }
                            fileWriter.write((String)listIterator.previous());
                            fileWriter.write("\n\n");
                        }
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(HistoryDialog.this, InOutPanel.ERROR_MESSAGE, InOutPanel.ERROR_TITLE, 0);
                    }
                }
            });
            JButton jButton2 = new JButton(InOutPanel.CLOSE);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HistoryDialog.this.setVisible(false);
                }
            });
            jPanel.add((Component)jButton, "West");
            jPanel.add(Box.createHorizontalGlue(), "Center");
            jPanel.add((Component)jButton2, "East");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)new JScrollPane(jList, 20, 31), "Center");
            jPanel2.add((Component)jPanel, "South");
            this.add(Box.createVerticalStrut(16), "North");
            this.add(Box.createVerticalStrut(16), "South");
            this.add(Box.createHorizontalStrut(16), "East");
            this.add(Box.createHorizontalStrut(16), "West");
            this.add((Component)jPanel2, "Center");
            this.setSize(400, 300);
            this.setResizable(false);
            this.setVisible(true);
        }
    }
}

