/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/ftruncate.c")
public final class Ftruncate {
    private Ftruncate() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "int"}, returnType="unit")
    public static Value unix_ftruncate(Value value, Value value2) throws FailException, FalseExit {
        try {
            Channel channel = CurrentContext.FILES_STATE.getChannel(value.asCastedInt());
            if (channel == null) {
                Unix.fail("ftruncate", "invalid descriptor");
                return Value.UNIT;
            }
            channel.truncate(value2.asLong());
            return Value.UNIT;
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Unix.fail("ftruncate", iOException);
            return Value.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "int64"}, returnType="unit")
    public static Value unix_ftruncate_64(Value value, Value value2) throws FailException, FalseExit {
        try {
            Channel channel = CurrentContext.FILES_STATE.getChannel(value.asCastedInt());
            if (channel == null) {
                Unix.fail("ftruncate_64", "invalid descriptor");
                return Value.UNIT;
            }
            channel.truncate(value2.asInt64());
            return Value.UNIT;
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Unix.fail("ftruncate_64", iOException);
            return Value.UNIT;
        }
    }
}

