/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.util.Set;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/signals.c")
public final class Signals {
    private Signals() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.sigprocmask_command", "int list"}, returnType="int list")
    public static Value unix_sigprocmask(Value value, Value value2) {
        Set<Integer> set = CurrentContext.SIGNALS_STATE.blockSignals(value.asCastedInt(), org.ocamljava.runtime.kernel.Signals.decodeSignalSet(value2));
        return org.ocamljava.runtime.kernel.Signals.encodeSignalSet(set);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="int list")
    public static Value unix_sigpending(Value value) {
        return org.ocamljava.runtime.kernel.Signals.encodeSignalSet(CurrentContext.SIGNALS_STATE.getPendingSignals());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int list"}, returnType="unit")
    public static Value unix_sigsuspend(Value value) throws FalseExit, FailException {
        org.ocamljava.runtime.kernel.Signals.waitForSignal(CurrentContext.CONTEXT, org.ocamljava.runtime.kernel.Signals.decodeSignalSet(value));
        return Value.UNIT;
    }
}

