/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.janino.JavaSourceClassLoader;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.enumerator.EnumeratorSet;
import org.codehaus.janino.util.resource.DirectoryResourceCreator;
import org.codehaus.janino.util.resource.DirectoryResourceFinder;
import org.codehaus.janino.util.resource.PathResourceFinder;
import org.codehaus.janino.util.resource.Resource;
import org.codehaus.janino.util.resource.ResourceCreator;
import org.codehaus.janino.util.resource.ResourceFinder;

public class CachingJavaSourceClassLoader
extends JavaSourceClassLoader {
    private final ResourceFinder classFileCacheResourceFinder;
    private final ResourceCreator classFileCacheResourceCreator;
    private final ResourceFinder sourceFinder;

    public CachingJavaSourceClassLoader(ClassLoader parentClassLoader, File[] optionalSourcePath, String optionalCharacterEncoding, File cacheDirectory, EnumeratorSet debuggingInformation) {
        this(parentClassLoader, optionalSourcePath == null ? new DirectoryResourceFinder(new File(".")) : new PathResourceFinder(optionalSourcePath), optionalCharacterEncoding, new DirectoryResourceFinder(cacheDirectory), new DirectoryResourceCreator(cacheDirectory), debuggingInformation);
    }

    public CachingJavaSourceClassLoader(ClassLoader parentClassLoader, ResourceFinder sourceFinder, String optionalCharacterEncoding, ResourceFinder classFileCacheResourceFinder, ResourceCreator classFileCacheResourceCreator, EnumeratorSet debuggingInformation) {
        super(parentClassLoader, sourceFinder, optionalCharacterEncoding, debuggingInformation);
        this.classFileCacheResourceFinder = classFileCacheResourceFinder;
        this.classFileCacheResourceCreator = classFileCacheResourceCreator;
        this.sourceFinder = sourceFinder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Class findClass(String className) throws ClassNotFoundException {
        Map bytecodes;
        Resource classFileResource = this.classFileCacheResourceFinder.findResource(ClassFile.getClassFileResourceName(className));
        if (classFileResource != null) {
            Resource sourceResource = this.sourceFinder.findResource(ClassFile.getSourceResourceName(className));
            if (sourceResource == null) {
                throw new ClassNotFoundException(className);
            }
            if (sourceResource.lastModified() < classFileResource.lastModified()) {
                InputStream is = null;
                try {
                    is = classFileResource.open();
                    byte[] bytecode = CachingJavaSourceClassLoader.readInputStream(is);
                    return this.defineBytecode(className, bytecode);
                }
                catch (IOException ex) {
                    throw new ClassNotFoundException("Reading class file from \"" + classFileResource + "\"", ex);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        if ((bytecodes = this.generateBytecodes(className)) == null) {
            throw new ClassNotFoundException(className);
        }
        Iterator it = bytecodes.entrySet().iterator();
        while (true) {
            IOException ex3;
            Object var10_15;
            if (!it.hasNext()) {
                Class clazz = this.defineBytecodes(className, bytecodes);
                if (clazz != null) return clazz;
                throw new RuntimeException("Scanning, parsing and compiling class \"" + className + "\" did not create a class file!?");
            }
            Map.Entry me = it.next();
            String className2 = (String)me.getKey();
            byte[] bytecode = (byte[])me.getValue();
            OutputStream os = null;
            try {
                try {
                    os = this.classFileCacheResourceCreator.createResource(ClassFile.getClassFileResourceName(className2));
                    os.write(bytecode);
                }
                catch (IOException ex2) {
                    throw new ClassNotFoundException("Writing class file to \"" + ClassFile.getClassFileResourceName(className2) + "\"", ex2);
                }
                var10_15 = null;
                if (os == null) continue;
                {
                }
            }
            catch (Throwable throwable) {
                var10_15 = null;
                if (os == null) throw throwable;
                try {
                    os.close();
                    throw throwable;
                }
                catch (IOException ex3) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ex3) {}
            os.close();
        }
    }

    private static byte[] readInputStream(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CachingJavaSourceClassLoader.copy(is, baos);
        return baos.toByteArray();
    }

    private static void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[4096];
        int cnt;
        while ((cnt = is.read(buffer)) != -1) {
            os.write(buffer, 0, cnt);
        }
        return;
    }
}

