/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.Java;
import org.codehaus.janino.Location;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.WarningHandler;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.resource.Resource;
import org.codehaus.janino.util.resource.ResourceFinder;

final class JavaSourceIClassLoader
extends IClassLoader {
    private static final boolean DEBUG = false;
    private final ResourceFinder sourceFinder;
    private final String optionalCharacterEncoding;
    private final Set unitCompilers;
    private UnitCompiler.ErrorHandler optionalCompileErrorHandler = null;
    private WarningHandler optionalWarningHandler = null;

    public JavaSourceIClassLoader(ResourceFinder sourceFinder, String optionalCharacterEncoding, Set unitCompilers, IClassLoader optionalParentIClassLoader) {
        super(optionalParentIClassLoader);
        this.sourceFinder = sourceFinder;
        this.optionalCharacterEncoding = optionalCharacterEncoding;
        this.unitCompilers = unitCompilers;
        super.postConstruct();
    }

    public void setCompileErrorHandler(UnitCompiler.ErrorHandler optionalCompileErrorHandler) {
        this.optionalCompileErrorHandler = optionalCompileErrorHandler;
    }

    public void setWarningHandler(WarningHandler optionalWarningHandler) {
        this.optionalWarningHandler = optionalWarningHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public IClass findIClass(String type) throws ClassNotFoundException {
        String className = Descriptor.toClassName(type);
        if (className.startsWith("java.")) {
            return null;
        }
        Iterator it = this.unitCompilers.iterator();
        while (it.hasNext()) {
            UnitCompiler uc = (UnitCompiler)it.next();
            IClass res = uc.findClass(className);
            if (res == null) continue;
            this.defineIClass(res);
            return res;
        }
        Resource sourceResource = this.sourceFinder.findResource(ClassFile.getSourceResourceName(className));
        if (sourceResource == null) {
            return null;
        }
        try {
            void var5_8;
            InputStream inputStream = sourceResource.open();
            try {
                Scanner scanner = new Scanner(sourceResource.getFileName(), inputStream, this.optionalCharacterEncoding);
                scanner.setWarningHandler(this.optionalWarningHandler);
                Parser parser = new Parser(scanner);
                parser.setWarningHandler(this.optionalWarningHandler);
                Java.CompilationUnit cu = parser.parseCompilationUnit();
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {}
            }
            UnitCompiler uc = new UnitCompiler((Java.CompilationUnit)var5_8, this);
            uc.setCompileErrorHandler(this.optionalCompileErrorHandler);
            uc.setWarningHandler(this.optionalWarningHandler);
            this.unitCompilers.add(uc);
            IClass res = uc.findClass(className);
            if (res == null) {
                throw new Parser.ParseException("Source file \"" + sourceResource.getFileName() + "\" does not declare class \"" + className + "\"", (Location)null);
            }
            this.defineIClass(res);
            return res;
        }
        catch (Scanner.ScanException e) {
            throw new ClassNotFoundException("Parsing compilation unit \"" + sourceResource + "\"", e);
        }
        catch (Parser.ParseException e) {
            throw new ClassNotFoundException("Parsing compilation unit \"" + sourceResource + "\"", e);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Parsing compilation unit \"" + sourceResource + "\"", e);
        }
    }
}

