/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.PackingException;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkJFrame;
import com.onemoonscientific.swank.Widgets;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class PackerLayout
implements LayoutManager2 {
    private static Hashtable option_table;
    private static Hashtable value_table;
    private static Hashtable value_object_table;
    private static final String OPT_ANCHOR = "-anchor";
    private static final String OPT_EXPAND = "-expand";
    private static final String OPT_FILL = "-fill";
    private static final String OPT_IPADX = "-ipadx";
    private static final String OPT_IPADY = "-ipady";
    private static final String OPT_PADX = "-padx";
    private static final String OPT_PADY = "-pady";
    private static final String OPT_SIDE = "-side";
    private static final String ANCHOR_OPT_N = "n";
    private static final String ANCHOR_OPT_NE = "ne";
    private static final String ANCHOR_OPT_E = "e";
    private static final String ANCHOR_OPT_SE = "se";
    private static final String ANCHOR_OPT_S = "s";
    private static final String ANCHOR_OPT_SW = "sw";
    private static final String ANCHOR_OPT_W = "w";
    private static final String ANCHOR_OPT_NW = "nw";
    private static final String ANCHOR_OPT_C = "center";
    private static final Object ANCHOR_OBJ_N;
    private static final Object ANCHOR_OBJ_NE;
    private static final Object ANCHOR_OBJ_E;
    private static final Object ANCHOR_OBJ_SE;
    private static final Object ANCHOR_OBJ_S;
    private static final Object ANCHOR_OBJ_SW;
    private static final Object ANCHOR_OBJ_W;
    private static final Object ANCHOR_OBJ_NW;
    private static final Object ANCHOR_OBJ_C;
    private static final String EXPAND_OPT_YES = "1";
    private static final String EXPAND_OPT_NO = "0";
    private static final String FILL_OPT_NONE = "none";
    private static final String FILL_OPT_X = "x";
    private static final String FILL_OPT_Y = "y";
    private static final String FILL_OPT_BOTH = "both";
    private static final Object FILL_OBJ_NONE;
    private static final Object FILL_OBJ_X;
    private static final Object FILL_OBJ_Y;
    private static final Object FILL_OBJ_BOTH;
    private static final String SIDE_OPT_TOP = "top";
    private static final String SIDE_OPT_BOTTOM = "bottom";
    private static final String SIDE_OPT_LEFT = "left";
    private static final String SIDE_OPT_RIGHT = "right";
    private static final Object SIDE_OBJ_TOP;
    private static final Object SIDE_OBJ_BOTTOM;
    private static final Object SIDE_OBJ_LEFT;
    private static final Object SIDE_OBJ_RIGHT;
    private static final Object DEFAULT_ANCHOR;
    private static final boolean DEFAULT_EXPAND = false;
    private static final Object DEFAULT_FILL;
    private static final int DEFAULT_IPADX = 0;
    private static final int DEFAULT_IPADY = 0;
    private static final int DEFAULT_PADX = 0;
    private static final int DEFAULT_PADY = 0;
    private static final Object DEFAULT_SIDE;
    private static final Object INT_MAP;
    private static final NumberFormatException NFE;
    private static final Object BOOLEAN_MAP;
    private static final Object SIZE_MAP;
    private static final Dimension RetDimension;
    private Hashtable component_table;
    private Component firstcomp;
    private Component lastcomp;
    private boolean ignore_next_remove = false;
    Interp interp = null;
    boolean propagate = true;

    public PackerLayout(Interp interp) {
        this.interp = interp;
        this.component_table = new Hashtable();
        this.firstcomp = null;
        this.lastcomp = null;
        this.propagate = true;
    }

    private static String[] split(String in, char splitchar) {
        int len = in.length();
        char[] str = new char[len + 1];
        in.getChars(0, len, str, 0);
        str[len++] = splitchar;
        int wordstart = 0;
        Vector<String> words = new Vector<String>(3);
        for (int i = 0; i < len; ++i) {
            if (str[i] != splitchar) continue;
            if (wordstart <= i - 1) {
                words.addElement(new String(str, wordstart, i - wordstart));
            }
            wordstart = i + 1;
        }
        Object[] ret = new String[words.size()];
        words.copyInto(ret);
        return ret;
    }

    public Dimension maximumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    public void invalidateLayout(Container target) {
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        this.addLayoutComponent((String)constraints, comp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addLayoutComponent(String spec, Component comp) {
        TclObject[] argv;
        if (comp == null) {
            return;
        }
        boolean new_record = false;
        PackRecord pr = (PackRecord)this.component_table.get(comp);
        if (pr == null) {
            pr = new PackRecord();
            new_record = true;
        }
        try {
            argv = TclList.getElements((Interp)this.interp, (TclObject)TclString.newInstance((String)spec));
        }
        catch (TclException tclE) {
            throw new PackingException(tclE.toString());
        }
        if (argv.length % 2 != 0) {
            throw new PackingException("Fatal error in PackerLayout string spec, must have even number of arguments");
        }
        int max = argv.length;
        for (int i = 0; i < max; i += 2) {
            Object value;
            Object option = option_table.get(argv[i].toString());
            if (option == INT_MAP) {
                try {
                    int num = Integer.parseInt(argv[i + 1].toString());
                    if (num >= 0) continue;
                    throw NFE;
                }
                catch (NumberFormatException e) {
                    throw new PackingException("error : value of the " + argv[i].toString() + " option must be a non negative integer");
                }
            }
            if (option == SIZE_MAP) {
                TclObject[] size_args = null;
                try {
                    size_args = TclList.getElements((Interp)this.interp, (TclObject)argv[i + 1]);
                }
                catch (TclException tclE) {
                    throw new PackingException("error : can't get pad list");
                }
                if (size_args.length < 1 || size_args.length > 2) {
                    throw new PackingException("error : size_args wrong length");
                }
                int num = -1;
                for (int iArg = 0; iArg < size_args.length; ++iArg) {
                    try {
                        num = SwankUtil.getTkSize(this.interp, comp, size_args[iArg].toString());
                    }
                    catch (TclException tclE) {
                        // empty catch block
                    }
                    if (num < 0) {
                        throw new PackingException("error : value of the " + argv[i].toString() + " option must be a non negative integer");
                    }
                    value = value_table.get(argv[i].toString());
                    if (value == null) {
                        String str = "null value object for int parser on option \"" + argv[i].toString() + "\" : \"" + argv[i + 1].toString() + "\"";
                        throw new RuntimeException(str);
                    }
                    if (value == OPT_PADX) {
                        pr.padx[iArg] = num;
                        if (iArg != 0) continue;
                        pr.padx[1] = num;
                        continue;
                    }
                    if (value == OPT_PADY) {
                        pr.pady[iArg] = num;
                        if (iArg != 0) continue;
                        pr.pady[1] = num;
                        continue;
                    }
                    if (value == OPT_IPADX) {
                        pr.ipadx[iArg] = num;
                        if (iArg != 0) continue;
                        pr.ipadx[1] = num;
                        continue;
                    }
                    if (value != OPT_IPADY) throw new RuntimeException("fatal : bad branch");
                    pr.ipady[iArg] = num;
                    if (iArg != 0) continue;
                    pr.ipady[1] = num;
                }
                continue;
            }
            if (option == BOOLEAN_MAP) {
                boolean bool;
                String s = argv[i + 1].toString();
                if (s.length() <= 0) throw new PackingException("error : value of the " + argv[i].toString() + " option must be a boolean");
                if ("yes".startsWith(s)) {
                    bool = true;
                } else if ("no".startsWith(s)) {
                    bool = false;
                } else if ("true".startsWith(s)) {
                    bool = true;
                } else if ("false".startsWith(s)) {
                    bool = false;
                } else if ("on".startsWith(s) && s.length() > 1) {
                    bool = true;
                } else if ("off".startsWith(s) && s.length() > 1) {
                    bool = false;
                } else if (s.equals(EXPAND_OPT_NO)) {
                    bool = false;
                } else {
                    if (!s.equals(EXPAND_OPT_YES)) throw new PackingException("error : value of the " + argv[i].toString() + " option must be a boolean");
                    bool = true;
                }
                value = value_table.get(argv[i].toString());
                if (value == null) {
                    String str = "null value object for int parser on option \"" + argv[i].toString() + "\" : \"" + argv[i + 1].toString() + "\"";
                    throw new RuntimeException(str);
                }
                if (value != OPT_EXPAND) throw new RuntimeException("fatal : bad branch");
                pr.expand = bool;
                continue;
            }
            if (option == null) {
                throw new PackingException("bad option \"" + argv[i].toString() + "\": must be " + "-after" + ", " + OPT_ANCHOR + ", " + "-before" + ", " + OPT_EXPAND + ", " + OPT_FILL + ", " + "-in" + ", " + OPT_IPADX + ", " + OPT_IPADY + ", " + OPT_PADX + ", " + OPT_PADY + ", or " + OPT_SIDE);
            }
            if (option != value_table.get(argv[i + 1].toString())) {
                throw new PackingException("error : option \"" + argv[i].toString() + "\" can not take the value \"" + argv[i + 1].toString() + "\"");
            }
            value = value_object_table.get(argv[i + 1].toString());
            if (value == null) {
                String str = "null value object for option parser on option \"" + argv[i].toString() + "\" : \"" + argv[i + 1].toString() + "\"";
                throw new RuntimeException(str);
            }
            if (option == OPT_ANCHOR) {
                pr.anchor = value;
                continue;
            }
            if (option == OPT_FILL) {
                pr.fill = value;
                continue;
            }
            if (option != OPT_SIDE) throw new RuntimeException("fatal : bad branch");
            pr.side = value;
        }
        if (!new_record) return;
        this.component_table.put(comp, pr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkPackArgs(Interp interp, String spec, Component comp) throws TclException {
        boolean new_record = false;
        TclObject[] argv = TclList.getElements((Interp)interp, (TclObject)TclString.newInstance((String)spec));
        int max = argv.length;
        for (int i = 0; i < max; i += 2) {
            Object value;
            int num;
            Object option = option_table.get(argv[i].toString());
            if (option == null) {
                throw new TclException(interp, "bad option \"" + argv[i].toString() + "\": must be " + "-after" + ", " + OPT_ANCHOR + ", " + "-before" + ", " + OPT_EXPAND + ", " + OPT_FILL + ", " + "-in" + ", " + OPT_IPADX + ", " + OPT_IPADY + ", " + OPT_PADX + ", " + OPT_PADY + ", or " + OPT_SIDE);
            }
            if (i + 1 >= max) {
                throw new TclException(interp, "no value for argument \"" + argv[i].toString() + "\"");
            }
            if (option == INT_MAP) {
                try {
                    num = Integer.parseInt(argv[i + 1].toString());
                    if (num >= 0) continue;
                    throw new TclException(interp, "negative value");
                }
                catch (NumberFormatException e) {
                    throw new TclException(interp, "error : value of the " + argv[i].toString() + " option must be a non negative integer");
                }
            }
            if (option == SIZE_MAP) {
                value = value_table.get(argv[i].toString());
                if (value == null) {
                    String str = "null value object for int parser on option \"" + argv[i].toString() + "\" : \"" + argv[i + 1].toString() + "\"";
                    throw new TclException(interp, str);
                }
                if (value != OPT_PADX && value != OPT_PADY && value != OPT_IPADX && value != OPT_IPADY) {
                    throw new TclException(interp, "fatal : bad branch");
                }
                num = 0;
                if (value == OPT_PADX || value == OPT_PADY) {
                    TclObject[] size_args = TclList.getElements((Interp)interp, (TclObject)argv[i + 1]);
                    if (size_args.length < 1 || size_args.length > 2) {
                        throw new TclException(interp, "must be 1 or 2 elements");
                    }
                    String[] padError = new String[]{"", "2nd "};
                    for (int iArg = 0; iArg < size_args.length; ++iArg) {
                        try {
                            num = SwankUtil.getTkSize(interp, comp, size_args[iArg].toString());
                        }
                        catch (TclException tclE) {
                            throw new TclException(interp, "bad " + padError[iArg] + "pad value \"" + size_args[iArg].toString() + "\": must be positive screen distance");
                        }
                        if (num >= 0) continue;
                        throw new TclException(interp, "bad " + padError[iArg] + "pad value \"" + size_args[iArg].toString() + "\": must be positive screen distance");
                    }
                    continue;
                }
                String[] padError = new String[]{"ipadx", "ipady"};
                int xy = 0;
                if (value == OPT_IPADY) {
                    xy = 1;
                }
                try {
                    num = SwankUtil.getTkSize(interp, comp, argv[i + 1].toString());
                }
                catch (TclException tclE) {
                    throw new TclException(interp, "bad " + padError[xy] + " value \"" + argv[i + 1].toString() + "\": must be positive screen distance");
                }
                if (num >= 0) continue;
                throw new TclException(interp, "bad " + padError[xy] + " value \"" + argv[i + 1].toString() + "\": must be positive screen distance");
            }
            if (option == BOOLEAN_MAP) {
                boolean bool;
                String s = argv[i + 1].toString();
                if (s.length() <= 0) throw new TclException(interp, "expected boolean value but got \"" + argv[i].toString() + "\"");
                if ("yes".startsWith(s)) {
                    bool = true;
                } else if ("no".startsWith(s)) {
                    bool = false;
                } else if ("true".startsWith(s)) {
                    bool = true;
                } else if ("false".startsWith(s)) {
                    bool = false;
                } else if ("on".startsWith(s) && s.length() > 1) {
                    bool = true;
                } else if ("off".startsWith(s) && s.length() > 1) {
                    bool = false;
                } else if (s.equals(EXPAND_OPT_NO)) {
                    bool = false;
                } else {
                    if (!s.equals(EXPAND_OPT_YES)) throw new TclException(interp, "expected boolean value but got \"" + s + "\"");
                    bool = true;
                }
                value = value_table.get(argv[i].toString());
                if (value == null) {
                    String str = "null value object for int parser on option \"" + argv[i].toString() + "\" : \"" + argv[i + 1].toString() + "\"";
                    throw new TclException(interp, str);
                }
                if (value == OPT_EXPAND) continue;
                throw new TclException(interp, "fatal : bad branch");
            }
            if (option != value_table.get(argv[i + 1].toString())) {
                if (option == OPT_ANCHOR) {
                    throw new TclException(interp, "bad anchor \"" + argv[i + 1].toString() + "\": must be n, ne, e, se, s, sw, w, nw, or center");
                }
                if (option == OPT_FILL) {
                    throw new TclException(interp, "bad fill style \"" + argv[i + 1].toString() + "\": must be none, x, y, or both");
                }
                if (option != OPT_SIDE) throw new TclException(interp, "error : option \"" + argv[i].toString() + "\" can not take the value \"" + argv[i + 1].toString() + "\"");
                throw new TclException(interp, "bad side \"" + argv[i + 1].toString() + "\": must be top, bottom, left, or right");
            }
            value = value_object_table.get(argv[i + 1].toString());
            if (value == null) {
                String str = "null value object for option parser on option \"" + argv[i].toString() + "\" : \"" + argv[i + 1].toString() + "\"";
                throw new TclException(interp, str);
            }
            if (option == OPT_ANCHOR || option == OPT_FILL || option == OPT_SIDE) continue;
            throw new TclException(interp, "fatal : bad branch");
        }
    }

    public void removeLayoutComponent(Component comp) {
        if (this.ignore_next_remove) {
            this.ignore_next_remove = false;
            return;
        }
        this.component_table.remove(comp);
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension dim = this.minimumLayoutSize(target);
        Dimension cdim = target.getSize();
        if (cdim.width < dim.width) {
            cdim.width = dim.width;
        }
        if (cdim.height < dim.height) {
            cdim.height = dim.height;
        }
        return cdim;
    }

    public Dimension getTargetContainerSize(Container target) {
        JRootPane jroot;
        Insets insets = target.getInsets();
        Dimension cdim = target.getSize();
        Container target2 = target;
        if (target instanceof JComponent && (jroot = ((JComponent)target).getRootPane()) != null) {
            target2 = jroot.getParent();
        }
        return target2.getSize();
    }

    public Dimension minimumLayoutSize(Container target) {
        JRootPane jroot;
        Insets insets = target.getInsets();
        Dimension cdim = target.getSize();
        Container target2 = target;
        if (target instanceof JComponent && (jroot = ((JComponent)target).getRootPane()) != null) {
            target2 = jroot.getParent();
        }
        if (target2 instanceof SwkJFrame) {
            SwkJFrame swkJFrame = (SwkJFrame)target2;
            if (!((PackerLayout)target.getLayout()).propagate) {
                cdim.width -= insets.left + insets.right;
                cdim.height -= insets.top + insets.bottom;
                return cdim;
            }
        } else if (!((PackerLayout)target.getLayout()).propagate) {
            return cdim;
        }
        int dim_width = 0;
        int dim_height = 0;
        Dimension dmax = new Dimension(0, 0);
        dmax.width = 0;
        dmax.height = 0;
        Container c1 = Widgets.getContainer(target);
        int nmembers = target.getComponentCount();
        for (int i = 0; i < nmembers; ++i) {
            Component m = target.getComponent(i);
            if (m.getParent() != c1) continue;
            Dimension d = m.getMinimumSize();
            PackRecord pr = (PackRecord)this.component_table.get(m);
            if (pr == null) {
                throw new RuntimeException("null PackRecord");
            }
            d.width += pr.padx[0] + pr.padx[1] + (pr.ipadx[0] + pr.ipadx[1]) + dim_width;
            d.height += pr.pady[0] + pr.pady[1] + (pr.ipady[0] + pr.ipady[1]) + dim_height;
            if (pr.side == SIDE_OBJ_TOP || pr.side == SIDE_OBJ_BOTTOM) {
                if (d.width > dmax.width) {
                    dmax.width = d.width;
                }
                dim_height = d.height;
                continue;
            }
            if (d.height > dmax.height) {
                dmax.height = d.height;
            }
            dim_width = d.width;
        }
        if (dim_width > dmax.width) {
            dmax.width = dim_width;
        }
        if (dim_height > dmax.height) {
            dmax.height = dim_height;
        }
        dmax.width += insets.left + insets.right;
        dmax.height += insets.top + insets.bottom;
        return dmax;
    }

    public void layoutContainer(Container target) {
        Insets insets = target.getInsets();
        Dimension dim = target.getSize();
        int cavityX = 0;
        int cavityY = 0;
        int cavityWidth = dim.width - (insets.left + insets.right);
        int cavityHeight = dim.height - (insets.top + insets.bottom);
        int nMembers = target.getComponentCount();
        for (int i = 0; i < nMembers; ++i) {
            int y;
            int x;
            int frameY;
            int frameX;
            int frameHeight;
            int frameWidth;
            Component current = target.getComponent(i);
            PackRecord pr = (PackRecord)this.component_table.get(current);
            int padx = pr.padx[0] + pr.padx[1];
            int pady = pr.pady[0] + pr.pady[1];
            Object anchor = pr.anchor;
            boolean fillx = pr.fill == FILL_OBJ_X || pr.fill == FILL_OBJ_BOTH;
            boolean filly = pr.fill == FILL_OBJ_Y || pr.fill == FILL_OBJ_BOTH;
            current.doLayout();
            Dimension prefsize = current.getPreferredSize();
            if (pr.side == SIDE_OBJ_TOP || pr.side == SIDE_OBJ_BOTTOM) {
                frameWidth = cavityWidth;
                frameHeight = prefsize.height + pady + (pr.ipady[0] + pr.ipady[1]);
                if (pr.expand) {
                    frameHeight += this.YExpansion(target, i, cavityHeight);
                }
                if ((cavityHeight -= frameHeight) < 0) {
                    frameHeight += cavityHeight;
                    cavityHeight = 0;
                }
                frameX = cavityX;
                if (pr.side == SIDE_OBJ_TOP) {
                    frameY = cavityY;
                    cavityY += frameHeight;
                } else {
                    frameY = cavityY + cavityHeight;
                }
            } else {
                frameHeight = cavityHeight;
                frameWidth = prefsize.width + padx + (pr.ipadx[0] + pr.ipadx[1]);
                if (pr.expand) {
                    frameWidth += this.XExpansion(target, i, cavityWidth);
                }
                if ((cavityWidth -= frameWidth) < 0) {
                    frameWidth += cavityWidth;
                    cavityWidth = 0;
                }
                frameY = cavityY;
                if (pr.side == SIDE_OBJ_LEFT) {
                    frameX = cavityX;
                    cavityX += frameWidth;
                } else {
                    frameX = cavityX + cavityWidth;
                }
            }
            int width = prefsize.width + (pr.ipadx[0] + pr.ipadx[1]);
            if (fillx || width > frameWidth - padx) {
                width = frameWidth - padx;
            }
            int height = prefsize.height + (pr.ipady[0] + pr.ipady[1]);
            if (filly || height > frameHeight - pady) {
                height = frameHeight - pady;
            }
            padx /= 2;
            pady /= 2;
            if (anchor == ANCHOR_OBJ_N) {
                x = frameX + (frameWidth - width) / 2;
                y = frameY + pr.pady[0];
            } else if (anchor == ANCHOR_OBJ_NE) {
                x = frameX + frameWidth - width - pr.padx[1];
                y = frameY + pr.pady[0];
            } else if (anchor == ANCHOR_OBJ_E) {
                x = frameX + frameWidth - width - pr.padx[1];
                y = frameY + (frameHeight - height) / 2;
            } else if (anchor == ANCHOR_OBJ_SE) {
                x = frameX + frameWidth - width - pr.padx[1];
                y = frameY + frameHeight - height - pr.pady[1];
            } else if (anchor == ANCHOR_OBJ_S) {
                x = frameX + (frameWidth - width) / 2;
                y = frameY + frameHeight - height - pr.pady[1];
            } else if (anchor == ANCHOR_OBJ_SW) {
                x = frameX + pr.padx[0];
                y = frameY + frameHeight - height - pr.pady[1];
            } else if (anchor == ANCHOR_OBJ_W) {
                x = frameX + pr.padx[0];
                y = frameY + (frameHeight - height) / 2;
            } else if (anchor == ANCHOR_OBJ_NW) {
                x = frameX + pr.padx[0];
                y = frameY + pr.pady[0];
            } else if (anchor == ANCHOR_OBJ_C) {
                x = frameX + frameWidth / 2 - (width + pr.padx[0] + pr.padx[1]) / 2 + pr.padx[0];
                y = frameY + frameHeight / 2 - (height + pr.pady[0] + pr.pady[1]) / 2 + pr.pady[0];
            } else {
                throw new RuntimeException("no match for ANCHOR type");
            }
            current.setBounds(insets.left + x, y + insets.top, width, height);
        }
    }

    private int XExpansion(Container target, int iCurrent, int cavityWidth) {
        int curExpand;
        int minExpand = cavityWidth;
        int numExpand = 0;
        int nMembers = target.getComponentCount();
        for (int i = iCurrent; i < nMembers; ++i) {
            Component current = target.getComponent(i);
            PackRecord pr = (PackRecord)this.component_table.get(current);
            int childWidth = current.getPreferredSize().width + (pr.padx[0] + pr.padx[1]) + (pr.ipadx[0] + pr.ipadx[1]);
            if (pr.side == SIDE_OBJ_TOP || pr.side == SIDE_OBJ_BOTTOM) {
                curExpand = (cavityWidth - childWidth) / numExpand;
                if (curExpand >= minExpand) continue;
                minExpand = curExpand;
                continue;
            }
            cavityWidth -= childWidth;
            if (!pr.expand) continue;
            ++numExpand;
        }
        curExpand = cavityWidth / numExpand;
        if (curExpand < minExpand) {
            minExpand = curExpand;
        }
        if (minExpand < 0) {
            return 0;
        }
        return minExpand;
    }

    private int YExpansion(Container target, int iCurrent, int cavityHeight) {
        int curExpand;
        int minExpand = cavityHeight;
        int numExpand = 0;
        int nMembers = target.getComponentCount();
        for (int i = iCurrent; i < nMembers; ++i) {
            Component current = target.getComponent(i);
            PackRecord pr = (PackRecord)this.component_table.get(current);
            int childHeight = current.getPreferredSize().height + (pr.pady[0] + pr.pady[1]) + (pr.ipady[0] + pr.ipady[1]);
            if (pr.side == SIDE_OBJ_LEFT || pr.side == SIDE_OBJ_RIGHT) {
                curExpand = (cavityHeight - childHeight) / numExpand;
                if (curExpand >= minExpand) continue;
                minExpand = curExpand;
                continue;
            }
            cavityHeight -= childHeight;
            if (!pr.expand) continue;
            ++numExpand;
        }
        curExpand = cavityHeight / numExpand;
        if (curExpand < minExpand) {
            minExpand = curExpand;
        }
        if (minExpand < 0) {
            return 0;
        }
        return minExpand;
    }

    public String getComponentSettings(Component comp) {
        StringBuffer sb = new StringBuffer();
        PackRecord pr = (PackRecord)this.component_table.get(comp);
        if (pr == null) {
            return null;
        }
        sb.append(OPT_ANCHOR);
        sb.append(' ');
        Object anchor = pr.anchor;
        if (anchor == ANCHOR_OBJ_N) {
            sb.append(ANCHOR_OPT_N);
        } else if (anchor == ANCHOR_OBJ_NE) {
            sb.append(ANCHOR_OPT_NE);
        } else if (anchor == ANCHOR_OBJ_E) {
            sb.append(ANCHOR_OPT_E);
        } else if (anchor == ANCHOR_OBJ_SE) {
            sb.append(ANCHOR_OPT_SE);
        } else if (anchor == ANCHOR_OBJ_S) {
            sb.append(ANCHOR_OPT_S);
        } else if (anchor == ANCHOR_OBJ_SW) {
            sb.append(ANCHOR_OPT_SW);
        } else if (anchor == ANCHOR_OBJ_W) {
            sb.append(ANCHOR_OPT_W);
        } else if (anchor == ANCHOR_OBJ_NW) {
            sb.append(ANCHOR_OPT_NW);
        } else if (anchor == ANCHOR_OBJ_C) {
            sb.append(ANCHOR_OPT_C);
        } else {
            throw new RuntimeException("no match for ANCHOR type");
        }
        sb.append(' ');
        sb.append(OPT_EXPAND);
        sb.append(' ');
        if (pr.expand) {
            sb.append(EXPAND_OPT_YES);
        } else if (!pr.expand) {
            sb.append(EXPAND_OPT_NO);
        } else {
            throw new RuntimeException("no match for EXPAND type");
        }
        sb.append(' ');
        sb.append(OPT_FILL);
        sb.append(' ');
        if (pr.fill == FILL_OBJ_NONE) {
            sb.append(FILL_OPT_NONE);
        } else if (pr.fill == FILL_OBJ_X) {
            sb.append(FILL_OPT_X);
        } else if (pr.fill == FILL_OBJ_Y) {
            sb.append(FILL_OPT_Y);
        } else if (pr.fill == FILL_OBJ_BOTH) {
            sb.append(FILL_OPT_BOTH);
        } else {
            throw new RuntimeException("no match for FILL type");
        }
        sb.append(' ');
        sb.append(OPT_IPADX);
        sb.append(' ');
        if (pr.ipadx[0] == pr.ipadx[1]) {
            sb.append(pr.ipadx[0]);
        } else {
            sb.append("{" + pr.ipadx[0] + " " + pr.ipadx[1] + "}");
        }
        sb.append(' ');
        sb.append(OPT_IPADY);
        sb.append(' ');
        if (pr.ipady[0] == pr.ipady[1]) {
            sb.append(pr.ipady[0]);
        } else {
            sb.append("{" + pr.ipady[0] + " " + pr.ipady[1] + "}");
        }
        sb.append(' ');
        sb.append(OPT_PADX);
        sb.append(' ');
        if (pr.padx[0] == pr.padx[1]) {
            sb.append(pr.padx[0]);
        } else {
            sb.append("{" + pr.padx[0] + " " + pr.padx[1] + "}");
        }
        sb.append(' ');
        sb.append(OPT_PADY);
        sb.append(' ');
        if (pr.pady[0] == pr.pady[1]) {
            sb.append(pr.pady[0]);
        } else {
            sb.append("{" + pr.pady[0] + " " + pr.pady[1] + "}");
        }
        sb.append(' ');
        sb.append(OPT_SIDE);
        sb.append(' ');
        if (pr.side == SIDE_OBJ_TOP) {
            sb.append(SIDE_OPT_TOP);
        } else if (pr.side == SIDE_OBJ_BOTTOM) {
            sb.append(SIDE_OPT_BOTTOM);
        } else if (pr.side == SIDE_OBJ_LEFT) {
            sb.append(SIDE_OPT_LEFT);
        } else if (pr.side == SIDE_OBJ_RIGHT) {
            sb.append(SIDE_OPT_RIGHT);
        } else {
            throw new RuntimeException("no match for SIDE type");
        }
        return sb.toString();
    }

    public void setIgnoreNextRemove(boolean bool) {
        this.ignore_next_remove = bool;
    }

    public String toString() {
        return this.getClass().getName();
    }

    static /* synthetic */ Object access$000() {
        return DEFAULT_SIDE;
    }

    static /* synthetic */ Object access$100() {
        return DEFAULT_FILL;
    }

    static /* synthetic */ Object access$200() {
        return DEFAULT_ANCHOR;
    }

    static {
        ANCHOR_OBJ_N = new Object();
        ANCHOR_OBJ_NE = new Object();
        ANCHOR_OBJ_E = new Object();
        ANCHOR_OBJ_SE = new Object();
        ANCHOR_OBJ_S = new Object();
        ANCHOR_OBJ_SW = new Object();
        ANCHOR_OBJ_W = new Object();
        ANCHOR_OBJ_NW = new Object();
        ANCHOR_OBJ_C = new Object();
        FILL_OBJ_NONE = new Object();
        FILL_OBJ_X = new Object();
        FILL_OBJ_Y = new Object();
        FILL_OBJ_BOTH = new Object();
        SIDE_OBJ_TOP = new Object();
        SIDE_OBJ_BOTTOM = new Object();
        SIDE_OBJ_LEFT = new Object();
        SIDE_OBJ_RIGHT = new Object();
        DEFAULT_ANCHOR = ANCHOR_OBJ_C;
        DEFAULT_FILL = FILL_OBJ_NONE;
        DEFAULT_SIDE = SIDE_OBJ_TOP;
        INT_MAP = new Object();
        NFE = new NumberFormatException();
        BOOLEAN_MAP = new Object();
        SIZE_MAP = new Object();
        RetDimension = new Dimension(0, 0);
        option_table = new Hashtable(17);
        value_table = new Hashtable(17);
        value_object_table = new Hashtable(17);
        option_table.put(OPT_ANCHOR, OPT_ANCHOR);
        value_table.put(ANCHOR_OPT_N, OPT_ANCHOR);
        value_table.put(ANCHOR_OPT_NE, OPT_ANCHOR);
        value_table.put(ANCHOR_OPT_E, OPT_ANCHOR);
        value_table.put(ANCHOR_OPT_SE, OPT_ANCHOR);
        value_table.put(ANCHOR_OPT_S, OPT_ANCHOR);
        value_table.put(ANCHOR_OPT_SW, OPT_ANCHOR);
        value_table.put(ANCHOR_OPT_W, OPT_ANCHOR);
        value_table.put(ANCHOR_OPT_NW, OPT_ANCHOR);
        value_table.put(ANCHOR_OPT_C, OPT_ANCHOR);
        value_object_table.put(ANCHOR_OPT_N, ANCHOR_OBJ_N);
        value_object_table.put(ANCHOR_OPT_NE, ANCHOR_OBJ_NE);
        value_object_table.put(ANCHOR_OPT_E, ANCHOR_OBJ_E);
        value_object_table.put(ANCHOR_OPT_SE, ANCHOR_OBJ_SE);
        value_object_table.put(ANCHOR_OPT_S, ANCHOR_OBJ_S);
        value_object_table.put(ANCHOR_OPT_SW, ANCHOR_OBJ_SW);
        value_object_table.put(ANCHOR_OPT_W, ANCHOR_OBJ_W);
        value_object_table.put(ANCHOR_OPT_NW, ANCHOR_OBJ_NW);
        value_object_table.put(ANCHOR_OPT_C, ANCHOR_OBJ_C);
        option_table.put(OPT_EXPAND, BOOLEAN_MAP);
        value_table.put(OPT_EXPAND, OPT_EXPAND);
        option_table.put(OPT_FILL, OPT_FILL);
        value_table.put(FILL_OPT_NONE, OPT_FILL);
        value_table.put(FILL_OPT_X, OPT_FILL);
        value_table.put(FILL_OPT_Y, OPT_FILL);
        value_table.put(FILL_OPT_BOTH, OPT_FILL);
        value_object_table.put(FILL_OPT_NONE, FILL_OBJ_NONE);
        value_object_table.put(FILL_OPT_X, FILL_OBJ_X);
        value_object_table.put(FILL_OPT_Y, FILL_OBJ_Y);
        value_object_table.put(FILL_OPT_BOTH, FILL_OBJ_BOTH);
        option_table.put(OPT_IPADX, SIZE_MAP);
        option_table.put(OPT_IPADY, SIZE_MAP);
        value_table.put(OPT_IPADX, OPT_IPADX);
        value_table.put(OPT_IPADY, OPT_IPADY);
        option_table.put(OPT_PADX, SIZE_MAP);
        option_table.put(OPT_PADY, SIZE_MAP);
        value_table.put(OPT_PADX, OPT_PADX);
        value_table.put(OPT_PADY, OPT_PADY);
        option_table.put(OPT_SIDE, OPT_SIDE);
        value_table.put(SIDE_OPT_TOP, OPT_SIDE);
        value_table.put(SIDE_OPT_BOTTOM, OPT_SIDE);
        value_table.put(SIDE_OPT_LEFT, OPT_SIDE);
        value_table.put(SIDE_OPT_RIGHT, OPT_SIDE);
        value_object_table.put(SIDE_OPT_TOP, SIDE_OBJ_TOP);
        value_object_table.put(SIDE_OPT_BOTTOM, SIDE_OBJ_BOTTOM);
        value_object_table.put(SIDE_OPT_LEFT, SIDE_OBJ_LEFT);
        value_object_table.put(SIDE_OPT_RIGHT, SIDE_OBJ_RIGHT);
    }

    class PackRecord {
        Component prev = null;
        Component next = null;
        public int[] padx = new int[]{0, 0};
        public int[] pady = new int[]{0, 0};
        public int[] ipadx = new int[]{0, 0};
        public int[] ipady = new int[]{0, 0};
        public Object side = PackerLayout.access$000();
        public boolean expand = false;
        public Object fill = PackerLayout.access$100();
        public Object anchor = PackerLayout.access$200();

        PackRecord() {
        }
    }
}

