/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.BindEvent;
import com.onemoonscientific.swank.FocusCmd;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.Result;
import com.onemoonscientific.swank.Setter;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkBinding;
import com.onemoonscientific.swank.SwkBorder;
import com.onemoonscientific.swank.SwkChangeListener;
import com.onemoonscientific.swank.SwkComponentListener;
import com.onemoonscientific.swank.SwkFocusListener;
import com.onemoonscientific.swank.SwkIndex;
import com.onemoonscientific.swank.SwkJListWidgetCmd;
import com.onemoonscientific.swank.SwkKeyCommandListener;
import com.onemoonscientific.swank.SwkKeyListener;
import com.onemoonscientific.swank.SwkListListener;
import com.onemoonscientific.swank.SwkListSelectionListener;
import com.onemoonscientific.swank.SwkMouseListener;
import com.onemoonscientific.swank.SwkMouseMotionListener;
import com.onemoonscientific.swank.SwkWidget;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwkJList
extends JList
implements SwkWidget,
Printable,
ChangeListener,
SwkListListener {
    static Hashtable resourceDB = null;
    String name = null;
    String className = null;
    LinkedList children = null;
    ArrayList<SwkBinding> virtualBindings = null;
    int active = 0;
    boolean created = false;
    TclObject tclObject = null;
    final Interp interp;
    Insets emptyBorderInsets = new Insets(0, 0, 0, 0);
    Vector tagList = new Vector();
    Dimension minimumSize = null;
    int swkheight;
    String jhelptarget = "";
    int borderWidth = 0;
    boolean exportSelection;
    Color highlightBackground = Color.white;
    Color highlightColor = Color.red;
    int highlightThickness;
    int padx;
    int pady;
    String relief = "sunken";
    int selectBorderWidth;
    boolean setGrid;
    String takeFocus = null;
    String xScrollCommand = null;
    String yScrollCommand = null;
    DefaultListModel model = null;
    DefaultListSelectionModel selectionModel = null;
    JViewport jview = null;
    JScrollPane jscroll = null;
    JComponent packComponent = null;
    private static final String longItem = "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm";
    SwkListSelectionListener selectionListener = null;
    String listVar;
    int swkwidth;
    SwkMouseListener mouseListener = null;
    SwkKeyListener keyListener = null;
    SwkKeyCommandListener keyCommandListener = null;
    SwkFocusListener focusListener = null;
    SwkComponentListener componentListener = null;
    SwkChangeListener changeListener = null;
    SwkMouseMotionListener mouseMotionListener = null;
    int mouseX = 0;
    int mouseY = 0;
    static String[] validCmds = new String[]{"-autoscrolls", "-background", "-bd", "-bg", "-border", "-borderwidth", "-class", "-cursor", "-enabled", "-exportselection", "-fg", "-fixedcellheight", "-fixedcellwidth", "-focusable", "-focuscycleroot", "-focustraversalkeysenabled", "-focustraversalpolicyprovider", "-font", "-foreground", "-height", "-highlightbackground", "-highlightcolor", "-highlightthickness", "-jhelptarget", "-layoutorientation", "-listvar", "-opaque", "-padx", "-pady", "-relief", "-requestfocusenabled", "-selectbackground", "-selectborderwidth", "-selectedindex", "-selectforeground", "-selectionbackground", "-selectionforeground", "-selectionmode", "-selectmode", "-setgrid", "-takefocus", "-tooltiptext", "-valueisadjusting", "-verifyinputwhenfocustarget", "-visible", "-visiblerowcount", "-width", "-xscrollcommand", "-yscrollcommand"};
    private static final int OPT_AUTOSCROLLS = 0;
    private static final int OPT_BACKGROUND = 1;
    private static final int OPT_BD = 2;
    private static final int OPT_BG = 3;
    private static final int OPT_BORDER = 4;
    private static final int OPT_BORDERWIDTH = 5;
    private static final int OPT_CLASS = 6;
    private static final int OPT_CURSOR = 7;
    private static final int OPT_ENABLED = 8;
    private static final int OPT_EXPORTSELECTION = 9;
    private static final int OPT_FG = 10;
    private static final int OPT_FIXEDCELLHEIGHT = 11;
    private static final int OPT_FIXEDCELLWIDTH = 12;
    private static final int OPT_FOCUSABLE = 13;
    private static final int OPT_FOCUSCYCLEROOT = 14;
    private static final int OPT_FOCUSTRAVERSALKEYSENABLED = 15;
    private static final int OPT_FOCUSTRAVERSALPOLICYPROVIDER = 16;
    private static final int OPT_FONT = 17;
    private static final int OPT_FOREGROUND = 18;
    private static final int OPT_HEIGHT = 19;
    private static final int OPT_HIGHLIGHTBACKGROUND = 20;
    private static final int OPT_HIGHLIGHTCOLOR = 21;
    private static final int OPT_HIGHLIGHTTHICKNESS = 22;
    private static final int OPT_JHELPTARGET = 23;
    private static final int OPT_LAYOUTORIENTATION = 24;
    private static final int OPT_LISTVAR = 25;
    private static final int OPT_OPAQUE = 26;
    private static final int OPT_PADX = 27;
    private static final int OPT_PADY = 28;
    private static final int OPT_RELIEF = 29;
    private static final int OPT_REQUESTFOCUSENABLED = 30;
    private static final int OPT_SELECTBACKGROUND = 31;
    private static final int OPT_SELECTBORDERWIDTH = 32;
    private static final int OPT_SELECTEDINDEX = 33;
    private static final int OPT_SELECTFOREGROUND = 34;
    private static final int OPT_SELECTIONBACKGROUND = 35;
    private static final int OPT_SELECTIONFOREGROUND = 36;
    private static final int OPT_SELECTIONMODE = 37;
    private static final int OPT_SELECTMODE = 38;
    private static final int OPT_SETGRID = 39;
    private static final int OPT_TAKEFOCUS = 40;
    private static final int OPT_TOOLTIPTEXT = 41;
    private static final int OPT_VALUEISADJUSTING = 42;
    private static final int OPT_VERIFYINPUTWHENFOCUSTARGET = 43;
    private static final int OPT_VISIBLE = 44;
    private static final int OPT_VISIBLEROWCOUNT = 45;
    private static final int OPT_WIDTH = 46;
    private static final int OPT_XSCROLLCOMMAND = 47;
    private static final int OPT_YSCROLLCOMMAND = 48;
    static TreeMap validCmdsTM = new TreeMap();

    public SwkJList(Interp interp, String name, String className) {
        this.name = name.intern();
        this.interp = interp;
        if (resourceDB == null) {
            resourceDB = new Hashtable();
            SwkJList.initResources();
        }
        if (!className.equals("Listbox") && className.equals("Slistbox")) {
            this.jscroll = new JScrollPane(this);
            this.jview = this.jscroll.getViewport();
            this.packComponent = this.jscroll;
        }
        this.model = new DefaultListModel();
        this.selectionModel = new DefaultListSelectionModel();
        this.setModel(this.model);
        this.selectionModel.setSelectionMode(2);
        this.setSelectionModel(this.selectionModel);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent fEvent) {
                FocusCmd.setFocusWindow(SwkJList.this.getName());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mEvent) {
                mEvent.getComponent().requestFocus();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mEvent) {
                SwkJList.this.mouseX = mEvent.getX();
                SwkJList.this.mouseY = mEvent.getY();
            }

            public void mouseDragged(MouseEvent mEvent) {
                SwkJList.this.mouseX = mEvent.getX();
                SwkJList.this.mouseY = mEvent.getY();
            }
        });
        this.tagList.add(name);
        this.tagList.add(className);
        this.tagList.add("swank");
        this.tagList.add("all");
    }

    public static void getWidgetOptions(Interp interp) throws TclException {
        TclObject result = TclList.newInstance();
        int n = validCmds.length;
        for (int i = 0; i < n; ++i) {
            TclList.append((Interp)interp, (TclObject)result, (TclObject)TclString.newInstance((String)validCmds[i]));
        }
        interp.setResult(result);
    }

    public static void getWidgetCmds(Interp interp) throws TclException {
        TclObject result = TclList.newInstance();
        String[] validCmds = SwkJListWidgetCmd.getValidCmds();
        int n = validCmds.length;
        for (int i = 0; i < n; ++i) {
            TclList.append((Interp)interp, (TclObject)result, (TclObject)TclString.newInstance((String)validCmds[i]));
        }
        interp.setResult(result);
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int result = 1;
        if (pageIndex == 0) {
            Graphics2D g2 = (Graphics2D)g;
            double pX = pageFormat.getImageableX();
            double pY = pageFormat.getImageableY();
            double pW = pageFormat.getImageableWidth();
            double pH = pageFormat.getImageableHeight();
            Dimension dimSize = this.getSize();
            double sx = 1.0;
            double sy = 1.0;
            if ((double)dimSize.width > pW) {
                sx = pW / (double)dimSize.width;
                sy = pW / (double)dimSize.width;
            }
            if ((double)dimSize.height * sx > pH) {
                sy = sx * pH / ((double)dimSize.height * sx);
                sx = sx * pH / ((double)dimSize.height * sx);
            }
            g2.translate(pX, pY);
            g2.scale(sx, sy);
            boolean wasBuffered = SwankUtil.disableDoubleBuffering(this);
            this.paint(g2);
            SwankUtil.restoreDoubleBuffering(this, wasBuffered);
            result = 0;
        }
        return result;
    }

    @Override
    public Vector getTagList() {
        return this.tagList;
    }

    @Override
    public void setTagList(Interp interp, TclObject tagListObj) throws TclException {
        TclObject[] tagObjs = TclList.getElements((Interp)interp, (TclObject)tagListObj);
        this.tagList.setSize(0);
        for (int i = 0; i < tagObjs.length; ++i) {
            this.tagList.add(tagObjs[i].toString());
        }
    }

    @Override
    public void setVirtualBindings(ArrayList<SwkBinding> bindings) {
        this.virtualBindings = bindings;
    }

    @Override
    public ArrayList<SwkBinding> getVirtualBindings() {
        return this.virtualBindings;
    }

    @Override
    public Insets getEmptyBorderInsets() {
        return this.emptyBorderInsets;
    }

    @Override
    public LinkedList getChildrenList() {
        return this.children;
    }

    @Override
    public void initChildrenList() {
        this.children = new LinkedList();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setJHelpTarget(String jhelptarget) {
        this.jhelptarget = jhelptarget;
        SwankUtil.setJHelpTarget(this, jhelptarget);
    }

    public String getJHelpTarget() {
        return this.jhelptarget;
    }

    public void setBorderWidth(double borderWidth) {
        this.borderWidth = (int)borderWidth;
        if (!(this.getBorder() instanceof SwkBorder)) {
            this.setBorder(new SwkBorder());
        }
    }

    @Override
    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setExportSelection(boolean exportSelection) {
        this.exportSelection = exportSelection;
    }

    public String getExportSelection() {
        if (this.exportSelection) {
            return "1";
        }
        return "0";
    }

    public void setHighlightBackground(Color highlightBackground) {
        this.highlightBackground = highlightBackground;
    }

    public Color getHighlightBackground() {
        return this.highlightBackground;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightThickness(int highlightThickness) {
        this.highlightThickness = highlightThickness;
    }

    public int getHighlightThickness() {
        return this.highlightThickness;
    }

    public void setPadx(int padx) {
        this.emptyBorderInsets.left = this.padx = padx;
        this.emptyBorderInsets.right = this.padx;
        this.minimumSize = null;
    }

    public int getPadx() {
        return this.padx;
    }

    public void setPady(int pady) {
        this.emptyBorderInsets.top = this.pady = pady;
        this.emptyBorderInsets.bottom = this.pady;
        this.minimumSize = null;
    }

    public int getPady() {
        return this.pady;
    }

    public void setRelief(String relief) {
        if (!(this.getBorder() instanceof SwkBorder)) {
            this.setBorder(new SwkBorder());
        }
        this.relief = relief.intern();
    }

    @Override
    public String getRelief() {
        if (this.relief == null) {
            this.relief = "";
        }
        return this.relief;
    }

    public void setSelectBorderWidth(int selectBorderWidth) {
        this.selectBorderWidth = selectBorderWidth;
    }

    public int getSelectBorderWidth() {
        return this.selectBorderWidth;
    }

    public void setSetGrid(boolean setGrid) {
        this.setGrid = setGrid;
    }

    public String getSetGrid() {
        if (this.setGrid) {
            return "1";
        }
        return "0";
    }

    public void setTakeFocus(String takeFocus) {
        this.takeFocus = takeFocus.intern();
    }

    public String getTakeFocus() {
        return this.takeFocus;
    }

    public void setXScrollCommand(String xScrollCommand) {
        this.xScrollCommand = xScrollCommand.intern();
    }

    public String getXScrollCommand() {
        return this.xScrollCommand;
    }

    public void setYScrollCommand(String yScrollCommand) {
        this.yScrollCommand = yScrollCommand.intern();
    }

    public String getYScrollCommand() {
        return this.yScrollCommand;
    }

    public void setListVar(String listVar) {
        this.listVar = listVar.intern();
    }

    public String getListVar() {
        return this.listVar;
    }

    @Override
    public SwkListSelectionListener getListSelectionListener() {
        return this.selectionListener;
    }

    @Override
    public void setListSelectionListener(SwkListSelectionListener selectionListener) {
        this.selectionListener = selectionListener;
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        BindEvent bEvent;
        if (this.jview == null) {
            this.jview = (JViewport)this.getParent();
        }
        if (this.jview == null) {
            return;
        }
        Point pt = this.jview.getViewPosition();
        Dimension viewSize = this.jview.getViewSize();
        Dimension listSize = this.getSize();
        Dimension extentSize = this.jview.getExtentSize();
        double fy1 = 1.0 * (double)pt.y / (double)listSize.height;
        double fy2 = 1.0 * (double)(pt.y + extentSize.height) / (double)listSize.height;
        double fx1 = 1.0 * (double)pt.x / (double)listSize.width;
        double fx2 = 1.0 * (double)(pt.x + extentSize.width) / (double)listSize.width;
        if (this.yScrollCommand != null && this.yScrollCommand.length() > 0) {
            bEvent = new BindEvent(this.interp, this.yScrollCommand + " " + fy1 + " " + fy2);
            this.interp.getNotifier().queueEvent((TclEvent)bEvent, 0);
        }
        if (this.xScrollCommand != null && this.xScrollCommand.length() > 0) {
            bEvent = new BindEvent(this.interp, this.xScrollCommand + " " + fx1 + " " + fx2);
            this.interp.getNotifier().queueEvent((TclEvent)bEvent, 0);
        }
    }

    public void getIndex(String sIndex, int endVal, Result result) {
        int index = 0;
        boolean isInt = false;
        if (SwankUtil.looksLikeInt(sIndex)) {
            try {
                index = Integer.parseInt(sIndex);
                isInt = true;
            }
            catch (NumberFormatException nfE) {
                isInt = false;
            }
        }
        if (!isInt) {
            boolean validIndex = false;
            if (sIndex.equals("end")) {
                index = this.model.getSize() + endVal;
                validIndex = true;
            } else if (sIndex.equals("active")) {
                index = this.active;
                if (index >= this.model.getSize()) {
                    index = this.model.getSize() - 1;
                }
                validIndex = true;
            } else if (sIndex.equals("anchor")) {
                int[] selected = this.getSelectedIndices();
                if (selected.length > 0) {
                    index = selected[0];
                    validIndex = true;
                } else {
                    index = 0;
                    validIndex = true;
                }
            } else if (sIndex.startsWith("@")) {
                int comma;
                int visIndex = this.getFirstVisibleIndex();
                if (sIndex.length() > 3 && (comma = sIndex.indexOf(",")) > 1 && sIndex.length() - comma > 1) {
                    String xS = sIndex.substring(1, comma);
                    String yS = sIndex.substring(comma + 1);
                    Point p = new Point();
                    Point p1 = new Point();
                    try {
                        p.x = Integer.valueOf(xS);
                        p.y = Integer.valueOf(yS);
                        index = this.locationToIndex(p) + visIndex;
                        validIndex = true;
                    }
                    catch (Exception e) {
                        System.out.println(e.toString());
                    }
                }
            }
            if (!validIndex) {
                result.setError("bad listbox index \"" + sIndex + "\": must be active, anchor, end, @x,y, or a number");
            }
        }
        result.i = index;
    }

    public void setSwkWidth(int width) {
        this.swkwidth = width;
        String prefItem = longItem.substring(0, width);
        this.setPrototypeCellValue(prefItem);
        Window window = (Window)this.getTopLevelAncestor();
        if (window != null) {
            window.pack();
        }
    }

    public int getSwkWidth() {
        return this.swkwidth;
    }

    public void setSwkHeight(int height) {
        this.swkheight = height;
        this.setVisibleRowCount(height);
        Window window = (Window)this.getTopLevelAncestor();
        if (window != null) {
            window.pack();
        }
    }

    public int getSwkHeight() {
        return this.getVisibleRowCount();
    }

    @Override
    public boolean isCreated() {
        return this.created;
    }

    @Override
    public void setCreated(boolean state) {
        this.created = state;
    }

    @Override
    public int getMouseX() {
        return this.mouseX;
    }

    @Override
    public int getMouseY() {
        return this.mouseY;
    }

    @Override
    public SwkMouseListener getMouseListener() {
        return this.mouseListener;
    }

    @Override
    public void setMouseListener(SwkMouseListener mouseListener) {
        this.mouseListener = mouseListener;
    }

    @Override
    public SwkFocusListener getFocusListener() {
        return this.focusListener;
    }

    @Override
    public void setFocusListener(SwkFocusListener focusListener) {
        this.focusListener = focusListener;
    }

    @Override
    public SwkComponentListener getComponentListener() {
        return this.componentListener;
    }

    @Override
    public void setComponentListener(SwkComponentListener componentListener) {
        this.componentListener = componentListener;
    }

    @Override
    public SwkChangeListener getChangeListener() {
        return this.changeListener;
    }

    @Override
    public void setChangeListener(SwkChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public SwkKeyListener getKeyListener() {
        return this.keyListener;
    }

    @Override
    public void setKeyListener(SwkKeyListener keyListener) {
        this.keyListener = keyListener;
    }

    public SwkKeyCommandListener getKeyCommandListener() {
        return this.keyCommandListener;
    }

    public void setKeyCommandListener(SwkKeyCommandListener keyCommandListener) {
        this.keyCommandListener = keyCommandListener;
    }

    @Override
    public SwkMouseMotionListener getMouseMotionListener() {
        return this.mouseMotionListener;
    }

    @Override
    public void setMouseListener(SwkMouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = mouseMotionListener;
    }

    public void setClassName(String className) {
        this.className = className.intern();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void close() throws TclException {
    }

    void jgetAll(Interp interp) throws TclException {
        if (EventQueue.isDispatchThread()) {
            System.out.println("never  run on event thread");
        }
        JGetAll jgetAll = new JGetAll(this);
        try {
            SwingUtilities.invokeAndWait(jgetAll);
        }
        catch (InterruptedException iE) {
            throw new TclException(interp, iE.toString());
        }
        catch (Exception e) {
            throw new TclException(interp, e.toString());
        }
        this.getAllConfigurations(interp, jgetAll.roValues);
    }

    ArrayList getAllConfigurations() {
        int nCmds = validCmds.length;
        ArrayList<Object> results = new ArrayList<Object>();
        Enumeration e = resourceDB.keys();
        while (e.hasMoreElements()) {
            String keyName = (String)e.nextElement();
            ResourceObject ro = (ResourceObject)resourceDB.get(keyName);
            if (ro == null) continue;
            String value = this.jget(ro.optNum);
            results.add(keyName);
            results.add(ro);
            results.add(value);
        }
        return results;
    }

    void getAllConfigurations(Interp interp, ArrayList roValues) throws TclException {
        TclObject list2 = TclList.newInstance();
        int n = roValues.size();
        for (int i = 0; i < n; i += 3) {
            TclObject list1 = TclList.newInstance();
            String keyName = (String)roValues.get(i);
            ResourceObject ro = (ResourceObject)roValues.get(i + 1);
            String value = (String)roValues.get(i + 2);
            if (ro == null) continue;
            TclObject tObj = TclString.newInstance((String)keyName);
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)tObj);
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.resource));
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.className));
            if (ro.defaultVal == null) {
                TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)""));
            } else {
                TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.defaultVal));
            }
            if (value == null) {
                value = "";
            }
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)value));
            TclList.append((Interp)interp, (TclObject)list2, (TclObject)list1);
        }
        interp.setResult(list2);
    }

    @Override
    public void setValues(Setter setter, int opt) {
        switch (opt) {
            case 0: {
                this.setAutoscrolls(setter.bValue);
                break;
            }
            case 1: {
                this.setBackground((Color)setter.oValue);
                break;
            }
            case 2: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 3: {
                this.setBackground((Color)setter.oValue);
                break;
            }
            case 4: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 5: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 6: {
                this.setClassName(setter.sValue);
                break;
            }
            case 7: {
                this.setCursor((Cursor)setter.oValue);
                break;
            }
            case 8: {
                this.setEnabled(setter.bValue);
                break;
            }
            case 9: {
                this.setExportSelection(setter.bValue);
                break;
            }
            case 10: {
                this.setForeground((Color)setter.oValue);
                break;
            }
            case 11: {
                this.setFixedCellHeight(setter.iValue);
                break;
            }
            case 12: {
                this.setFixedCellWidth(setter.iValue);
                break;
            }
            case 13: {
                this.setFocusable(setter.bValue);
                break;
            }
            case 14: {
                this.setFocusCycleRoot(setter.bValue);
                break;
            }
            case 15: {
                this.setFocusTraversalKeysEnabled(setter.bValue);
                break;
            }
            case 16: {
                this.setFocusTraversalPolicyProvider(setter.bValue);
                break;
            }
            case 17: {
                this.setFont((Font)setter.oValue);
                break;
            }
            case 18: {
                this.setForeground((Color)setter.oValue);
                break;
            }
            case 19: {
                this.setSwkHeight(setter.iValue);
                break;
            }
            case 20: {
                this.setHighlightBackground((Color)setter.oValue);
                break;
            }
            case 21: {
                this.setHighlightColor((Color)setter.oValue);
                break;
            }
            case 22: {
                this.setHighlightThickness(setter.iValue);
                break;
            }
            case 23: {
                this.setJHelpTarget(setter.sValue);
                break;
            }
            case 24: {
                this.setLayoutOrientation(setter.iValue);
                break;
            }
            case 25: {
                this.setListVar(setter.sValue);
                break;
            }
            case 26: {
                this.setOpaque(setter.bValue);
                break;
            }
            case 27: {
                this.setPadx(setter.iValue);
                break;
            }
            case 28: {
                this.setPady(setter.iValue);
                break;
            }
            case 29: {
                this.setRelief(setter.sValue);
                break;
            }
            case 30: {
                this.setRequestFocusEnabled(setter.bValue);
                break;
            }
            case 31: {
                this.setSelectionBackground((Color)setter.oValue);
                break;
            }
            case 32: {
                this.setSelectBorderWidth(setter.iValue);
                break;
            }
            case 33: {
                this.setSelectedIndex(setter.iValue);
                break;
            }
            case 34: {
                this.setSelectionForeground((Color)setter.oValue);
                break;
            }
            case 35: {
                this.setSelectionBackground((Color)setter.oValue);
                break;
            }
            case 36: {
                this.setSelectionForeground((Color)setter.oValue);
                break;
            }
            case 37: {
                this.setSelectionMode(setter.iValue);
                break;
            }
            case 38: {
                this.setSelectionMode(setter.iValue);
                break;
            }
            case 39: {
                this.setSetGrid(setter.bValue);
                break;
            }
            case 40: {
                this.setTakeFocus(setter.sValue);
                break;
            }
            case 41: {
                this.setToolTipText(setter.sValue);
                break;
            }
            case 42: {
                this.setValueIsAdjusting(setter.bValue);
                break;
            }
            case 43: {
                this.setVerifyInputWhenFocusTarget(setter.bValue);
                break;
            }
            case 44: {
                this.setVisible(setter.bValue);
                break;
            }
            case 45: {
                this.setVisibleRowCount(setter.iValue);
                break;
            }
            case 46: {
                this.setSwkWidth(setter.iValue);
                break;
            }
            case 47: {
                this.setXScrollCommand(setter.sValue);
                break;
            }
            case 48: {
                this.setYScrollCommand(setter.sValue);
            }
        }
    }

    @Override
    public void configure(Interp interp, TclObject[] argv, int start) throws TclException {
        if (EventQueue.isDispatchThread()) {
            throw new RuntimeException("Configure on eventQueue");
        }
        if (argv.length <= start) {
            return;
        }
        ResourceObject ro = null;
        block51: for (int i = start; i < argv.length; i += 2) {
            if (i + 1 >= argv.length) {
                throw new TclException(interp, "value for \"" + argv[i].toString() + "\" missing");
            }
            ro = (ResourceObject)resourceDB.get(argv[i].toString());
            if (ro == null) {
                throw new TclException(interp, "unknown option \"" + argv[i].toString() + "\"");
            }
            int opt = SwkIndex.get(interp, argv[i], validCmdsTM, "option", 0);
            switch (opt) {
                case 0: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 1: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 2: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 3: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 4: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 5: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 6: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 7: {
                    Cursor value = SwankUtil.getCursor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 8: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 9: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 10: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 11: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 12: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 13: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 14: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 15: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 16: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 17: {
                    Font value = SwankUtil.getFont(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 18: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 19: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 20: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 21: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 22: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 23: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 24: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 25: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 26: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 27: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 28: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 29: {
                    String value = SwankUtil.getTkRelief(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 30: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 31: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 32: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 33: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 34: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 35: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 36: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 37: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 38: {
                    int value = SwankUtil.getTkSelectMode(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 39: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 40: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 41: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 42: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 43: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 44: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 45: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 46: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 47: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
                case 48: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block51;
                }
            }
        }
        SwankUtil.doWait();
        this.repaint();
    }

    String jget(int opt) {
        switch (opt) {
            case 0: {
                return String.valueOf(this.getAutoscrolls());
            }
            case 1: {
                return SwankUtil.parseColor(this.getBackground());
            }
            case 2: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 3: {
                return SwankUtil.parseColor(this.getBackground());
            }
            case 4: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 5: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 6: {
                return this.getClassName();
            }
            case 7: {
                return SwankUtil.parseCursor(this.getCursor());
            }
            case 8: {
                return this.isEnabled() ? "1" : "0";
            }
            case 9: {
                return String.valueOf(this.getExportSelection());
            }
            case 10: {
                return SwankUtil.parseColor(this.getForeground());
            }
            case 11: {
                return Integer.toString(this.getFixedCellHeight());
            }
            case 12: {
                return Integer.toString(this.getFixedCellWidth());
            }
            case 13: {
                return this.isFocusable() ? "1" : "0";
            }
            case 14: {
                return this.isFocusCycleRoot() ? "1" : "0";
            }
            case 15: {
                return String.valueOf(this.getFocusTraversalKeysEnabled());
            }
            case 16: {
                return this.isFocusTraversalPolicyProvider() ? "1" : "0";
            }
            case 17: {
                return SwankUtil.parseFont(this.getFont());
            }
            case 18: {
                return SwankUtil.parseColor(this.getForeground());
            }
            case 19: {
                return Integer.toString(this.getSwkHeight());
            }
            case 20: {
                return SwankUtil.parseColor(this.getHighlightBackground());
            }
            case 21: {
                return SwankUtil.parseColor(this.getHighlightColor());
            }
            case 22: {
                return SwankUtil.parseTkSize(this.getHighlightThickness());
            }
            case 23: {
                return this.getJHelpTarget();
            }
            case 24: {
                return Integer.toString(this.getLayoutOrientation());
            }
            case 25: {
                return this.getListVar();
            }
            case 26: {
                return this.isOpaque() ? "1" : "0";
            }
            case 27: {
                return SwankUtil.parseTkSize(this.getPadx());
            }
            case 28: {
                return SwankUtil.parseTkSize(this.getPady());
            }
            case 29: {
                return SwankUtil.parseTkRelief(this.getRelief());
            }
            case 30: {
                return this.isRequestFocusEnabled() ? "1" : "0";
            }
            case 31: {
                return SwankUtil.parseColor(this.getSelectionBackground());
            }
            case 32: {
                return SwankUtil.parseTkSize(this.getSelectBorderWidth());
            }
            case 33: {
                return Integer.toString(this.getSelectedIndex());
            }
            case 34: {
                return SwankUtil.parseColor(this.getSelectionForeground());
            }
            case 35: {
                return SwankUtil.parseColor(this.getSelectionBackground());
            }
            case 36: {
                return SwankUtil.parseColor(this.getSelectionForeground());
            }
            case 37: {
                return Integer.toString(this.getSelectionMode());
            }
            case 38: {
                return SwankUtil.parseTkSelectMode(this.getSelectionMode());
            }
            case 39: {
                return String.valueOf(this.getSetGrid());
            }
            case 40: {
                return this.getTakeFocus();
            }
            case 41: {
                return this.getToolTipText();
            }
            case 42: {
                return String.valueOf(this.getValueIsAdjusting());
            }
            case 43: {
                return String.valueOf(this.getVerifyInputWhenFocusTarget());
            }
            case 44: {
                return this.isVisible() ? "1" : "0";
            }
            case 45: {
                return Integer.toString(this.getVisibleRowCount());
            }
            case 46: {
                return Integer.toString(this.getSwkWidth());
            }
            case 47: {
                return this.getXScrollCommand();
            }
            case 48: {
                return this.getYScrollCommand();
            }
        }
        return "";
    }

    String jget(Interp interp, TclObject arg) throws TclException {
        int opt = 0;
        try {
            opt = SwkIndex.get(interp, arg, validCmdsTM, "option", 0);
        }
        catch (TclException tclE) {
            throw new TclException(interp, "unknown option \"" + arg + "\"");
        }
        String result = "";
        if (!EventQueue.isDispatchThread()) {
            JGet jget = new JGet(this, opt);
            try {
                SwingUtilities.invokeAndWait(jget);
            }
            catch (InterruptedException iE) {
                throw new TclException(interp, iE.toString());
            }
            catch (Exception e) {
                throw new TclException(interp, e.toString());
            }
            result = jget.result;
        } else {
            result = this.jget(opt);
        }
        return result;
    }

    void setResourceDefaults() throws TclException {
        if (!EventQueue.isDispatchThread()) {
            ResourceDefaultsSetter resourceDefaultsSetter = new ResourceDefaultsSetter(this.interp, this);
            try {
                SwingUtilities.invokeAndWait(resourceDefaultsSetter);
            }
            catch (InterruptedException iE) {
                throw new TclException(this.interp, iE.toString());
            }
            catch (Exception e) {
                throw new TclException(this.interp, e.toString());
            }
        } else {
            this.setResourceDefaultsET();
        }
    }

    void setResourceDefaultsET() {
        Enumeration e = resourceDB.keys();
        while (e.hasMoreElements()) {
            ResourceObject ro;
            String keyName = (String)e.nextElement();
            if (keyName == null || (ro = (ResourceObject)resourceDB.get(keyName)) == null) continue;
            try {
                ro.defaultVal = this.jget(ro.optNum);
            }
            catch (IllegalComponentStateException icsE) {}
        }
    }

    private static void initResources() {
        ResourceObject resourceObject = null;
        resourceObject = new ResourceObject("autoscrolls", "Autoscrolls", 0);
        resourceDB.put("-autoscrolls", resourceObject);
        resourceObject = new ResourceObject("background", "Background", 1);
        resourceDB.put("-background", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 2);
        resourceDB.put("-bd", resourceObject);
        resourceObject = new ResourceObject("background", "Background", 3);
        resourceDB.put("-bg", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 4);
        resourceDB.put("-border", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 5);
        resourceDB.put("-borderwidth", resourceObject);
        resourceObject = new ResourceObject("className", "ClassName", 6);
        resourceDB.put("-class", resourceObject);
        resourceObject = new ResourceObject("cursor", "Cursor", 7);
        resourceDB.put("-cursor", resourceObject);
        resourceObject = new ResourceObject("enabled", "Enabled", 8);
        resourceDB.put("-enabled", resourceObject);
        resourceObject = new ResourceObject("exportSelection", "ExportSelection", 9);
        resourceDB.put("-exportselection", resourceObject);
        resourceObject = new ResourceObject("foreground", "Foreground", 10);
        resourceDB.put("-fg", resourceObject);
        resourceObject = new ResourceObject("fixedCellHeight", "FixedCellHeight", 11);
        resourceDB.put("-fixedcellheight", resourceObject);
        resourceObject = new ResourceObject("fixedCellWidth", "FixedCellWidth", 12);
        resourceDB.put("-fixedcellwidth", resourceObject);
        resourceObject = new ResourceObject("focusable", "Focusable", 13);
        resourceDB.put("-focusable", resourceObject);
        resourceObject = new ResourceObject("focusCycleRoot", "FocusCycleRoot", 14);
        resourceDB.put("-focuscycleroot", resourceObject);
        resourceObject = new ResourceObject("focusTraversalKeysEnabled", "FocusTraversalKeysEnabled", 15);
        resourceDB.put("-focustraversalkeysenabled", resourceObject);
        resourceObject = new ResourceObject("focusTraversalPolicyProvider", "FocusTraversalPolicyProvider", 16);
        resourceDB.put("-focustraversalpolicyprovider", resourceObject);
        resourceObject = new ResourceObject("font", "Font", 17);
        resourceDB.put("-font", resourceObject);
        resourceObject = new ResourceObject("foreground", "Foreground", 18);
        resourceDB.put("-foreground", resourceObject);
        resourceObject = new ResourceObject("visibleRowCount", "VisibleRowCount", 19);
        resourceDB.put("-height", resourceObject);
        resourceObject = new ResourceObject("highlightBackground", "HighlightBackground", 20);
        resourceDB.put("-highlightbackground", resourceObject);
        resourceObject = new ResourceObject("highlightColor", "HighlightColor", 21);
        resourceDB.put("-highlightcolor", resourceObject);
        resourceObject = new ResourceObject("highlightThickness", "HighlightThickness", 22);
        resourceDB.put("-highlightthickness", resourceObject);
        resourceObject = new ResourceObject("jHelpTarget", "JHelpTarget", 23);
        resourceDB.put("-jhelptarget", resourceObject);
        resourceObject = new ResourceObject("layoutOrientation", "LayoutOrientation", 24);
        resourceDB.put("-layoutorientation", resourceObject);
        resourceObject = new ResourceObject("listVar", "ListVar", 25);
        resourceDB.put("-listvar", resourceObject);
        resourceObject = new ResourceObject("opaque", "Opaque", 26);
        resourceDB.put("-opaque", resourceObject);
        resourceObject = new ResourceObject("padx", "Padx", 27);
        resourceDB.put("-padx", resourceObject);
        resourceObject = new ResourceObject("pady", "Pady", 28);
        resourceDB.put("-pady", resourceObject);
        resourceObject = new ResourceObject("relief", "Relief", 29);
        resourceDB.put("-relief", resourceObject);
        resourceObject = new ResourceObject("requestFocusEnabled", "RequestFocusEnabled", 30);
        resourceDB.put("-requestfocusenabled", resourceObject);
        resourceObject = new ResourceObject("selectionBackground", "SelectionBackground", 31);
        resourceDB.put("-selectbackground", resourceObject);
        resourceObject = new ResourceObject("selectBorderWidth", "SelectBorderWidth", 32);
        resourceDB.put("-selectborderwidth", resourceObject);
        resourceObject = new ResourceObject("selectedIndex", "SelectedIndex", 33);
        resourceDB.put("-selectedindex", resourceObject);
        resourceObject = new ResourceObject("selectionForeground", "SelectionForeground", 34);
        resourceDB.put("-selectforeground", resourceObject);
        resourceObject = new ResourceObject("selectionBackground", "SelectionBackground", 35);
        resourceDB.put("-selectionbackground", resourceObject);
        resourceObject = new ResourceObject("selectionForeground", "SelectionForeground", 36);
        resourceDB.put("-selectionforeground", resourceObject);
        resourceObject = new ResourceObject("selectionMode", "SelectionMode", 37);
        resourceDB.put("-selectionmode", resourceObject);
        resourceObject = new ResourceObject("selectionMode", "SelectionMode", 38);
        resourceDB.put("-selectmode", resourceObject);
        resourceObject = new ResourceObject("setGrid", "SetGrid", 39);
        resourceDB.put("-setgrid", resourceObject);
        resourceObject = new ResourceObject("takeFocus", "TakeFocus", 40);
        resourceDB.put("-takefocus", resourceObject);
        resourceObject = new ResourceObject("toolTipText", "ToolTipText", 41);
        resourceDB.put("-tooltiptext", resourceObject);
        resourceObject = new ResourceObject("valueIsAdjusting", "ValueIsAdjusting", 42);
        resourceDB.put("-valueisadjusting", resourceObject);
        resourceObject = new ResourceObject("verifyInputWhenFocusTarget", "VerifyInputWhenFocusTarget", 43);
        resourceDB.put("-verifyinputwhenfocustarget", resourceObject);
        resourceObject = new ResourceObject("visible", "Visible", 44);
        resourceDB.put("-visible", resourceObject);
        resourceObject = new ResourceObject("visibleRowCount", "VisibleRowCount", 45);
        resourceDB.put("-visiblerowcount", resourceObject);
        resourceObject = new ResourceObject("width", "Width", 46);
        resourceDB.put("-width", resourceObject);
        resourceObject = new ResourceObject("xScrollCommand", "XScrollCommand", 47);
        resourceDB.put("-xscrollcommand", resourceObject);
        resourceObject = new ResourceObject("yScrollCommand", "YScrollCommand", 48);
        resourceDB.put("-yscrollcommand", resourceObject);
    }

    static {
        for (int i = 0; i < validCmds.length; ++i) {
            validCmdsTM.put(validCmds[i], new Integer(i));
        }
    }

    class ResourceDefaultsSetter
    implements Runnable {
        Interp interp;
        SwkJList swkjlist;

        ResourceDefaultsSetter(Interp interp, SwkJList swkjlist) {
            this.interp = interp;
            this.swkjlist = swkjlist;
        }

        public void run() {
            SwkJList.this.setResourceDefaultsET();
        }
    }

    class JGet
    implements Runnable {
        SwkJList swkjlist;
        int opt = 0;
        String result = "";

        JGet(SwkJList swkjlist, int opt) {
            this.swkjlist = swkjlist;
            this.opt = opt;
        }

        public void run() {
            this.result = this.swkjlist.jget(this.opt);
        }
    }

    class JGetAll
    implements Runnable {
        SwkJList swkjlist;
        ArrayList roValues = null;

        JGetAll(SwkJList swkjlist) {
            this.swkjlist = swkjlist;
        }

        public void run() {
            this.roValues = SwkJList.this.getAllConfigurations();
        }
    }
}

