/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.ItemLine;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class ArrowParameter
extends CanvasParameter {
    private static String name = "arrow";
    private static String defValue = "none";
    private int newValue = 0;

    public String getName() {
        return name;
    }

    public String getDefault() {
        return defValue + "";
    }

    public boolean isParameterLabel(String s) {
        return s.length() > 3 && "-arrow".startsWith(s);
    }

    public TclObject getValue(Interp interp, SwkShape swkShape) throws TclException {
        if (swkShape == null) {
            throw new TclException(interp, "shape doesn't exist");
        }
        ItemLine swkLine = (ItemLine)swkShape;
        String arrow = "none";
        arrow = swkLine.arrowFirst && swkLine.arrowLast ? "both" : (swkLine.arrowFirst ? "first" : (swkLine.arrowLast ? "last" : "none"));
        return TclString.newInstance((String)arrow);
    }

    public void setValue(Interp interp, SwkImageCanvas swkCanvas, TclObject arg) throws TclException {
        this.newValue = arg.toString().startsWith("both") ? 3 : (arg.toString().startsWith("first") ? 1 : (arg.toString().equals("last") ? 2 : 0));
    }

    public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
        if (swkShape != null && swkShape instanceof ItemLine) {
            ItemLine swkLine = (ItemLine)swkShape;
            switch (this.newValue) {
                case 0: {
                    swkLine.arrowFirst = false;
                    swkLine.arrowLast = false;
                    break;
                }
                case 1: {
                    swkLine.arrowFirst = true;
                    swkLine.arrowLast = false;
                    break;
                }
                case 2: {
                    swkLine.arrowFirst = false;
                    swkLine.arrowLast = true;
                    break;
                }
                case 3: {
                    swkLine.arrowFirst = true;
                    swkLine.arrowLast = true;
                    break;
                }
                default: {
                    swkLine.arrowFirst = false;
                    swkLine.arrowLast = false;
                }
            }
        }
    }
}

