/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.NodeParameter;
import com.onemoonscientific.swank.canvas.RadiusParameter;
import com.onemoonscientific.swank.canvas.RotateParameter;
import com.onemoonscientific.swank.canvas.ShearParameter;
import com.onemoonscientific.swank.canvas.StateParameter;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import com.onemoonscientific.swank.canvas.SymbolInterface;
import com.onemoonscientific.swank.canvas.SymbolParameter;
import com.onemoonscientific.swank.canvas.TagsParameter;
import com.onemoonscientific.swank.canvas.TransformerParameter;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.Map;
import java.util.TreeMap;

public class ItemSymbols
extends SwkShape
implements SymbolInterface {
    static CanvasParameter[] parameters = new CanvasParameter[]{new SymbolParameter(), new RadiusParameter(), new RotateParameter(), new ShearParameter(), new TagsParameter(), new StateParameter(), new NodeParameter(), new TransformerParameter()};
    static Map parameterMap = new TreeMap();
    float radius = 2.0f;
    int symbolType = 3;
    GeneralPath gPath = null;
    boolean closePath = false;

    public ItemSymbols(Shape shape, SwkImageCanvas canvas) {
        super(shape, canvas);
        this.gPath = (GeneralPath)shape;
        this.fill = null;
    }

    public void setSymbolType(int newSymbolType) {
        this.symbolType = newSymbolType;
    }

    public String getSymbolType() {
        return SymbolParameter.getSymbolType(this.symbolType);
    }

    public void setRadius(double newRadius) {
        this.radius = (float)newRadius;
    }

    public double getRadius() {
        return this.radius;
    }

    public void coords(SwkImageCanvas canvas, double[] coords) throws SwkException {
        if (coords.length < 2) {
            throw new SwkException("wrong # coordinates: expected at least 2, got " + coords.length);
        }
        if (coords.length % 2 != 0) {
            throw new SwkException("wrong # coordinates: expected even number, got " + coords.length);
        }
        this.gPath.reset();
        if (this.storeCoords == null || this.storeCoords.length != coords.length) {
            this.storeCoords = new double[coords.length];
        }
        System.arraycopy(coords, 0, this.storeCoords, 0, coords.length);
        this.applyCoordinates();
    }

    public void applyCoordinates() {
        for (int i = 0; i < this.storeCoords.length; i += 2) {
            this.addSymbol((float)this.storeCoords[i], (float)this.storeCoords[i + 1], this.radius);
        }
        AffineTransform aT = new AffineTransform();
        aT.translate(this.storeCoords[0], this.storeCoords[1]);
        aT.shear(this.xShear, this.yShear);
        aT.translate(-this.storeCoords[0], -this.storeCoords[1]);
        aT.rotate(this.rotate, (this.storeCoords[0] + this.storeCoords[2]) / 2.0, (this.storeCoords[1] + this.storeCoords[3]) / 2.0);
        this.shape = aT.createTransformedShape(this.gPath);
    }

    public void addSymbol(float x1, float y1, float radius) {
        switch (this.symbolType) {
            case 0: {
                Ellipse2D.Float ellipse = new Ellipse2D.Float(x1 - radius, y1 - radius, 2.0f * radius, 2.0f * radius);
                this.gPath.append(ellipse, false);
                break;
            }
            case 1: {
                this.gPath.moveTo(x1, y1 - radius);
                this.gPath.lineTo(x1 - radius * 0.67f, y1 + radius * 0.66f);
                this.gPath.lineTo(x1 + radius * 0.67f, y1 + radius * 0.66f);
                this.gPath.closePath();
                break;
            }
            case 2: {
                this.gPath.moveTo(x1, y1 + radius);
                this.gPath.lineTo(x1 - radius * 0.67f, y1 - radius * 0.66f);
                this.gPath.lineTo(x1 + radius * 0.67f, y1 - radius * 0.66f);
                this.gPath.closePath();
                break;
            }
            case 3: {
                this.gPath.moveTo(x1, y1 + radius);
                this.gPath.lineTo(x1, y1 - radius);
                this.gPath.moveTo(x1 - radius, y1);
                this.gPath.lineTo(x1 + radius, y1);
                break;
            }
            case 4: {
                this.gPath.moveTo(x1 - radius, y1 - radius);
                this.gPath.lineTo(x1 + radius, y1 - radius);
                this.gPath.lineTo(x1 + radius, y1 + radius);
                this.gPath.lineTo(x1 - radius, y1 + radius);
                this.gPath.closePath();
                break;
            }
            case 5: {
                this.gPath.moveTo(x1, y1 - radius);
                this.gPath.lineTo(x1 + radius, y1);
                this.gPath.lineTo(x1, y1 + radius);
                this.gPath.lineTo(x1 - radius, y1);
                this.gPath.closePath();
            }
        }
    }

    public CanvasParameter[] getParameters() {
        return parameters;
    }

    public Map getParameterMap() {
        return parameterMap;
    }

    public String getType() {
        return "symbols";
    }

    static {
        ItemSymbols.initializeParameters(parameters, parameterMap);
    }
}

