/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.ContextWithRuntimeLock;
import org.ocamljava.runtime.context.ContextWithoutRuntimeLock;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.AbstractCodeRunner;
import org.ocamljava.runtime.kernel.AtExit;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Debug;
import org.ocamljava.runtime.kernel.Executable;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.FatalErrorKind;
import org.ocamljava.runtime.kernel.MarshalIntern;
import org.ocamljava.runtime.kernel.NativeApply;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.kernel.Signals;
import org.ocamljava.runtime.kernel.StandardError;
import org.ocamljava.runtime.parameters.NativeParameters;
import org.ocamljava.runtime.primitives.otherlibs.systhreads.ThreadStatus;
import org.ocamljava.runtime.values.Value;

public abstract class AbstractNativeRunner
extends AbstractCodeRunner
implements Executable {
    protected Value result;
    protected Throwable exception;
    private final Map<Class<?>, Object> constants;
    private final Map<String, Value> globals;
    private int globalsInited;
    private Throwable backtraceInfo;

    public AbstractNativeRunner(NativeParameters np) {
        super(np.hasRuntimeLock() ? new ContextWithRuntimeLock(np, true, new File(".")) : new ContextWithoutRuntimeLock(np, true, new File(".")));
        OCamlJavaThread.registerCodeRunner(Thread.currentThread(), this);
        this.constants = new HashMap();
        this.globals = this.context.getPredefinedExceptions().initialMap();
        this.globalsInited = 0;
        this.result = null;
        this.exception = null;
        this.backtraceInfo = null;
    }

    public AbstractNativeRunner(AbstractNativeRunner that) {
        super(that.context);
        this.constants = that.constants;
        this.globals = that.globals;
        this.globalsInited = that.globalsInited;
        this.result = null;
        this.exception = null;
        this.backtraceInfo = null;
    }

    public final Value getResult() {
        return this.result;
    }

    public static AbstractNativeRunner getRunner() {
        return (AbstractNativeRunner)OCamlJavaThread.getCodeRunner();
    }

    public static void checkSignals() throws FailException, FatalError, FalseExit, OCamlJavaException {
        Signals.processSignal(OCamlJavaThread.getCodeRunner());
    }

    public static Value getAtom(int atm) {
        return CurrentContext.getCodeState().getAtom(atm);
    }

    public static Value loadConstants(Class<?> id) throws OCamlJavaException {
        Context ctxt = CurrentContext.get();
        try {
            InputStream is = id.getResourceAsStream(id.getSimpleName() + ".consts");
            if (is == null) {
                throw new OCamlJavaException("unable to load constants for " + id);
            }
            DataInputStream dis = new DataInputStream(is);
            Value consts = MarshalIntern.inputVal(ctxt, dis, true);
            dis.close();
            is.close();
            return consts;
        }
        catch (IOException | FailException | FatalError e) {
            throw new OCamlJavaException("unable to load constants for " + id, e);
        }
    }

    public final void setConstant(Class<?> id, Object cst) {
        this.constants.put(id, cst);
    }

    public static Object getConstants(Class<?> id) {
        assert (id != null) : "null id";
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        return ((AbstractNativeRunner)runner).constants.get(id);
    }

    public static Value getGlobal(String id) {
        assert (id != null) : "null id";
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        Debug.begin();
        if (Debug.ENABLED) {
            System.out.printf("XXX ANR.getGlobal(%s) -> %s\n", id, ((AbstractNativeRunner)runner).globals.get(id));
        }
        Debug.end();
        return ((AbstractNativeRunner)runner).globals.get(id);
    }

    public final Value getGlobalFromInstance(String id) {
        assert (id != null) : "null id";
        Debug.begin();
        if (Debug.ENABLED) {
            System.out.printf("XXX ANR.getGlobalFromInstance(%s) -> %s\n", id, this.globals.get(id));
        }
        Debug.end();
        return this.globals.get(id);
    }

    public static void setGlobal(String id, Value val) {
        assert (id != null) : "null id";
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        Debug.begin();
        if (Debug.ENABLED) {
            System.out.printf("XXX ANR.setGlobal(%s, %s)\n", id, val);
        }
        Debug.end();
        ((AbstractNativeRunner)runner).globals.put(id, val);
    }

    public final int getGlobalsInited() {
        return this.globalsInited;
    }

    public final void incrGlobalsInited() {
        ++this.globalsInited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Value callback(Value closure, Value ... params) throws FailException, FatalError, FalseExit {
        boolean addTemporarily;
        assert (closure != null) : "null closure";
        assert (params != null) : "null params";
        assert (params.length + 4 <= 256) : "params is too long";
        Thread currentThread = Thread.currentThread();
        boolean isOCamlJavaThread = currentThread instanceof OCamlJavaThread;
        boolean isRegistered = OCamlJavaThread.isRegistered(currentThread);
        boolean bl = addTemporarily = !isOCamlJavaThread && !isRegistered;
        if (addTemporarily) {
            this.context.getThreadsState().addAdditionalThread(currentThread);
        }
        AbstractNativeRunner runner = this.copy();
        runner.threadStatus = null;
        runner.setup(closure, params);
        runner.exception = null;
        try {
            runner.run();
        }
        finally {
            if (!addTemporarily) {
                this.context.getThreadsState().removeAdditionalThread(currentThread);
            }
        }
        if (runner.exception != null) {
            if (runner.exception instanceof FailException) {
                throw (FailException)runner.exception;
            }
            if (runner.exception instanceof FatalError) {
                throw (FatalError)runner.exception;
            }
            if (runner.exception instanceof FalseExit) {
                AtExit.execute(null);
                throw (FalseExit)runner.exception;
            }
            Fatal.raise(FatalErrorKind.CALLBACK_ERROR, runner.exception.getMessage());
        }
        return runner.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.result = null;
        this.exception = null;
        try {
            CurrentContext.leaveBlockingSection();
        }
        catch (FailException fe) {
            return;
        }
        catch (FalseExit fe) {
            return;
        }
        try {
            if (this.closure == null) {
                try {
                    this.moduleMain();
                }
                catch (Throwable t) {
                    this.setBacktraceInfo(t);
                    this.exception = t;
                }
            } else {
                try {
                    this.result = NativeApply.apply(this.closure, this.args);
                }
                catch (Throwable t) {
                    this.setBacktraceInfo(t);
                    this.exception = t;
                }
            }
        }
        finally {
            if (this.threadStatus != null) {
                ((ThreadStatus)this.threadStatus.get(2L).asCustom()).terminate();
            }
            CurrentContext.enterBlockingSection();
        }
    }

    public final void execute() {
        OCamlJavaThread.registerCodeRunner(Thread.currentThread(), this);
        this.context.getThreadsState().setMainCodeRunner(this);
        this.setup(null, new Value[0]);
        OCamlJavaThread thread = new OCamlJavaThread(this.context.getThreadsState().getThreadGroup(), this);
        this.context.getThreadsState().setMainThread(thread);
        thread.start();
        while (thread.isAlive()) {
            try {
                thread.join();
            }
            catch (InterruptedException ie) {
                return;
            }
        }
        Signals.unregisterContext(this.context);
        this.context.getSignalsState().clearSignals();
        if (this.exception != null && !(this.exception instanceof FalseExit)) {
            StandardError.reportNativeException(this, this.exception);
            Debug.begin();
            if (Debug.ENABLED) {
                System.out.println("*** Debugging information:");
                this.exception.printStackTrace(System.out);
            }
            Debug.end();
            AtExit.execute(null);
        } else {
            AtExit.execute(null);
        }
    }

    @Override
    public final void executeSilently() {
        this.execute();
    }

    public final void executeWithBindings(Map<String, Value> bindings) {
        this.bindings = bindings;
        this.execute();
    }

    private StackTraceElement[] filterBackTrace(StackTraceElement[] elems, int max) {
        assert (elems != null) : "null elems";
        boolean simplified = ((NativeParameters)this.context.getParameters()).isSimplifiedBacktrace();
        ArrayList<StackTraceElement> l = new ArrayList<StackTraceElement>(Arrays.asList(elems));
        Iterator it = l.iterator();
        int counter = 0;
        while (it.hasNext()) {
            boolean maxReached;
            StackTraceElement e = (StackTraceElement)it.next();
            String className = e.getClassName();
            boolean filtered = className.startsWith("java.lang.") || className.startsWith("java.lang.reflect.") || className.startsWith("java.lang.invoke.") || className.startsWith("org.ocamljava.runtime.kernel.") || className.startsWith("org.ocamljava.runtime.values.");
            boolean bl = maxReached = counter >= max;
            if (maxReached || simplified && filtered || e.getFileName() == null || e.getLineNumber() < 0) {
                it.remove();
            }
            ++counter;
        }
        return l.toArray(new StackTraceElement[l.size()]);
    }

    @Override
    public final void printExceptionBacktrace(PrintStream out) {
        assert (out != null) : "null out";
        for (StackTraceElement elem : this.filterBackTrace(this.exception.getStackTrace(), 1024)) {
            out.println("\tat " + elem);
        }
    }

    public final void setBacktraceInfo(Throwable t) {
        if (this.context.getCodeState().isBacktraceActive()) {
            this.backtraceInfo = t;
        }
    }

    @Override
    public final void clearBacktraceInfo() {
        this.backtraceInfo = null;
    }

    public final void clearException() {
        this.exception = null;
    }

    private static Value convertBacktrace(StackTraceElement[] elems) {
        int len = elems.length;
        Value arr = Value.createBlock(0, len);
        for (int i = 0; i < len; ++i) {
            StackTraceElement elem = elems[i];
            Value p = Value.createBlock(0, i == 0 ? Value.TRUE : Value.FALSE, Value.createString(elem.getFileName()), Value.createLong(elem.getLineNumber()), Value.ZERO, Value.ZERO);
            arr.set(i, p);
        }
        return Value.createBlock(0, arr);
    }

    @Override
    public final Value getExceptionRawBacktrace() {
        if (this.backtraceInfo != null) {
            StackTraceElement[] l = this.filterBackTrace(this.backtraceInfo.getStackTrace(), 1024);
            return AbstractNativeRunner.convertBacktrace(l);
        }
        return Value.createBlock(0, Value.createBlock(0));
    }

    @Override
    public final Value getCurrentCallStack(int n) {
        StackTraceElement[] stack = null;
        try {
            new Throwable();
        }
        catch (Throwable t) {
            stack = this.filterBackTrace(t.getStackTrace(), n);
        }
        return AbstractNativeRunner.convertBacktrace(stack);
    }

    @Override
    public final CodeRunner createNewThread(Value status) {
        AbstractNativeRunner res = this.copy();
        if (status != null) {
            res.setThreadStatus(status);
        }
        return res;
    }

    protected abstract AbstractNativeRunner copy();

    protected abstract void moduleMain();

    public static void sharedConstantsBegin() {
    }

    public static void sharedConstantsEnd() {
    }

    public static void initGlobalBegin(int index) {
    }

    public static void initGlobalEnd() {
    }
}

