(*
 * This file is part of Barista.
 * Copyright (C) 2007-2014 Xavier Clerc.
 *
 * Barista is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Barista is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *)

(** Miscellaneous OS-related utilities. *)

val argv : UTF8.t array
(** The command-line arguments that launched the program. *)

val get_env : UTF8.t -> UTF8.t
(** Returns the environment variable whose name is passed, raising
    [Not_found] if such a variable does not exist. *)

val get_property : UTF8.t -> UTF8.t
(** Returns the property whose name is passed, raising [Not_found] if
    such a variable does not exist. *)

val timestamp : unit -> string
(** Returns a timestamp using the ["YYYY-MM-DD"] format. *)

val execute : string -> UTF8.t list
(** Execute the passed command, and returns what it has written on the
    standard output as a list of strings.

    Raises [Not_found] if the command cannot be executed, or its output
    cannot be read. *)

val read_file : Path.t -> Bytes.t
(** Returns the contents of the file whose name is passed.

    Raises an exception if file does not exist, or cannot be read. *)
