(*
 * This file is part of Barista.
 * Copyright (C) 2007-2014 Xavier Clerc.
 *
 * Barista is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Barista is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *)

(** Line readers for UTF8.

    This definition is independent of the actual implementation,
    that can be based on either the Camomile library (available at
    http://camomile.sourceforge.net), or the OCaml-Java runtime
    library. *)

BARISTA_ERROR =
  | Unable_to_open_reader of Path.t
  | Unable_to_read_data
  | Unable_to_close_reader

type t
(** The type of UTF8 line-oriented readers. *)

val make_of_path : Path.t -> t
(** Constructs a line reader from a path.

    Raises [Exception] if an error occurs. *)

val make_of_stream : InputStream.t -> t
(** Constructs a line reader from a stream. *)

val read_line : t -> UTF8.t
(** [read_line reader] returns the next line read from [reader].

    Raises [End_of_file] if end of file is encountered.

    Raises [Exception] if an error occurs. *)

val read_lines : t -> UTF8.t list
(** [read_lines reader] returns the lines read from [reader].

    Raises [Exception] if an error occurs. *)

val close : t -> unit
(** Closes the passed reader.

    Raises [Exception] if an error occurs. *)

val close_noerr : t -> unit
(** Closes the passed reader, errors being silently discarded. *)
