/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

public class Descriptor {
    public static final String VOID = "V";
    public static final String BYTE = "B";
    public static final String CHAR = "C";
    public static final String DOUBLE = "D";
    public static final String FLOAT = "F";
    public static final String INT = "I";
    public static final String LONG = "J";
    public static final String SHORT = "S";
    public static final String BOOLEAN = "Z";
    public static final String OBJECT = "Ljava/lang/Object;";
    public static final String STRING = "Ljava/lang/String;";
    public static final String CLASS = "Ljava/lang/Class;";
    public static final String THROWABLE = "Ljava/lang/Throwable;";
    public static final String RUNTIME_EXCEPTION = "Ljava/lang/RuntimeException;";
    public static final String ERROR = "Ljava/lang/Error;";
    public static final String CLONEABLE = "Ljava/lang/Cloneable;";
    public static final String SERIALIZABLE = "Ljava/io/Serializable;";

    public static boolean isReference(String d) {
        return d.length() > 1;
    }

    public static boolean isClassOrInterfaceReference(String d) {
        return d.charAt(0) == 'L';
    }

    public static boolean isArrayReference(String d) {
        return d.charAt(0) == '[';
    }

    public static String getComponentDescriptor(String d) {
        if (d.charAt(0) != '[') {
            throw new RuntimeException("Cannot determine component descriptor from non-array descriptor \"" + d + "\"");
        }
        return d.substring(1);
    }

    public static short size(String d) {
        if (d.equals(VOID)) {
            return 0;
        }
        if (Descriptor.hasSize1(d)) {
            return 1;
        }
        if (Descriptor.hasSize2(d)) {
            return 2;
        }
        throw new RuntimeException("No size defined for type \"" + Descriptor.toString(d) + "\"");
    }

    public static boolean hasSize1(String d) {
        if (d.length() == 1) {
            return "BCFISZ".indexOf(d) != -1;
        }
        return Descriptor.isReference(d);
    }

    public static boolean hasSize2(String d) {
        return d.equals(LONG) || d.equals(DOUBLE);
    }

    public static String toString(String d) {
        int idx = 0;
        StringBuffer sb = new StringBuffer();
        if (d.charAt(0) == '(') {
            ++idx;
            sb.append("(");
            while (idx < d.length() && d.charAt(idx) != ')') {
                if (idx != 1) {
                    sb.append(", ");
                }
                idx = Descriptor.toString(d, idx, sb);
            }
            if (idx >= d.length()) {
                throw new RuntimeException("Invalid descriptor \"" + d + "\"");
            }
            sb.append(") => ");
            ++idx;
        }
        Descriptor.toString(d, idx, sb);
        return sb.toString();
    }

    private static int toString(String d, int idx, StringBuffer sb) {
        int dimensions = 0;
        while (idx < d.length() && d.charAt(idx) == '[') {
            ++dimensions;
            ++idx;
        }
        if (idx >= d.length()) {
            throw new RuntimeException("Invalid descriptor \"" + d + "\"");
        }
        switch (d.charAt(idx)) {
            case 'L': {
                int idx2 = d.indexOf(59, idx);
                if (idx2 == -1) {
                    throw new RuntimeException("Invalid descriptor \"" + d + "\"");
                }
                sb.append(d.substring(idx + 1, idx2).replace('/', '.'));
                idx = idx2;
                break;
            }
            case 'V': {
                sb.append("void");
                break;
            }
            case 'B': {
                sb.append("byte");
                break;
            }
            case 'C': {
                sb.append("char");
                break;
            }
            case 'D': {
                sb.append("double");
                break;
            }
            case 'F': {
                sb.append("float");
                break;
            }
            case 'I': {
                sb.append("int");
                break;
            }
            case 'J': {
                sb.append("long");
                break;
            }
            case 'S': {
                sb.append("short");
                break;
            }
            case 'Z': {
                sb.append("boolean");
                break;
            }
            default: {
                throw new RuntimeException("Invalid descriptor \"" + d + "\"");
            }
        }
        while (dimensions > 0) {
            sb.append("[]");
            --dimensions;
        }
        return idx + 1;
    }

    public static String fromClassName(String className) {
        if (className.equals("void")) {
            return VOID;
        }
        if (className.equals("byte")) {
            return BYTE;
        }
        if (className.equals("char")) {
            return CHAR;
        }
        if (className.equals("double")) {
            return DOUBLE;
        }
        if (className.equals("float")) {
            return FLOAT;
        }
        if (className.equals("int")) {
            return INT;
        }
        if (className.equals("long")) {
            return LONG;
        }
        if (className.equals("short")) {
            return SHORT;
        }
        if (className.equals("boolean")) {
            return BOOLEAN;
        }
        if (className.startsWith("[")) {
            return className.replace('.', '/');
        }
        return 'L' + className.replace('.', '/') + ';';
    }

    public static String fromInternalForm(String internalForm) {
        if (internalForm.charAt(0) == '[') {
            return internalForm;
        }
        return 'L' + internalForm + ';';
    }

    public static String toClassName(String d) {
        if (d.length() == 1) {
            if (d.equals(VOID)) {
                return "void";
            }
            if (d.equals(BYTE)) {
                return "byte";
            }
            if (d.equals(CHAR)) {
                return "char";
            }
            if (d.equals(DOUBLE)) {
                return "double";
            }
            if (d.equals(FLOAT)) {
                return "float";
            }
            if (d.equals(INT)) {
                return "int";
            }
            if (d.equals(LONG)) {
                return "long";
            }
            if (d.equals(SHORT)) {
                return "short";
            }
            if (d.equals(BOOLEAN)) {
                return "boolean";
            }
        } else {
            char firstChar = d.charAt(0);
            if (firstChar == 'L' && d.endsWith(";")) {
                return d.substring(1, d.length() - 1).replace('/', '.');
            }
            if (firstChar == '[') {
                return d.replace('/', '.');
            }
        }
        throw new RuntimeException("(Invalid field descriptor \"" + d + "\")");
    }

    public static String toInternalForm(String d) {
        if (d.charAt(0) != 'L') {
            throw new RuntimeException("Attempt to convert non-class descriptor \"" + d + "\" into internal form");
        }
        return d.substring(1, d.length() - 1);
    }

    public static boolean isPrimitive(String d) {
        return d.length() == 1 && "VBCDFIJSZ".indexOf(d.charAt(0)) != -1;
    }

    public static boolean isPrimitiveNumeric(String d) {
        return d.length() == 1 && "BDFIJSC".indexOf(d.charAt(0)) != -1;
    }

    public static String getPackageName(String d) {
        if (d.charAt(0) != 'L') {
            throw new RuntimeException("Attempt to get package name of non-class descriptor \"" + d + "\"");
        }
        int idx = d.lastIndexOf(47);
        return idx == -1 ? null : d.substring(1, idx).replace('/', '.');
    }

    public static boolean areInSamePackage(String d1, String d2) {
        String packageName1 = Descriptor.getPackageName(d1);
        String packageName2 = Descriptor.getPackageName(d2);
        return packageName1 == null ? packageName2 == null : packageName1.equals(packageName2);
    }
}

