/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.PredefinedExceptions;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.InvalidByteCodeFileException;
import org.ocamljava.runtime.kernel.MarshalIntern;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IO;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.util.RandomAccessInputStream;
import org.ocamljava.runtime.values.Value;

final class ByteCodeFileLoader {
    private static final String EXEC_MAGIC = "Caml1999X008";
    private static final int TRAILER_SIZE = 16;
    private static final String MD5_ALGO = "MD5";
    private static final String SECTION_SHARED_LIB_PATH = "DLPT";
    private static final String SECTION_SHARED_LIBS = "DLLS";
    private static final String SECTION_REQ_PRIMS = "PRIM";
    private static final String SECTION_CODE = "CODE";
    private static final String SECTION_DATA = "DATA";
    private static final String SECTION_DEBUG = "DBUG";
    private static final int SECTION_NAME_LENGTH = 4;
    private static final int SECTION_SIZE = 8;
    private static final String INVALID_MAGIC = "invalid magic";
    private static final String MISSING_SECTION = "missing '%s' section";
    private static final String INVALID_SECTION = "section of more than 2147483647 bytes";
    private static final String INVALID_CODE_SECTION_SIZE = "code section size should be a multiple of 4";
    private final List<String> primitives;
    private final List<String> sharedLibPath;
    private final List<String> sharedLibs;
    private final int[] code;
    private final Value globalData;
    private final Value debugInfo;

    ByteCodeFileLoader(Context context, RandomAccessInputStream randomAccessInputStream) throws IOException, InvalidByteCodeFileException, NoSuchAlgorithmException, FatalError {
        Object object;
        Object object2;
        assert (context != null) : "null ctxt";
        assert (randomAccessInputStream != null) : "null inputStream";
        long l = randomAccessInputStream.length();
        DataInput dataInput = randomAccessInputStream.dataInputFrom(l - 16L);
        int n = IntegerUtils.ensure32s(IO.read32u(dataInput));
        byte[] byArray = new byte[EXEC_MAGIC.length()];
        dataInput.readFully(byArray);
        if (!EXEC_MAGIC.equals(EncodingUtils.convertBytesToString(byArray))) {
            throw new InvalidByteCodeFileException(INVALID_MAGIC);
        }
        long l2 = 0L;
        dataInput = randomAccessInputStream.dataInputFrom(l - (long)(16 + 8 * n));
        LinkedHashMap<String, Section> linkedHashMap = new LinkedHashMap<String, Section>();
        for (int i = 0; i < n; ++i) {
            object2 = new byte[4];
            dataInput.readFully((byte[])object2);
            object = EncodingUtils.convertBytesToString(object2);
            long l3 = IO.read32u(dataInput);
            if (l3 > Integer.MAX_VALUE) {
                throw new InvalidByteCodeFileException(INVALID_SECTION);
            }
            linkedHashMap.put((String)object, new Section((String)object, l2, (int)l3));
            l2 += l3;
        }
        Object object3 = linkedHashMap.values().iterator();
        while (object3.hasNext()) {
            object2 = (Section)object3.next();
            ((Section)object2).offset = l - (l2 - ((Section)object2).offset + 16L + (long)(8 * n));
        }
        object3 = (Section)linkedHashMap.get(SECTION_CODE);
        if (object3 == null) {
            throw new InvalidByteCodeFileException(String.format(MISSING_SECTION, SECTION_CODE));
        }
        int n2 = ((Section)object3).size;
        if (n2 % 4 != 0) {
            throw new InvalidByteCodeFileException(INVALID_CODE_SECTION_SIZE);
        }
        object = new byte[n2];
        dataInput = randomAccessInputStream.dataInputFrom(((Section)object3).offset);
        dataInput.readFully((byte[])object);
        CodeState codeState = context.getCodeState();
        MessageDigest messageDigest = MessageDigest.getInstance(MD5_ALGO);
        byte[] byArray2 = messageDigest.digest((byte[])object);
        codeState.setCodeDigest(byArray2);
        for (int i = 0; i < n2; i += 4) {
            Object object4 = object[i];
            object[i] = object[i + 3];
            object[i + 3] = object4;
            object4 = object[i + 1];
            object[i + 1] = object[i + 2];
            object[i + 2] = object4;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int n3 = n2 / 4;
        this.code = new int[n3];
        for (int i = 0; i < n3; ++i) {
            this.code[i] = dataInputStream.readInt();
        }
        codeState.appendCode(this.code);
        codeState.setupCallbackTail();
        this.sharedLibPath = Collections.unmodifiableList(ByteCodeFileLoader.readSection(randomAccessInputStream, SECTION_SHARED_LIB_PATH, linkedHashMap, false));
        this.sharedLibs = Collections.unmodifiableList(ByteCodeFileLoader.readSection(randomAccessInputStream, SECTION_SHARED_LIBS, linkedHashMap, false));
        List<String> list = ByteCodeFileLoader.readSection(randomAccessInputStream, SECTION_REQ_PRIMS, linkedHashMap, true);
        if (list == null || list.size() == 0) {
            throw new InvalidByteCodeFileException(String.format(MISSING_SECTION, SECTION_REQ_PRIMS));
        }
        this.primitives = Collections.unmodifiableList(list);
        Section section = (Section)linkedHashMap.get(SECTION_DATA);
        if (section == null) {
            throw new InvalidByteCodeFileException(String.format(MISSING_SECTION, SECTION_DATA));
        }
        dataInput = randomAccessInputStream.dataInputFrom(section.offset);
        try {
            this.globalData = MarshalIntern.inputVal(context, dataInput, true);
        }
        catch (FailException failException) {
            throw new InvalidByteCodeFileException(failException.getMessage());
        }
        codeState.setGlobalData(this.globalData);
        context.setPredefinedExceptions(new PredefinedExceptions(this.globalData));
        Section section2 = (Section)linkedHashMap.get(SECTION_DEBUG);
        if (section2 != null) {
            dataInput = randomAccessInputStream.dataInputFrom(section2.offset);
            int n4 = IntegerUtils.ensure32s(IO.read32u(dataInput));
            Value value = Value.createBlock(0, n4);
            for (int i = 0; i < n4; ++i) {
                Value value2;
                int n5 = IntegerUtils.ensure32s(IO.read32u(dataInput));
                try {
                    value2 = MarshalIntern.inputVal(context, dataInput, true);
                }
                catch (FailException failException) {
                    throw new InvalidByteCodeFileException(failException.toString());
                }
                for (Value value3 = value2; value3 != Value.EMPTY_LIST; value3 = value3.get1()) {
                    Value value4 = value3.get0();
                    value4.set(0L, Value.createLong(value4.get(0L).asLong() + (long)n5));
                }
                value.set(i, value2);
            }
            this.debugInfo = value;
        } else {
            this.debugInfo = Value.FALSE;
        }
        codeState.setDebugInfo(this.debugInfo);
    }

    List<String> getSharedLibPath() {
        return this.sharedLibPath;
    }

    List<String> getSharedLibs() {
        return this.sharedLibs;
    }

    List<String> getPrimitives() {
        return this.primitives;
    }

    int[] getCode() {
        return this.code;
    }

    Value getGlobalData() {
        return this.globalData;
    }

    Value getDebugInfo() {
        return this.debugInfo;
    }

    private static List<String> readSection(RandomAccessInputStream randomAccessInputStream, String string, Map<String, Section> map, boolean bl) throws IOException {
        assert (randomAccessInputStream != null) : "null in";
        assert (string != null) : "null name";
        assert (map != null) : "null sections";
        LinkedList<String> linkedList = new LinkedList<String>();
        Section section = map.get(string);
        if (section != null) {
            int n = section.size;
            byte[] byArray = new byte[n];
            randomAccessInputStream.dataInputFrom(section.offset).readFully(byArray);
            for (int i = 0; i < n && byArray[i] != 0; ++i) {
                int n2 = i;
                while (i < n && byArray[i] != 0) {
                    ++i;
                }
                linkedList.add(EncodingUtils.convertBytesToString(byArray, n2, i - n2));
            }
            return linkedList;
        }
        return bl ? null : linkedList;
    }

    private static final class Section {
        private final String name;
        private long offset;
        private final int size;

        private Section(String string, long l, int n) {
            assert (string != null) : "null n";
            assert (l >= 0L) : "ofs should be >= 0";
            assert (n >= 0) : "s should be >= 0";
            this.name = string;
            this.offset = l;
            this.size = n;
        }
    }
}

