/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="AtomicReferenceArray", source="")
public final class AtomicReferenceArray {
    private AtomicReferenceArray() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32", "'a"}, returnType="'a AtomicReferenceArray.t")
    public static Value ocamljava_atomicreferencearray_make(Value value, Value value2) throws FailException {
        try {
            int n = value.asInt32();
            java.util.concurrent.atomic.AtomicReferenceArray<Value> atomicReferenceArray = new java.util.concurrent.atomic.AtomicReferenceArray<Value>(n);
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return Value.createInstance(atomicReferenceArray);
                }
                atomicReferenceArray.set(n2, value2);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Fail.invalidArgument("Concurrent.AtomicReferenceArray.make");
            return Value.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a AtomicReferenceArray.t", "int32", "'a", "'a"}, returnType="bool")
    public static Value ocamljava_atomicreferencearray_compare_and_set(Value value, Value value2, Value value3, Value value4) throws FailException {
        try {
            Value value5;
            java.util.concurrent.atomic.AtomicReferenceArray atomicReferenceArray = (java.util.concurrent.atomic.AtomicReferenceArray)value.asCustom();
            boolean bl = atomicReferenceArray.compareAndSet(value2.asInt32(), value3, value4);
            if (bl) {
                value5 = Value.TRUE;
                return value5;
            }
            value5 = Value.FALSE;
            return value5;
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a AtomicReferenceArray.t", "int32"}, returnType="'a")
    public static Value ocamljava_atomicreferencearray_get(Value value, Value value2) throws FailException {
        try {
            java.util.concurrent.atomic.AtomicReferenceArray atomicReferenceArray = (java.util.concurrent.atomic.AtomicReferenceArray)value.asCustom();
            Value value3 = (Value)atomicReferenceArray.get(value2.asInt32());
            return value3;
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a AtomicReferenceArray.t", "int32", "'a"}, returnType="'a")
    public static Value ocamljava_atomicreferencearray_get_and_set(Value value, Value value2, Value value3) throws FailException {
        try {
            java.util.concurrent.atomic.AtomicReferenceArray atomicReferenceArray = (java.util.concurrent.atomic.AtomicReferenceArray)value.asCustom();
            Value value4 = atomicReferenceArray.getAndSet(value2.asInt32(), value3);
            return value4;
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a AtomicReferenceArray.t", "int32", "'a"}, returnType="unit")
    public static Value ocamljava_atomicreferencearray_lazy_set(Value value, Value value2, Value value3) throws FailException {
        try {
            java.util.concurrent.atomic.AtomicReferenceArray atomicReferenceArray = (java.util.concurrent.atomic.AtomicReferenceArray)value.asCustom();
            atomicReferenceArray.lazySet(value2.asInt32(), value3);
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a AtomicReferenceArray.t"}, returnType="int32")
    public static Value ocamljava_atomicreferencearray_length(Value value) {
        java.util.concurrent.atomic.AtomicReferenceArray atomicReferenceArray = (java.util.concurrent.atomic.AtomicReferenceArray)value.asCustom();
        int n = atomicReferenceArray.length();
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a AtomicReferenceArray.t", "int32", "'a"}, returnType="unit")
    public static Value ocamljava_atomicreferencearray_set(Value value, Value value2, Value value3) throws FailException {
        try {
            java.util.concurrent.atomic.AtomicReferenceArray atomicReferenceArray = (java.util.concurrent.atomic.AtomicReferenceArray)value.asCustom();
            atomicReferenceArray.set(value2.asInt32(), value3);
            return Value.UNIT;
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a AtomicReferenceArray.t", "int32", "'a", "'a"}, returnType="bool")
    public static Value ocamljava_atomicreferencearray_weak_compare_and_set(Value value, Value value2, Value value3, Value value4) throws FailException {
        try {
            Value value5;
            java.util.concurrent.atomic.AtomicReferenceArray atomicReferenceArray = (java.util.concurrent.atomic.AtomicReferenceArray)value.asCustom();
            boolean bl = atomicReferenceArray.weakCompareAndSet(value2.asInt32(), value3, value4);
            if (bl) {
                value5 = Value.TRUE;
                return value5;
            }
            value5 = Value.FALSE;
            return value5;
        }
        catch (Throwable throwable) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }
}

