/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.util.Arrays;
import java.util.Map;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.values.Value;

public abstract class AbstractCodeRunner
implements CodeRunner {
    protected final Context context;
    protected Value closure;
    protected Value[] args;
    protected Value threadStatus;
    protected Map<String, Value> bindings;

    AbstractCodeRunner(Context context) {
        assert (context != null) : "null context";
        this.context = context;
        this.closure = null;
        this.args = null;
    }

    @Override
    public final Context getContext() {
        return this.context;
    }

    @Override
    public final boolean isNative() {
        return this.context.getCodeState().isNative();
    }

    @Override
    public final void setBindings(Map<String, Value> map) {
        this.bindings = map;
    }

    @Override
    public final Map<String, Value> getBindings() {
        return this.bindings;
    }

    @Override
    public final void setup(Value value, Value ... valueArray) {
        this.closure = value;
        this.args = valueArray != null ? Arrays.copyOf(valueArray, valueArray.length) : null;
    }

    @Override
    public final Value getThreadStatus() {
        return this.threadStatus;
    }

    @Override
    public final void setThreadStatus(Value value) {
        assert (value != null) : "null ts";
        this.threadStatus = value;
    }

    @Override
    public final Value callback(String string, Value ... valueArray) throws FailException, FatalError, FalseExit, OCamlJavaException {
        assert (string != null) : "null function";
        assert (valueArray != null) : "null params";
        assert (valueArray.length + 4 <= 256) : "params is too long";
        Value value = this.context.getCodeState().getCallback(string);
        if (value == null) {
            throw new OCamlJavaException("unknown callback " + string);
        }
        return this.callback(value, valueArray);
    }

    public static Value getMethod(Value value, long l) {
        Value value2 = value.get0();
        long l2 = 3L;
        long l3 = value2.get0().getRawValue();
        while (l2 < l3) {
            long l4 = l2 + l3 >> 1 | 1L;
            if (l < value2.get(l4).getRawValue()) {
                l3 = l4 - 2L;
                continue;
            }
            l2 = l4;
        }
        return l == value2.get(l2).getRawValue() ? value2.get(l2 - 1L) : Value.ZERO;
    }
}

