/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.Toolkit;
import java.io.IOException;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.util.Beep;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="graph", module="Graphics", source="otherlibs/graph/sound.c")
public final class Sound {
    private static final int BUFFER_SIZE = 1024;
    private static final float SAMPLE_RATE = 44100.0f;

    private Sound() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int"}, returnType="unit")
    public static Value caml_gr_sound(Value value, Value value2) throws FailException {
        GraphSlot.checkGraph();
        Context context = CurrentContext.CONTEXT;
        if (!context.getParameters().isJavaxSoundUsed()) {
            Toolkit.getDefaultToolkit().beep();
            return Value.UNIT;
        }
        try {
            Beep beep = new Beep(44100.0f, value.asLong(), value2.asLong());
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, beep.getFormat());
            SourceDataLine sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
            sourceDataLine.open(beep.getFormat());
            sourceDataLine.start();
            byte[] byArray = new byte[1024];
            block3: while (true) {
                if (beep.available() <= 0) {
                    sourceDataLine.drain();
                    sourceDataLine.close();
                    return Value.UNIT;
                }
                int n = beep.read(byArray);
                int n2 = sourceDataLine.write(byArray, 0, n);
                while (true) {
                    if (n2 >= n) continue block3;
                    n2 += sourceDataLine.write(byArray, n2, n - n2);
                }
                break;
            }
        }
        catch (LineUnavailableException lineUnavailableException) {
            Toolkit.getDefaultToolkit().beep();
            return Value.UNIT;
        }
        catch (IOException iOException) {
            return Value.UNIT;
        }
    }
}

