/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.File;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.util.PermissionsUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/chmod.c")
public final class Chmod {
    private Chmod() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "Unix.file_perm"}, returnType="unit")
    public static Value unix_chmod(Value value, Value value2) throws FailException, FalseExit {
        File file = CurrentContext.FILES_STATE.getRealFile(value);
        try {
            PermissionsUtils.setPermissions(file, value2.asCastedInt());
        }
        catch (Exception exception) {
            Unix.fail("chmod", "unable to change file permissions");
        }
        return Value.UNIT;
    }
}

