/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.ExprValue;
import tcl.lang.Expression;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.UnaryMathFunction;

class Log10Function
extends UnaryMathFunction {
    private static final double log10 = Math.log(10.0);

    Log10Function() {
    }

    void apply(Interp interp, ExprValue[] values) throws TclException {
        ExprValue value = values[0];
        double d = value.getDoubleValue();
        if (d < 0.0) {
            Expression.DomainError(interp);
        }
        value.setDoubleValue(Math.log(d) / log10);
    }
}

