/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;

public class TclByteArray
implements InternalRep {
    private int used;
    private byte[] bytes;

    private TclByteArray() {
        this.used = 0;
        this.bytes = new byte[0];
    }

    private TclByteArray(byte[] b) {
        this.used = b.length;
        this.bytes = new byte[this.used];
        System.arraycopy(b, 0, this.bytes, 0, this.used);
    }

    private TclByteArray(byte[] b, int position, int length) {
        this.used = length;
        this.bytes = new byte[this.used];
        System.arraycopy(b, position, this.bytes, 0, this.used);
    }

    private TclByteArray(char[] c) {
        this.used = c.length;
        this.bytes = new byte[this.used];
        for (int ix = 0; ix < this.used; ++ix) {
            this.bytes[ix] = (byte)c[ix];
        }
    }

    public InternalRep duplicate() {
        return new TclByteArray(this.bytes, 0, this.used);
    }

    public void dispose() {
    }

    public String toString() {
        char[] c = new char[this.used];
        for (int ix = 0; ix < this.used; ++ix) {
            c[ix] = (char)(this.bytes[ix] & 0xFF);
        }
        return new String(c);
    }

    public static TclObject newInstance(byte[] b, int position, int length) {
        return new TclObject(new TclByteArray(b, position, length));
    }

    public static TclObject newInstance(byte[] b) {
        return new TclObject(new TclByteArray(b));
    }

    public static TclObject newInstance() {
        return new TclObject(new TclByteArray());
    }

    static void setByteArrayFromAny(Interp interp, TclObject tobj) {
        InternalRep rep = tobj.getInternalRep();
        if (!(rep instanceof TclByteArray)) {
            char[] c = tobj.toString().toCharArray();
            tobj.setInternalRep(new TclByteArray(c));
        }
    }

    public static byte[] setLength(Interp interp, TclObject tobj, int length) {
        if (tobj.isShared()) {
            throw new TclRuntimeError("TclByteArray.setLength() called with shared object");
        }
        TclByteArray.setByteArrayFromAny(interp, tobj);
        TclByteArray tbyteArray = (TclByteArray)tobj.getInternalRep();
        if (length > tbyteArray.bytes.length) {
            byte[] newBytes = new byte[length];
            System.arraycopy(tbyteArray.bytes, 0, newBytes, 0, tbyteArray.used);
            tbyteArray.bytes = newBytes;
        }
        tobj.invalidateStringRep();
        tbyteArray.used = length;
        return tbyteArray.bytes;
    }

    public static final int getLength(Interp interp, TclObject tobj) {
        TclByteArray.setByteArrayFromAny(interp, tobj);
        TclByteArray tbyteArray = (TclByteArray)tobj.getInternalRep();
        return tbyteArray.used;
    }

    public static byte[] getBytes(Interp interp, TclObject tobj) {
        TclByteArray.setByteArrayFromAny(interp, tobj);
        TclByteArray tbyteArray = (TclByteArray)tobj.getInternalRep();
        return tbyteArray.bytes;
    }
}

