/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.DatagramChannel;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/socket.c")
public final class Socket {
    private static final int SOCKET_STREAM = 0;
    private static final int SOCKET_DATAGRAM = 1;

    private Socket() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Does not support `PF_UNIX` domain. Does only support", "`SOCK_STREAM`, and `SOCK_DGRAM`. Protocol is ignored."}, parameterTypes={"Unix.socket_domain", "Unix.socket_type", "int"}, returnType="Unix.file_descr")
    public static Value unix_socket(Value value, Value value2, Value value3) throws FailException, FalseExit {
        if (value == Value.ZERO) {
            Unix.fail("socket", "unsupported socket domain");
            return Value.UNIT;
        }
        try {
            switch (value2.asCastedInt()) {
                case 0: {
                    return Value.createLong(CurrentContext.FILES_STATE.addChannel(new Channel()));
                }
                case 1: {
                    return Value.createLong(CurrentContext.FILES_STATE.addChannel(new Channel(DatagramChannel.open())));
                }
            }
            Unix.fail("socket", "unsupported socket type");
            return Value.UNIT;
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Unix.fail("socket", iOException);
            return Value.UNIT;
        }
    }
}

