/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.util.SignalKind;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/alarm.c")
public final class Alarm {
    private static final Object ALARM_SLOT = new Object();

    private Alarm() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="int")
    public static Value unix_alarm(Value value) {
        CodeRunner codeRunner = OCamlJavaThread.getCodeRunner();
        Context context = codeRunner.getContext();
        long l = value.asLong() * 1000L;
        Unix.AlarmThread alarmThread = (Unix.AlarmThread)context.getCodeState().getSlot(ALARM_SLOT);
        int n = alarmThread != null ? (int)(alarmThread.unactivate() / 1000L) : 0;
        if (l != 0L) {
            context.getCodeState().registerSlot(ALARM_SLOT, new Unix.AlarmThread(codeRunner, l, 0L, SignalKind.ALRM));
        }
        return Value.createLong(n);
    }
}

