/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.annotations.primitives;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.values.Value;

public final class Primitives {
    private static final String INVALID_PROVIDER = "'%s' is not a valid primive provider";
    private static final String PRIM_DEF_TWICE = "'%s' primive defined twice";
    private static final String NO_IMPLEMENTATION = "no implementation for '%s' primitive";
    private static final Class<PrimitiveProvider> PRIMITIVE_PROVIDER_ANNOT = PrimitiveProvider.class;
    private static final Class<Primitive> PRIMITIVE_ANNOT = Primitive.class;

    private Primitives() {
    }

    public static Method lookupPrimitive(String string, Class<?> ... classArray) throws OCamlJavaException {
        assert (string != null) : "null primName";
        assert (classArray != null) : "null classes";
        for (Class<?> clazz : classArray) {
            if (clazz.getAnnotation(PRIMITIVE_PROVIDER_ANNOT) == null) continue;
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(string) || !Primitives.checkMethod(method)) continue;
                return method;
            }
        }
        throw new OCamlJavaException(String.format(NO_IMPLEMENTATION, string));
    }

    public static void loadAllPrimitives(Map<String, Method> map, Class<?> clazz) throws OCamlJavaException {
        assert (map != null) : "null prims";
        assert (clazz != null) : "null cl";
        if (clazz.getAnnotation(PRIMITIVE_PROVIDER_ANNOT) != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                String string = method.getName();
                if (!Primitives.checkMethod(method) || map.put(string, method) == null) continue;
                throw new OCamlJavaException(String.format(PRIM_DEF_TWICE, string));
            }
        } else {
            throw new OCamlJavaException(String.format(INVALID_PROVIDER, clazz.getName()));
        }
    }

    private static boolean checkMethod(Method method) {
        assert (method != null) : "null m";
        return Modifier.isStatic(method.getModifiers()) && method.getAnnotation(PRIMITIVE_ANNOT) != null && method.getReturnType().equals(Value.class) && Primitives.checkParameters(method.getParameterTypes()) && Primitives.checkExceptions(method.getExceptionTypes());
    }

    private static boolean checkParameters(Class<?>[] classArray) {
        int n;
        assert (classArray != null) : "null types";
        int n2 = classArray.length;
        for (n = 0; n < n2 && Value.class.equals(classArray[n]); ++n) {
        }
        return n == n2 && n2 > 0;
    }

    private static boolean checkExceptions(Class<?>[] classArray) {
        assert (classArray != null) : "null exceptions";
        for (Class<?> clazz : classArray) {
            if (clazz.equals(FailException.class) || clazz.equals(FatalError.class) || clazz.equals(FalseExit.class)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Class<?>[] getSPIClasses() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            LinkedList linkedList = new LinkedList();
            Enumeration<URL> enumeration = classLoader.getResources("META-INF/services/org.ocamljava.runtime.annotations.primitives.PrimitiveProvider");
            block4: while (true) {
                Class[] classArray;
                if (!enumeration.hasMoreElements()) {
                    classArray = new Class[linkedList.size()];
                    return linkedList.toArray(classArray);
                }
                classArray = enumeration.nextElement();
                Iterator<String> iterator = Primitives.readClassNames((URL)classArray).iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block4;
                    String string = iterator.next();
                    try {
                        linkedList.add(Class.forName(string));
                    }
                    catch (Throwable throwable) {}
                }
                break;
            }
        }
        catch (IOException iOException) {
            return new Class[0];
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> readClassNames(URL uRL) {
        assert (uRL != null) : "null url";
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = bufferedReader.readLine();
            while (true) {
                if (string == null) {
                    bufferedReader.close();
                    inputStreamReader.close();
                    return linkedList;
                }
                int n = string.indexOf(35);
                if (n != -1) {
                    string = string.substring(0, n);
                }
                if ((string = string.trim()).length() != 0) {
                    linkedList.add(string);
                }
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return linkedList;
    }
}

