/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="ThreadGroup", source="")
public final class ThreadGroup {
    private ThreadGroup() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t option", "string"}, returnType="ThreadGroup.t")
    public static Value ocamljava_threadgroup_make(Value value, Value value2) {
        if (value.isLong()) {
            return Value.createInstance(new java.lang.ThreadGroup(value2.asString()));
        }
        return Value.createInstance(new java.lang.ThreadGroup((java.lang.ThreadGroup)value.get0().asCustom(), value2.asString()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t"}, returnType="int32")
    public static Value ocamljava_threadgroup_active_count(Value value) {
        java.lang.ThreadGroup threadGroup = (java.lang.ThreadGroup)value.asCustom();
        int n = threadGroup.activeCount();
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t"}, returnType="int32")
    public static Value ocamljava_threadgroup_active_group_count(Value value) {
        java.lang.ThreadGroup threadGroup = (java.lang.ThreadGroup)value.asCustom();
        int n = threadGroup.activeGroupCount();
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t"}, returnType="unit")
    public static Value ocamljava_threadgroup_destroy(Value value) throws FailException {
        java.lang.ThreadGroup threadGroup = (java.lang.ThreadGroup)value.asCustom();
        try {
            threadGroup.destroy();
            return Value.UNIT;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            Fail.invalidArgument("Concurrent.ThreadGroup.destroy");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t"}, returnType="int32")
    public static Value ocamljava_threadgroup_get_max_priority(Value value) {
        java.lang.ThreadGroup threadGroup = (java.lang.ThreadGroup)value.asCustom();
        int n = threadGroup.getMaxPriority();
        return Value.createInt32(n);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t"}, returnType="string")
    public static Value ocamljava_threadgroup_get_name(Value value) {
        java.lang.ThreadGroup threadGroup = (java.lang.ThreadGroup)value.asCustom();
        String string = threadGroup.getName();
        return Value.createString(string);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t"}, returnType="ThreadGroup.t option")
    public static Value ocamljava_threadgroup_get_parent(Value value) {
        java.lang.ThreadGroup threadGroup = (java.lang.ThreadGroup)value.asCustom();
        java.lang.ThreadGroup threadGroup2 = threadGroup.getParent();
        return threadGroup2 == null ? Value.ZERO : Value.createBlock(0, Value.createInstance(threadGroup2));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t"}, returnType="unit")
    public static Value ocamljava_threadgroup_interrupt(Value value) {
        java.lang.ThreadGroup threadGroup = (java.lang.ThreadGroup)value.asCustom();
        threadGroup.interrupt();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t"}, returnType="bool")
    public static Value ocamljava_threadgroup_is_daemon(Value value) {
        java.lang.ThreadGroup threadGroup = (java.lang.ThreadGroup)value.asCustom();
        boolean bl = threadGroup.isDaemon();
        return bl ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t"}, returnType="bool")
    public static Value ocamljava_threadgroup_is_destroyed(Value value) {
        java.lang.ThreadGroup threadGroup = (java.lang.ThreadGroup)value.asCustom();
        boolean bl = threadGroup.isDestroyed();
        return bl ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t", "ThreadGroup.t"}, returnType="bool")
    public static Value ocamljava_threadgroup_parent_of(Value value, Value value2) {
        java.lang.ThreadGroup threadGroup;
        java.lang.ThreadGroup threadGroup2 = (java.lang.ThreadGroup)value.asCustom();
        boolean bl = threadGroup2.parentOf(threadGroup = (java.lang.ThreadGroup)value2.asCustom());
        return bl ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t", "bool"}, returnType="unit")
    public static Value ocamljava_threadgroup_set_daemon(Value value, Value value2) {
        java.lang.ThreadGroup threadGroup = (java.lang.ThreadGroup)value.asCustom();
        threadGroup.setDaemon(value2 != Value.FALSE);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t", "int32"}, returnType="unit")
    public static Value ocamljava_threadgroup_set_max_priority(Value value, Value value2) {
        java.lang.ThreadGroup threadGroup = (java.lang.ThreadGroup)value.asCustom();
        threadGroup.setMaxPriority(value2.asInt32());
        return Value.UNIT;
    }
}

