/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.FocusCmd;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.Result;
import com.onemoonscientific.swank.Setter;
import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkBinding;
import com.onemoonscientific.swank.SwkBorder;
import com.onemoonscientific.swank.SwkChangeListener;
import com.onemoonscientific.swank.SwkComponentListener;
import com.onemoonscientific.swank.SwkDocumentListener;
import com.onemoonscientific.swank.SwkFocusListener;
import com.onemoonscientific.swank.SwkIndex;
import com.onemoonscientific.swank.SwkJTextFieldWidgetCmd;
import com.onemoonscientific.swank.SwkKeyCommandListener;
import com.onemoonscientific.swank.SwkKeyListener;
import com.onemoonscientific.swank.SwkMouseListener;
import com.onemoonscientific.swank.SwkMouseMotionListener;
import com.onemoonscientific.swank.SwkTextVariable;
import com.onemoonscientific.swank.SwkWidget;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.VarTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwkJTextField
extends JTextField
implements SwkWidget,
Printable,
SwkTextVariable {
    static Hashtable resourceDB = null;
    String name = null;
    String className = null;
    LinkedList children = null;
    ArrayList<SwkBinding> virtualBindings = null;
    int active = 0;
    boolean created = false;
    TclObject tclObject = null;
    final Interp interp;
    Insets emptyBorderInsets = new Insets(0, 0, 0, 0);
    Vector tagList = new Vector();
    Dimension minimumSize = null;
    String jhelptarget = "";
    Color insertBackground;
    int insertWidth = 0;
    int insertBorderWidth = 0;
    int insertOffTime = 0;
    int insertOnTime = 0;
    boolean processNativeKeyBindings = true;
    String show = "";
    float[] anchor = new float[]{0.0f, 0.0f};
    int borderWidth = 2;
    boolean exportSelection;
    Color highlightBackground = Color.white;
    Color highlightColor = Color.red;
    int highlightThickness;
    String justify = "";
    int padx;
    int pady;
    String relief = "sunken";
    Color selectBackground;
    int selectBorderWidth;
    String takeFocus = null;
    String xScrollCommand = null;
    String yScrollCommand = null;
    String textVariable = "";
    SwkDocumentListener docListener = null;
    private Insets insets = new Insets(0, 0, 0, 0);
    SwkMouseListener mouseListener = null;
    SwkKeyListener keyListener = null;
    SwkKeyCommandListener keyCommandListener = null;
    SwkFocusListener focusListener = null;
    SwkComponentListener componentListener = null;
    SwkChangeListener changeListener = null;
    SwkMouseMotionListener mouseMotionListener = null;
    int mouseX = 0;
    int mouseY = 0;
    static String[] validCmds = new String[]{"-anchor", "-autoscrolls", "-background", "-bd", "-bg", "-border", "-borderwidth", "-caretcolor", "-caretposition", "-class", "-cursor", "-disabledtextcolor", "-editable", "-enabled", "-exportselection", "-fg", "-focusable", "-focuscycleroot", "-focustraversalkeysenabled", "-focustraversalpolicyprovider", "-font", "-foreground", "-highlightbackground", "-highlightcolor", "-highlightthickness", "-insertbackground", "-insertborderwidth", "-insertofftime", "-insertontime", "-insertwidth", "-jhelptarget", "-justify", "-nativekeys", "-opaque", "-padx", "-pady", "-relief", "-requestfocusenabled", "-selectbackground", "-selectborderwidth", "-selectedtextcolor", "-selectforeground", "-selectioncolor", "-selectionend", "-selectionstart", "-show", "-state", "-takefocus", "-text", "-textvariable", "-tooltiptext", "-verifyinputwhenfocustarget", "-visible", "-width", "-xscrollcommand", "-yscrollcommand"};
    private static final int OPT_ANCHOR = 0;
    private static final int OPT_AUTOSCROLLS = 1;
    private static final int OPT_BACKGROUND = 2;
    private static final int OPT_BD = 3;
    private static final int OPT_BG = 4;
    private static final int OPT_BORDER = 5;
    private static final int OPT_BORDERWIDTH = 6;
    private static final int OPT_CARETCOLOR = 7;
    private static final int OPT_CARETPOSITION = 8;
    private static final int OPT_CLASS = 9;
    private static final int OPT_CURSOR = 10;
    private static final int OPT_DISABLEDTEXTCOLOR = 11;
    private static final int OPT_EDITABLE = 12;
    private static final int OPT_ENABLED = 13;
    private static final int OPT_EXPORTSELECTION = 14;
    private static final int OPT_FG = 15;
    private static final int OPT_FOCUSABLE = 16;
    private static final int OPT_FOCUSCYCLEROOT = 17;
    private static final int OPT_FOCUSTRAVERSALKEYSENABLED = 18;
    private static final int OPT_FOCUSTRAVERSALPOLICYPROVIDER = 19;
    private static final int OPT_FONT = 20;
    private static final int OPT_FOREGROUND = 21;
    private static final int OPT_HIGHLIGHTBACKGROUND = 22;
    private static final int OPT_HIGHLIGHTCOLOR = 23;
    private static final int OPT_HIGHLIGHTTHICKNESS = 24;
    private static final int OPT_INSERTBACKGROUND = 25;
    private static final int OPT_INSERTBORDERWIDTH = 26;
    private static final int OPT_INSERTOFFTIME = 27;
    private static final int OPT_INSERTONTIME = 28;
    private static final int OPT_INSERTWIDTH = 29;
    private static final int OPT_JHELPTARGET = 30;
    private static final int OPT_JUSTIFY = 31;
    private static final int OPT_NATIVEKEYS = 32;
    private static final int OPT_OPAQUE = 33;
    private static final int OPT_PADX = 34;
    private static final int OPT_PADY = 35;
    private static final int OPT_RELIEF = 36;
    private static final int OPT_REQUESTFOCUSENABLED = 37;
    private static final int OPT_SELECTBACKGROUND = 38;
    private static final int OPT_SELECTBORDERWIDTH = 39;
    private static final int OPT_SELECTEDTEXTCOLOR = 40;
    private static final int OPT_SELECTFOREGROUND = 41;
    private static final int OPT_SELECTIONCOLOR = 42;
    private static final int OPT_SELECTIONEND = 43;
    private static final int OPT_SELECTIONSTART = 44;
    private static final int OPT_SHOW = 45;
    private static final int OPT_STATE = 46;
    private static final int OPT_TAKEFOCUS = 47;
    private static final int OPT_TEXT = 48;
    private static final int OPT_TEXTVARIABLE = 49;
    private static final int OPT_TOOLTIPTEXT = 50;
    private static final int OPT_VERIFYINPUTWHENFOCUSTARGET = 51;
    private static final int OPT_VISIBLE = 52;
    private static final int OPT_WIDTH = 53;
    private static final int OPT_XSCROLLCOMMAND = 54;
    private static final int OPT_YSCROLLCOMMAND = 55;
    static TreeMap validCmdsTM = new TreeMap();

    public SwkJTextField(Interp interp, String name, String className) {
        this.name = name.intern();
        this.interp = interp;
        if (resourceDB == null) {
            resourceDB = new Hashtable();
            SwkJTextField.initResources();
        }
        this.docListener = new SwkDocumentListener(interp, this);
        this.getDocument().addDocumentListener(this.docListener);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent fEvent) {
                FocusCmd.setFocusWindow(SwkJTextField.this.getName());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mEvent) {
                mEvent.getComponent().requestFocus();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mEvent) {
                SwkJTextField.this.mouseX = mEvent.getX();
                SwkJTextField.this.mouseY = mEvent.getY();
            }

            public void mouseDragged(MouseEvent mEvent) {
                SwkJTextField.this.mouseX = mEvent.getX();
                SwkJTextField.this.mouseY = mEvent.getY();
            }
        });
        this.tagList.add(name);
        this.tagList.add(className);
        this.tagList.add("swank");
        this.tagList.add("all");
    }

    public static void getWidgetOptions(Interp interp) throws TclException {
        TclObject result = TclList.newInstance();
        int n = validCmds.length;
        for (int i = 0; i < n; ++i) {
            TclList.append((Interp)interp, (TclObject)result, (TclObject)TclString.newInstance((String)validCmds[i]));
        }
        interp.setResult(result);
    }

    public static void getWidgetCmds(Interp interp) throws TclException {
        TclObject result = TclList.newInstance();
        String[] validCmds = SwkJTextFieldWidgetCmd.getValidCmds();
        int n = validCmds.length;
        for (int i = 0; i < n; ++i) {
            TclList.append((Interp)interp, (TclObject)result, (TclObject)TclString.newInstance((String)validCmds[i]));
        }
        interp.setResult(result);
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int result = 1;
        if (pageIndex == 0) {
            Graphics2D g2 = (Graphics2D)g;
            double pX = pageFormat.getImageableX();
            double pY = pageFormat.getImageableY();
            double pW = pageFormat.getImageableWidth();
            double pH = pageFormat.getImageableHeight();
            Dimension dimSize = this.getSize();
            double sx = 1.0;
            double sy = 1.0;
            if ((double)dimSize.width > pW) {
                sx = pW / (double)dimSize.width;
                sy = pW / (double)dimSize.width;
            }
            if ((double)dimSize.height * sx > pH) {
                sy = sx * pH / ((double)dimSize.height * sx);
                sx = sx * pH / ((double)dimSize.height * sx);
            }
            g2.translate(pX, pY);
            g2.scale(sx, sy);
            boolean wasBuffered = SwankUtil.disableDoubleBuffering(this);
            this.paint(g2);
            SwankUtil.restoreDoubleBuffering(this, wasBuffered);
            result = 0;
        }
        return result;
    }

    @Override
    public Vector getTagList() {
        return this.tagList;
    }

    @Override
    public void setTagList(Interp interp, TclObject tagListObj) throws TclException {
        TclObject[] tagObjs = TclList.getElements((Interp)interp, (TclObject)tagListObj);
        this.tagList.setSize(0);
        for (int i = 0; i < tagObjs.length; ++i) {
            this.tagList.add(tagObjs[i].toString());
        }
    }

    @Override
    public void setVirtualBindings(ArrayList<SwkBinding> bindings) {
        this.virtualBindings = bindings;
    }

    @Override
    public ArrayList<SwkBinding> getVirtualBindings() {
        return this.virtualBindings;
    }

    @Override
    public Insets getEmptyBorderInsets() {
        return this.emptyBorderInsets;
    }

    @Override
    public LinkedList getChildrenList() {
        return this.children;
    }

    @Override
    public void initChildrenList() {
        this.children = new LinkedList();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setJHelpTarget(String jhelptarget) {
        this.jhelptarget = jhelptarget;
        SwankUtil.setJHelpTarget(this, jhelptarget);
    }

    public String getJHelpTarget() {
        return this.jhelptarget;
    }

    public void setInsertBackground(Color insertBackground) {
        this.insertBackground = insertBackground;
    }

    public Color getInsertBackground() {
        return this.insertBackground;
    }

    public void setInsertWidth(int insertWidth) {
        this.insertWidth = insertWidth;
    }

    public int getInsertWidth() {
        return this.insertWidth;
    }

    public void setInsertBorderWidth(int insertBorderWidth) {
        this.insertBorderWidth = insertBorderWidth;
    }

    public int getInsertBorderWidth() {
        return this.insertBorderWidth;
    }

    public void setInsertOffTime(int insertOffTime) {
        this.insertOffTime = insertOffTime;
    }

    public int getInsertOffTime() {
        return this.insertOffTime;
    }

    public void setInsertOnTime(int insertOnTime) {
        this.insertOnTime = insertOnTime;
    }

    public int getInsertOnTime() {
        return this.insertOnTime;
    }

    public void setProcessNativeKeyBindings(boolean processNativeKeyBindings) {
        this.processNativeKeyBindings = processNativeKeyBindings;
    }

    public boolean getProcessNativeKeyBindings() {
        return this.processNativeKeyBindings;
    }

    public void setShow(String show) {
        this.show = show;
    }

    public String getShow() {
        return this.show;
    }

    public void setState(String state) {
        if ("normal".startsWith(state)) {
            this.setEditable(true);
        } else if ("active".startsWith(state)) {
            this.setEditable(true);
        } else if ("disabled".startsWith(state)) {
            this.setEditable(false);
        }
    }

    public String getState() {
        String state = "normal";
        if (!this.isEditable()) {
            state = "disabled";
        }
        return state;
    }

    public void setAnchor(float[] anchor) {
        this.anchor = anchor;
    }

    public float[] getAnchor() {
        return this.anchor;
    }

    public void setBorderWidth(double borderWidth) {
        this.borderWidth = (int)borderWidth;
        if (!(this.getBorder() instanceof SwkBorder)) {
            this.setBorder(new SwkBorder());
        }
    }

    @Override
    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setExportSelection(boolean exportSelection) {
        this.exportSelection = exportSelection;
    }

    public String getExportSelection() {
        if (this.exportSelection) {
            return "1";
        }
        return "0";
    }

    public void setHighlightBackground(Color highlightBackground) {
        this.highlightBackground = highlightBackground;
    }

    public Color getHighlightBackground() {
        return this.highlightBackground;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightThickness(int highlightThickness) {
        this.highlightThickness = highlightThickness;
    }

    public int getHighlightThickness() {
        return this.highlightThickness;
    }

    public void setJustify(String justify) {
        this.justify = justify;
        this.justify = "left".startsWith(justify) ? "left" : ("right".startsWith(justify) ? "right" : ("center".startsWith(justify) ? "center" : ""));
    }

    public String getJustify() {
        return this.justify;
    }

    public void setPadx(int padx) {
        this.emptyBorderInsets.left = this.padx = padx;
        this.emptyBorderInsets.right = this.padx;
        this.minimumSize = null;
    }

    public int getPadx() {
        return this.padx;
    }

    public void setPady(int pady) {
        this.emptyBorderInsets.top = this.pady = pady;
        this.emptyBorderInsets.bottom = this.pady;
        this.minimumSize = null;
    }

    public int getPady() {
        return this.pady;
    }

    public void setRelief(String relief) {
        if (!(this.getBorder() instanceof SwkBorder)) {
            this.setBorder(new SwkBorder());
        }
        this.relief = relief.intern();
    }

    @Override
    public String getRelief() {
        if (this.relief == null) {
            this.relief = "";
        }
        return this.relief;
    }

    public void setSelectBackground(Color selectBackground) {
        this.selectBackground = selectBackground;
    }

    public Color getSelectBackground() {
        return this.selectBackground;
    }

    public void setSelectBorderWidth(int selectBorderWidth) {
        this.selectBorderWidth = selectBorderWidth;
    }

    public int getSelectBorderWidth() {
        return this.selectBorderWidth;
    }

    public void setTakeFocus(String takeFocus) {
        this.takeFocus = takeFocus.intern();
    }

    public String getTakeFocus() {
        return this.takeFocus;
    }

    public void setXScrollCommand(String xScrollCommand) {
        this.xScrollCommand = xScrollCommand.intern();
    }

    public String getXScrollCommand() {
        return this.xScrollCommand;
    }

    public void setYScrollCommand(String yScrollCommand) {
        this.yScrollCommand = yScrollCommand.intern();
    }

    public String getYScrollCommand() {
        return this.yScrollCommand;
    }

    @Override
    public void setTextVariable(Interp interp, String name) throws TclException {
        this.docListener.setVarName(name);
    }

    @Override
    public String getTextVariable() {
        return this.docListener.getVarName();
    }

    public void getIndex(String sIndex, int endVal, Result result) {
        int index = 0;
        boolean isInt = false;
        if (SwankUtil.looksLikeInt(sIndex)) {
            try {
                index = Integer.parseInt(sIndex);
                isInt = true;
            }
            catch (NumberFormatException nfE) {
                isInt = false;
            }
        }
        if (!isInt) {
            boolean validIndex = false;
            if (sIndex.startsWith("e")) {
                index = this.getText().length() + endVal;
                validIndex = true;
            } else if (sIndex.equals("active")) {
                index = this.active;
                if (index >= this.getText().length()) {
                    index = this.getText().length() - 1;
                }
                validIndex = true;
            } else if (sIndex.startsWith("sel.f")) {
                validIndex = true;
                index = this.getSelectionStart();
            } else if (sIndex.startsWith("sel.l")) {
                validIndex = true;
                index = this.getSelectionEnd();
            } else if (!sIndex.equals("anchor") && sIndex.startsWith("@") && sIndex.length() > 1) {
                String xS = sIndex.substring(1);
                try {
                    validIndex = true;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!validIndex) {
                result.setError("bad listbox index \"" + sIndex + "\": must be active, anchor, end, @x,y, or a number");
            }
        }
        result.i = index;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = this.getMinimumSize();
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.minimumSize == null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            Dimension size = new Dimension();
            size.height = fontMetrics.getHeight();
            size.width = this.getColumns() * fontMetrics.charWidth('O');
            this.insets = this.getInsets(this.insets);
            size.height += this.insets.top + this.insets.bottom;
            size.width += this.insets.left + this.insets.right;
            this.minimumSize = size;
        }
        return new Dimension(this.minimumSize);
    }

    public void setSwkWidth(int width) {
        this.setColumns(width);
    }

    public int getSwkWidth() {
        return this.getColumns();
    }

    @Override
    public boolean isCreated() {
        return this.created;
    }

    @Override
    public void setCreated(boolean state) {
        this.created = state;
    }

    @Override
    public int getMouseX() {
        return this.mouseX;
    }

    @Override
    public int getMouseY() {
        return this.mouseY;
    }

    @Override
    public SwkMouseListener getMouseListener() {
        return this.mouseListener;
    }

    @Override
    public void setMouseListener(SwkMouseListener mouseListener) {
        this.mouseListener = mouseListener;
    }

    @Override
    public SwkFocusListener getFocusListener() {
        return this.focusListener;
    }

    @Override
    public void setFocusListener(SwkFocusListener focusListener) {
        this.focusListener = focusListener;
    }

    @Override
    public SwkComponentListener getComponentListener() {
        return this.componentListener;
    }

    @Override
    public void setComponentListener(SwkComponentListener componentListener) {
        this.componentListener = componentListener;
    }

    @Override
    public SwkChangeListener getChangeListener() {
        return this.changeListener;
    }

    @Override
    public void setChangeListener(SwkChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public SwkKeyListener getKeyListener() {
        return this.keyListener;
    }

    @Override
    public void setKeyListener(SwkKeyListener keyListener) {
        this.keyListener = keyListener;
    }

    public SwkKeyCommandListener getKeyCommandListener() {
        return this.keyCommandListener;
    }

    public void setKeyCommandListener(SwkKeyCommandListener keyCommandListener) {
        this.keyCommandListener = keyCommandListener;
    }

    @Override
    public SwkMouseMotionListener getMouseMotionListener() {
        return this.mouseMotionListener;
    }

    @Override
    public void setMouseListener(SwkMouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = mouseMotionListener;
    }

    public void setClassName(String className) {
        this.className = className.intern();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void close() throws TclException {
        if (this.docListener.getVarName() != null && this.docListener.getVarName().length() != 0) {
            this.interp.untraceVar(this.docListener.getVarName(), (VarTrace)this.docListener, 33);
        }
    }

    void jgetAll(Interp interp) throws TclException {
        if (EventQueue.isDispatchThread()) {
            System.out.println("never  run on event thread");
        }
        JGetAll jgetAll = new JGetAll(this);
        try {
            SwingUtilities.invokeAndWait(jgetAll);
        }
        catch (InterruptedException iE) {
            throw new TclException(interp, iE.toString());
        }
        catch (Exception e) {
            throw new TclException(interp, e.toString());
        }
        this.getAllConfigurations(interp, jgetAll.roValues);
    }

    ArrayList getAllConfigurations() {
        int nCmds = validCmds.length;
        ArrayList<Object> results = new ArrayList<Object>();
        Enumeration e = resourceDB.keys();
        while (e.hasMoreElements()) {
            String keyName = (String)e.nextElement();
            ResourceObject ro = (ResourceObject)resourceDB.get(keyName);
            if (ro == null) continue;
            String value = this.jget(ro.optNum);
            results.add(keyName);
            results.add(ro);
            results.add(value);
        }
        return results;
    }

    void getAllConfigurations(Interp interp, ArrayList roValues) throws TclException {
        TclObject list2 = TclList.newInstance();
        int n = roValues.size();
        for (int i = 0; i < n; i += 3) {
            TclObject list1 = TclList.newInstance();
            String keyName = (String)roValues.get(i);
            ResourceObject ro = (ResourceObject)roValues.get(i + 1);
            String value = (String)roValues.get(i + 2);
            if (ro == null) continue;
            TclObject tObj = TclString.newInstance((String)keyName);
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)tObj);
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.resource));
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.className));
            if (ro.defaultVal == null) {
                TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)""));
            } else {
                TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)ro.defaultVal));
            }
            if (value == null) {
                value = "";
            }
            TclList.append((Interp)interp, (TclObject)list1, (TclObject)TclString.newInstance((String)value));
            TclList.append((Interp)interp, (TclObject)list2, (TclObject)list1);
        }
        interp.setResult(list2);
    }

    @Override
    public void setValues(Setter setter, int opt) {
        switch (opt) {
            case 0: {
                this.setAnchor((float[])setter.oValue);
                break;
            }
            case 1: {
                this.setAutoscrolls(setter.bValue);
                break;
            }
            case 2: {
                this.setBackground((Color)setter.oValue);
                break;
            }
            case 3: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 4: {
                this.setBackground((Color)setter.oValue);
                break;
            }
            case 5: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 6: {
                this.setBorderWidth(setter.dValue);
                break;
            }
            case 7: {
                this.setCaretColor((Color)setter.oValue);
                break;
            }
            case 8: {
                this.setCaretPosition(setter.iValue);
                break;
            }
            case 9: {
                this.setClassName(setter.sValue);
                break;
            }
            case 10: {
                this.setCursor((Cursor)setter.oValue);
                break;
            }
            case 11: {
                this.setDisabledTextColor((Color)setter.oValue);
                break;
            }
            case 12: {
                this.setEditable(setter.bValue);
                break;
            }
            case 13: {
                this.setEnabled(setter.bValue);
                break;
            }
            case 14: {
                this.setExportSelection(setter.bValue);
                break;
            }
            case 15: {
                this.setForeground((Color)setter.oValue);
                break;
            }
            case 16: {
                this.setFocusable(setter.bValue);
                break;
            }
            case 17: {
                this.setFocusCycleRoot(setter.bValue);
                break;
            }
            case 18: {
                this.setFocusTraversalKeysEnabled(setter.bValue);
                break;
            }
            case 19: {
                this.setFocusTraversalPolicyProvider(setter.bValue);
                break;
            }
            case 20: {
                this.setFont((Font)setter.oValue);
                break;
            }
            case 21: {
                this.setForeground((Color)setter.oValue);
                break;
            }
            case 22: {
                this.setHighlightBackground((Color)setter.oValue);
                break;
            }
            case 23: {
                this.setHighlightColor((Color)setter.oValue);
                break;
            }
            case 24: {
                this.setHighlightThickness(setter.iValue);
                break;
            }
            case 25: {
                this.setInsertBackground((Color)setter.oValue);
                break;
            }
            case 26: {
                this.setInsertBorderWidth(setter.iValue);
                break;
            }
            case 27: {
                this.setInsertOffTime(setter.iValue);
                break;
            }
            case 28: {
                this.setInsertOnTime(setter.iValue);
                break;
            }
            case 29: {
                this.setInsertWidth(setter.iValue);
                break;
            }
            case 30: {
                this.setJHelpTarget(setter.sValue);
                break;
            }
            case 31: {
                this.setJustify(setter.sValue);
                break;
            }
            case 32: {
                this.setProcessNativeKeyBindings(setter.bValue);
                break;
            }
            case 33: {
                this.setOpaque(setter.bValue);
                break;
            }
            case 34: {
                this.setPadx(setter.iValue);
                break;
            }
            case 35: {
                this.setPady(setter.iValue);
                break;
            }
            case 36: {
                this.setRelief(setter.sValue);
                break;
            }
            case 37: {
                this.setRequestFocusEnabled(setter.bValue);
                break;
            }
            case 38: {
                this.setSelectBackground((Color)setter.oValue);
                break;
            }
            case 39: {
                this.setSelectBorderWidth(setter.iValue);
                break;
            }
            case 40: {
                this.setSelectedTextColor((Color)setter.oValue);
                break;
            }
            case 41: {
                this.setSelectionColor((Color)setter.oValue);
                break;
            }
            case 42: {
                this.setSelectionColor((Color)setter.oValue);
                break;
            }
            case 43: {
                this.setSelectionEnd(setter.iValue);
                break;
            }
            case 44: {
                this.setSelectionStart(setter.iValue);
                break;
            }
            case 45: {
                this.setShow(setter.sValue);
                break;
            }
            case 46: {
                this.setState(setter.sValue);
                break;
            }
            case 47: {
                this.setTakeFocus(setter.sValue);
                break;
            }
            case 48: {
                this.setText(setter.sValue);
                break;
            }
            case 49: {
                this.setYScrollCommand(setter.sValue);
                break;
            }
            case 50: {
                this.setToolTipText(setter.sValue);
                break;
            }
            case 51: {
                this.setVerifyInputWhenFocusTarget(setter.bValue);
                break;
            }
            case 52: {
                this.setVisible(setter.bValue);
                break;
            }
            case 53: {
                this.setSwkWidth(setter.iValue);
                break;
            }
            case 54: {
                this.setXScrollCommand(setter.sValue);
                break;
            }
            case 55: {
                this.setYScrollCommand(setter.sValue);
            }
        }
    }

    @Override
    public void configure(Interp interp, TclObject[] argv, int start) throws TclException {
        if (EventQueue.isDispatchThread()) {
            throw new RuntimeException("Configure on eventQueue");
        }
        if (argv.length <= start) {
            return;
        }
        ResourceObject ro = null;
        block58: for (int i = start; i < argv.length; i += 2) {
            if (i + 1 >= argv.length) {
                throw new TclException(interp, "value for \"" + argv[i].toString() + "\" missing");
            }
            ro = (ResourceObject)resourceDB.get(argv[i].toString());
            if (ro == null) {
                throw new TclException(interp, "unknown option \"" + argv[i].toString() + "\"");
            }
            int opt = SwkIndex.get(interp, argv[i], validCmdsTM, "option", 0);
            switch (opt) {
                case 0: {
                    float[] value = SwankUtil.getAnchor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 1: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 2: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 3: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 4: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 5: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 6: {
                    double value = SwankUtil.getTkSizeD(interp, this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 7: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 8: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 9: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 10: {
                    Cursor value = SwankUtil.getCursor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 11: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 12: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 13: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 14: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 15: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 16: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 17: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 18: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 19: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 20: {
                    Font value = SwankUtil.getFont(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 21: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 22: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 23: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 24: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 25: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 26: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 27: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 28: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 29: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 30: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 31: {
                    String value = SwankUtil.getJustify(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 32: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 33: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 34: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 35: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 36: {
                    String value = SwankUtil.getTkRelief(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 37: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 38: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 39: {
                    int value = SwankUtil.getTkSize(interp, (Component)this, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 40: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 41: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 42: {
                    Color value = SwankUtil.getColor(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 43: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 44: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 45: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 46: {
                    String value = SwankUtil.getState(interp, argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 47: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 48: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 49: {
                    this.setTextVariable(interp, argv[i + 1].toString());
                    continue block58;
                }
                case 50: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 51: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 52: {
                    boolean value = TclBoolean.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 53: {
                    int value = TclInteger.get((Interp)interp, (TclObject)argv[i + 1]);
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 54: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
                case 55: {
                    String value = argv[i + 1].toString();
                    new Setter(this, opt).exec(value);
                    continue block58;
                }
            }
        }
        SwankUtil.doWait();
        this.repaint();
    }

    String jget(int opt) {
        switch (opt) {
            case 0: {
                return SwankUtil.parseAnchor(this.getAnchor());
            }
            case 1: {
                return String.valueOf(this.getAutoscrolls());
            }
            case 2: {
                return SwankUtil.parseColor(this.getBackground());
            }
            case 3: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 4: {
                return SwankUtil.parseColor(this.getBackground());
            }
            case 5: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 6: {
                return SwankUtil.parseTkSize(this.getBorderWidth());
            }
            case 7: {
                return SwankUtil.parseColor(this.getCaretColor());
            }
            case 8: {
                return Integer.toString(this.getCaretPosition());
            }
            case 9: {
                return this.getClassName();
            }
            case 10: {
                return SwankUtil.parseCursor(this.getCursor());
            }
            case 11: {
                return SwankUtil.parseColor(this.getDisabledTextColor());
            }
            case 12: {
                return this.isEditable() ? "1" : "0";
            }
            case 13: {
                return this.isEnabled() ? "1" : "0";
            }
            case 14: {
                return String.valueOf(this.getExportSelection());
            }
            case 15: {
                return SwankUtil.parseColor(this.getForeground());
            }
            case 16: {
                return this.isFocusable() ? "1" : "0";
            }
            case 17: {
                return this.isFocusCycleRoot() ? "1" : "0";
            }
            case 18: {
                return String.valueOf(this.getFocusTraversalKeysEnabled());
            }
            case 19: {
                return this.isFocusTraversalPolicyProvider() ? "1" : "0";
            }
            case 20: {
                return SwankUtil.parseFont(this.getFont());
            }
            case 21: {
                return SwankUtil.parseColor(this.getForeground());
            }
            case 22: {
                return SwankUtil.parseColor(this.getHighlightBackground());
            }
            case 23: {
                return SwankUtil.parseColor(this.getHighlightColor());
            }
            case 24: {
                return SwankUtil.parseTkSize(this.getHighlightThickness());
            }
            case 25: {
                return SwankUtil.parseColor(this.getInsertBackground());
            }
            case 26: {
                return SwankUtil.parseTkSize(this.getInsertBorderWidth());
            }
            case 27: {
                return Integer.toString(this.getInsertOffTime());
            }
            case 28: {
                return Integer.toString(this.getInsertOnTime());
            }
            case 29: {
                return SwankUtil.parseTkSize(this.getInsertWidth());
            }
            case 30: {
                return this.getJHelpTarget();
            }
            case 31: {
                return this.getJustify();
            }
            case 32: {
                return String.valueOf(this.getProcessNativeKeyBindings());
            }
            case 33: {
                return this.isOpaque() ? "1" : "0";
            }
            case 34: {
                return SwankUtil.parseTkSize(this.getPadx());
            }
            case 35: {
                return SwankUtil.parseTkSize(this.getPady());
            }
            case 36: {
                return SwankUtil.parseTkRelief(this.getRelief());
            }
            case 37: {
                return this.isRequestFocusEnabled() ? "1" : "0";
            }
            case 38: {
                return SwankUtil.parseColor(this.getSelectBackground());
            }
            case 39: {
                return SwankUtil.parseTkSize(this.getSelectBorderWidth());
            }
            case 40: {
                return SwankUtil.parseColor(this.getSelectedTextColor());
            }
            case 41: {
                return SwankUtil.parseColor(this.getSelectionColor());
            }
            case 42: {
                return SwankUtil.parseColor(this.getSelectionColor());
            }
            case 43: {
                return Integer.toString(this.getSelectionEnd());
            }
            case 44: {
                return Integer.toString(this.getSelectionStart());
            }
            case 45: {
                return this.getShow();
            }
            case 46: {
                return this.getState();
            }
            case 47: {
                return this.getTakeFocus();
            }
            case 48: {
                return this.getText();
            }
            case 49: {
                return this.getTextVariable();
            }
            case 50: {
                return this.getToolTipText();
            }
            case 51: {
                return String.valueOf(this.getVerifyInputWhenFocusTarget());
            }
            case 52: {
                return this.isVisible() ? "1" : "0";
            }
            case 53: {
                return Integer.toString(this.getSwkWidth());
            }
            case 54: {
                return this.getXScrollCommand();
            }
            case 55: {
                return this.getYScrollCommand();
            }
        }
        return "";
    }

    String jget(Interp interp, TclObject arg) throws TclException {
        int opt = 0;
        try {
            opt = SwkIndex.get(interp, arg, validCmdsTM, "option", 0);
        }
        catch (TclException tclE) {
            throw new TclException(interp, "unknown option \"" + arg + "\"");
        }
        String result = "";
        if (!EventQueue.isDispatchThread()) {
            JGet jget = new JGet(this, opt);
            try {
                SwingUtilities.invokeAndWait(jget);
            }
            catch (InterruptedException iE) {
                throw new TclException(interp, iE.toString());
            }
            catch (Exception e) {
                throw new TclException(interp, e.toString());
            }
            result = jget.result;
        } else {
            result = this.jget(opt);
        }
        return result;
    }

    void setResourceDefaults() throws TclException {
        if (!EventQueue.isDispatchThread()) {
            ResourceDefaultsSetter resourceDefaultsSetter = new ResourceDefaultsSetter(this.interp, this);
            try {
                SwingUtilities.invokeAndWait(resourceDefaultsSetter);
            }
            catch (InterruptedException iE) {
                throw new TclException(this.interp, iE.toString());
            }
            catch (Exception e) {
                throw new TclException(this.interp, e.toString());
            }
        } else {
            this.setResourceDefaultsET();
        }
    }

    void setResourceDefaultsET() {
        Enumeration e = resourceDB.keys();
        while (e.hasMoreElements()) {
            ResourceObject ro;
            String keyName = (String)e.nextElement();
            if (keyName == null || (ro = (ResourceObject)resourceDB.get(keyName)) == null) continue;
            try {
                ro.defaultVal = this.jget(ro.optNum);
            }
            catch (IllegalComponentStateException icsE) {}
        }
    }

    private static void initResources() {
        ResourceObject resourceObject = null;
        resourceObject = new ResourceObject("anchor", "Anchor", 0);
        resourceDB.put("-anchor", resourceObject);
        resourceObject = new ResourceObject("autoscrolls", "Autoscrolls", 1);
        resourceDB.put("-autoscrolls", resourceObject);
        resourceObject = new ResourceObject("background", "Background", 2);
        resourceDB.put("-background", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 3);
        resourceDB.put("-bd", resourceObject);
        resourceObject = new ResourceObject("background", "Background", 4);
        resourceDB.put("-bg", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 5);
        resourceDB.put("-border", resourceObject);
        resourceObject = new ResourceObject("borderWidth", "BorderWidth", 6);
        resourceDB.put("-borderwidth", resourceObject);
        resourceObject = new ResourceObject("caretColor", "CaretColor", 7);
        resourceDB.put("-caretcolor", resourceObject);
        resourceObject = new ResourceObject("caretPosition", "CaretPosition", 8);
        resourceDB.put("-caretposition", resourceObject);
        resourceObject = new ResourceObject("className", "ClassName", 9);
        resourceDB.put("-class", resourceObject);
        resourceObject = new ResourceObject("cursor", "Cursor", 10);
        resourceDB.put("-cursor", resourceObject);
        resourceObject = new ResourceObject("disabledTextColor", "DisabledTextColor", 11);
        resourceDB.put("-disabledtextcolor", resourceObject);
        resourceObject = new ResourceObject("editable", "Editable", 12);
        resourceDB.put("-editable", resourceObject);
        resourceObject = new ResourceObject("enabled", "Enabled", 13);
        resourceDB.put("-enabled", resourceObject);
        resourceObject = new ResourceObject("exportSelection", "ExportSelection", 14);
        resourceDB.put("-exportselection", resourceObject);
        resourceObject = new ResourceObject("foreground", "Foreground", 15);
        resourceDB.put("-fg", resourceObject);
        resourceObject = new ResourceObject("focusable", "Focusable", 16);
        resourceDB.put("-focusable", resourceObject);
        resourceObject = new ResourceObject("focusCycleRoot", "FocusCycleRoot", 17);
        resourceDB.put("-focuscycleroot", resourceObject);
        resourceObject = new ResourceObject("focusTraversalKeysEnabled", "FocusTraversalKeysEnabled", 18);
        resourceDB.put("-focustraversalkeysenabled", resourceObject);
        resourceObject = new ResourceObject("focusTraversalPolicyProvider", "FocusTraversalPolicyProvider", 19);
        resourceDB.put("-focustraversalpolicyprovider", resourceObject);
        resourceObject = new ResourceObject("font", "Font", 20);
        resourceDB.put("-font", resourceObject);
        resourceObject = new ResourceObject("foreground", "Foreground", 21);
        resourceDB.put("-foreground", resourceObject);
        resourceObject = new ResourceObject("highlightBackground", "HighlightBackground", 22);
        resourceDB.put("-highlightbackground", resourceObject);
        resourceObject = new ResourceObject("highlightColor", "HighlightColor", 23);
        resourceDB.put("-highlightcolor", resourceObject);
        resourceObject = new ResourceObject("highlightThickness", "HighlightThickness", 24);
        resourceDB.put("-highlightthickness", resourceObject);
        resourceObject = new ResourceObject("insertBackground", "InsertBackground", 25);
        resourceDB.put("-insertbackground", resourceObject);
        resourceObject = new ResourceObject("insertBorderWidth", "InsertBorderWidth", 26);
        resourceDB.put("-insertborderwidth", resourceObject);
        resourceObject = new ResourceObject("insertOffTime", "InsertOffTime", 27);
        resourceDB.put("-insertofftime", resourceObject);
        resourceObject = new ResourceObject("insertOnTime", "InsertOnTime", 28);
        resourceDB.put("-insertontime", resourceObject);
        resourceObject = new ResourceObject("insertWidth", "InsertWidth", 29);
        resourceDB.put("-insertwidth", resourceObject);
        resourceObject = new ResourceObject("jHelpTarget", "JHelpTarget", 30);
        resourceDB.put("-jhelptarget", resourceObject);
        resourceObject = new ResourceObject("justify", "Justify", 31);
        resourceDB.put("-justify", resourceObject);
        resourceObject = new ResourceObject("nativeKeys", "NativeKeys", 32);
        resourceDB.put("-nativekeys", resourceObject);
        resourceObject = new ResourceObject("opaque", "Opaque", 33);
        resourceDB.put("-opaque", resourceObject);
        resourceObject = new ResourceObject("padx", "Padx", 34);
        resourceDB.put("-padx", resourceObject);
        resourceObject = new ResourceObject("pady", "Pady", 35);
        resourceDB.put("-pady", resourceObject);
        resourceObject = new ResourceObject("relief", "Relief", 36);
        resourceDB.put("-relief", resourceObject);
        resourceObject = new ResourceObject("requestFocusEnabled", "RequestFocusEnabled", 37);
        resourceDB.put("-requestfocusenabled", resourceObject);
        resourceObject = new ResourceObject("selectBackground", "SelectBackground", 38);
        resourceDB.put("-selectbackground", resourceObject);
        resourceObject = new ResourceObject("selectBorderWidth", "SelectBorderWidth", 39);
        resourceDB.put("-selectborderwidth", resourceObject);
        resourceObject = new ResourceObject("selectedTextColor", "SelectedTextColor", 40);
        resourceDB.put("-selectedtextcolor", resourceObject);
        resourceObject = new ResourceObject("selectionForeground", "SelectionForeground", 41);
        resourceDB.put("-selectforeground", resourceObject);
        resourceObject = new ResourceObject("selectionColor", "SelectionColor", 42);
        resourceDB.put("-selectioncolor", resourceObject);
        resourceObject = new ResourceObject("selectionEnd", "SelectionEnd", 43);
        resourceDB.put("-selectionend", resourceObject);
        resourceObject = new ResourceObject("selectionStart", "SelectionStart", 44);
        resourceDB.put("-selectionstart", resourceObject);
        resourceObject = new ResourceObject("show", "Show", 45);
        resourceDB.put("-show", resourceObject);
        resourceObject = new ResourceObject("state", "State", 46);
        resourceDB.put("-state", resourceObject);
        resourceObject = new ResourceObject("takeFocus", "TakeFocus", 47);
        resourceDB.put("-takefocus", resourceObject);
        resourceObject = new ResourceObject("text", "Text", 48);
        resourceDB.put("-text", resourceObject);
        resourceObject = new ResourceObject("textVariable", "TextVariable", 49);
        resourceDB.put("-textvariable", resourceObject);
        resourceObject = new ResourceObject("toolTipText", "ToolTipText", 50);
        resourceDB.put("-tooltiptext", resourceObject);
        resourceObject = new ResourceObject("verifyInputWhenFocusTarget", "VerifyInputWhenFocusTarget", 51);
        resourceDB.put("-verifyinputwhenfocustarget", resourceObject);
        resourceObject = new ResourceObject("visible", "Visible", 52);
        resourceDB.put("-visible", resourceObject);
        resourceObject = new ResourceObject("width", "Width", 53);
        resourceDB.put("-width", resourceObject);
        resourceObject = new ResourceObject("xScrollCommand", "XScrollCommand", 54);
        resourceDB.put("-xscrollcommand", resourceObject);
        resourceObject = new ResourceObject("yScrollCommand", "YScrollCommand", 55);
        resourceDB.put("-yscrollcommand", resourceObject);
    }

    static {
        for (int i = 0; i < validCmds.length; ++i) {
            validCmdsTM.put(validCmds[i], new Integer(i));
        }
    }

    class ResourceDefaultsSetter
    implements Runnable {
        Interp interp;
        SwkJTextField swkjtextfield;

        ResourceDefaultsSetter(Interp interp, SwkJTextField swkjtextfield) {
            this.interp = interp;
            this.swkjtextfield = swkjtextfield;
        }

        public void run() {
            SwkJTextField.this.setResourceDefaultsET();
        }
    }

    class JGet
    implements Runnable {
        SwkJTextField swkjtextfield;
        int opt = 0;
        String result = "";

        JGet(SwkJTextField swkjtextfield, int opt) {
            this.swkjtextfield = swkjtextfield;
            this.opt = opt;
        }

        public void run() {
            this.result = this.swkjtextfield.jget(this.opt);
        }
    }

    class JGetAll
    implements Runnable {
        SwkJTextField swkjtextfield;
        ArrayList roValues = null;

        JGetAll(SwkJTextField swkjtextfield) {
            this.swkjtextfield = swkjtextfield;
        }

        public void run() {
            this.roValues = SwkJTextField.this.getAllConfigurations();
        }
    }
}

