/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.ItemBitmap;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import javax.swing.ImageIcon;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class BitmapParameter
extends CanvasParameter {
    private static String name = "bitmap";
    private static String defValue = "";
    private ImageIcon newValue = null;

    public String getName() {
        return name;
    }

    public String getDefault() {
        return defValue;
    }

    public boolean isParameterLabel(String s) {
        return s.length() > 3 && "-bitmap".startsWith(s);
    }

    public TclObject getValue(Interp interp, SwkShape swkShape) throws TclException {
        if (swkShape == null) {
            throw new TclException(interp, "shape doesn't exist");
        }
        if (swkShape instanceof ItemBitmap) {
            return TclString.newInstance((String)SwankUtil.parseImageIcon(((ItemBitmap)swkShape).getImageIcon()));
        }
        throw new TclException(interp, "shape not bitmap");
    }

    public void setValue(Interp interp, SwkImageCanvas swkCanvas, TclObject arg) throws TclException {
        this.newValue = SwankUtil.getImageIcon(interp, arg);
    }

    public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
        if (swkShape == null) {
            return;
        }
        if (swkShape instanceof ItemBitmap && this.newValue != null) {
            ((ItemBitmap)swkShape).setImageIcon(this.newValue);
        }
    }
}

