/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas;

import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.ItemLine;
import com.onemoonscientific.swank.canvas.SwkImageCanvas;
import com.onemoonscientific.swank.canvas.SwkShape;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class EndstyleParameter
extends CanvasParameter {
    private static String name = "endstyle";
    private static String defValue = "none";
    ItemLine.EndPointStyle newValue = ItemLine.EndPointStyle.NONE;

    public String getName() {
        return name;
    }

    public String getDefault() {
        return defValue + "";
    }

    public boolean isParameterLabel(String s) {
        return s.length() > 3 && "-arrow".startsWith(s);
    }

    public TclObject getValue(Interp interp, SwkShape swkShape) throws TclException {
        if (swkShape == null) {
            throw new TclException(interp, "shape doesn't exist");
        }
        ItemLine swkLine = (ItemLine)swkShape;
        String type = swkLine.endPointStyle2.getDescription();
        return TclString.newInstance((String)type);
    }

    public void setValue(Interp interp, SwkImageCanvas swkCanvas, TclObject arg) throws TclException {
        this.newValue = arg.toString().startsWith("circle") ? ItemLine.EndPointStyle.CIRCLE : (arg.toString().startsWith("arrow") ? ItemLine.EndPointStyle.ARROW : (arg.toString().equals("square") ? ItemLine.EndPointStyle.SQUARE : (arg.toString().equals("diamond") ? ItemLine.EndPointStyle.DIAMOND : ItemLine.EndPointStyle.NONE)));
    }

    public void exec(SwkImageCanvas swkCanvas, SwkShape swkShape) {
        if (swkShape != null && swkShape instanceof ItemLine) {
            ItemLine swkLine = (ItemLine)swkShape;
            swkLine.endPointStyle2 = this.newValue;
        }
    }
}

