/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.values.Value;

public final class NativeArithmetic {
    private NativeArithmetic() {
    }

    public static long negint(long l) {
        return 2L - l;
    }

    public static long incrint(long l) {
        return l + 2L;
    }

    public static long decrint(long l) {
        return l - 2L;
    }

    public static long addint(long l, long l2) {
        return l + l2 - 1L;
    }

    public static long subint(long l, long l2) {
        return l - l2 + 1L;
    }

    public static long mulint(long l, long l2) {
        return (l >> 1) * (l2 >> 1) << 1 | 1L;
    }

    public static long divint(long l, long l2) throws FailException {
        try {
            return (l >> 1) / (l2 >> 1) << 1 | 1L;
        }
        catch (Throwable throwable) {
            Fail.raiseZeroDivide();
            return 0L;
        }
    }

    public static int divint32(int n, int n2) throws FailException {
        try {
            return n / n2;
        }
        catch (Throwable throwable) {
            Fail.raiseZeroDivide();
            return 0;
        }
    }

    public static long modint(long l, long l2) throws FailException {
        try {
            return (l >> 1) % (l2 >> 1) << 1 | 1L;
        }
        catch (Throwable throwable) {
            Fail.raiseZeroDivide();
            return 0L;
        }
    }

    public static int modint32(int n, int n2) throws FailException {
        try {
            return n % n2;
        }
        catch (Throwable throwable) {
            Fail.raiseZeroDivide();
            return 0;
        }
    }

    public static long lslint(long l, long l2) {
        return (l - 1L << (int)l2) + 1L;
    }

    public static long lsrint(long l, long l2) {
        return l - 1L >>> (int)l2 | 1L;
    }

    public static long asrint(long l, long l2) {
        return l - 1L >> (int)l2 | 1L;
    }

    public static long divint64(long l, long l2) throws FailException {
        try {
            return l / l2;
        }
        catch (Throwable throwable) {
            Fail.raiseZeroDivide();
            return 0L;
        }
    }

    public static long modint64(long l, long l2) throws FailException {
        try {
            return l % l2;
        }
        catch (Throwable throwable) {
            Fail.raiseZeroDivide();
            return 0L;
        }
    }

    public static long offsetint(long l, long l2) {
        return l + l2 - 1L;
    }

    public static void offsetref(Value value, long l) {
        value.set0(Value.createFromRawValue(value.get0().getRawValue() + l));
    }
}

