/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.AbstractCodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Obj", source="byterun/obj.c")
public final class Obj {
    private static final Value LONG_TAG = Value.createLong(1000L);
    private static final Value NON_BLOCK_TAG = Value.createLong(1001L);
    private static final Value UNALIGNED_TAG = Value.createLong(1002L);

    private Obj() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Returns a string block."}, parameterTypes={"int"}, returnType="'a")
    public static Value caml_static_alloc(Value value) {
        return Value.createString(value.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Does nothing."}, parameterTypes={"'a"}, returnType="unit")
    public static Value caml_static_free(Value value) {
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Does nothing."}, parameterTypes={"string", "int"}, returnType="unit")
    public static Value caml_static_release_bytecode(Value value, Value value2) throws FailException {
        if (OCamlJavaThread.getCodeRunner().isNative()) {
            Fail.failWith("Meta.static_release_bytecode impossible with native code");
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Treats parameter as a string and returns another one."}, parameterTypes={"string", "int"}, returnType="string")
    public static Value caml_static_resize(Value value, Value value2) {
        int n = value2.asCastedInt();
        byte[] byArray = new byte[n];
        byte[] byArray2 = value.getBytes();
        System.arraycopy(byArray2, 0, byArray, 0, Math.min(byArray2.length, n));
        return Value.createString(byArray);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a"}, returnType="bool")
    public static Value caml_obj_is_block(Value value) {
        return value.isBlock() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Obj.t"}, returnType="int")
    public static Value caml_obj_tag(Value value) {
        if (value.isLong()) {
            return LONG_TAG;
        }
        if (value.isBlock()) {
            return Value.createLong(value.getTag());
        }
        return NON_BLOCK_TAG;
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Subsequent use of block may fail if tag change", "implies representation shift."}, parameterTypes={"Obj.t", "int"}, returnType="unit")
    public static Value caml_obj_set_tag(Value value, Value value2) {
        value.setTag(value2.asCastedInt());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int"}, returnType="Obj.t")
    public static Value caml_obj_block(Value value, Value value2) {
        int n = value.asCastedInt();
        long l = value2.asLong();
        if (l == 0L) {
            return CurrentContext.CODE_STATE.getAtom(n);
        }
        return Value.createBlock(n, l);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Obj.t"}, returnType="Obj.t")
    public static Value caml_obj_dup(Value value) {
        if (value.getWoSize() == 0L) {
            return value;
        }
        return value.asBlock().duplicate();
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Obj.t", "int"}, returnType="unit")
    public static Value caml_obj_truncate(Value value, Value value2) throws FailException {
        value.asBlock().truncate(value2.asLong());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Obj.t", "int32"}, returnType="Obj.t")
    public static Value caml_obj_add_offset(Value value, Value value2) {
        return value.offset(value2.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a"}, returnType="'a")
    public static Value caml_lazy_follow_forward(Value value) {
        if (value.isBlock() && value.getTag() == 250) {
            return value.get0();
        }
        return value;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a"}, returnType="'a lazy_t")
    public static Value caml_lazy_make_forward(Value value) {
        return Value.createBlock(250, value);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"CamlinternalOO.obj", "CamlinternalOO.tag"}, returnType="CamlinternalOO.closure")
    public static Value caml_get_public_method(Value value, Value value2) {
        return AbstractCodeRunner.getMethod(value, value2.getRawValue());
    }
}

