/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/lssek.c")
public final class Lseek {
    private Lseek() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "int", "Unix.seek_command"}, returnType="int")
    public static Value unix_lseek(Value fd, Value ofs, Value cmd) throws FailException, FalseExit {
        try {
            Channel ch = CurrentContext.getFilesState().getChannel(fd.asCastedInt());
            if (ch == null) {
                Unix.fail("lseek", "invalid descriptor");
                return Value.UNIT;
            }
            return Value.createLong(ch.seek(ofs.asLong(), cmd.asCastedInt()));
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Unix.fail("lseek", ioe);
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "int64", "Unix.seek_command"}, returnType="int64")
    public static Value unix_lseek_64(Value fd, Value ofs, Value cmd) throws FailException, FalseExit {
        try {
            Channel ch = CurrentContext.getFilesState().getChannel(fd.asCastedInt());
            if (ch == null) {
                Unix.fail("lseek_64", "invalid descriptor");
                return Value.UNIT;
            }
            return Value.createInt64(ch.seek(ofs.asInt64(), cmd.asCastedInt()));
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Unix.fail("lseek_64", ioe);
            return Value.UNIT;
        }
    }
}

