/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.wrappers;

import org.ocamljava.runtime.values.Value;
import org.ocamljava.runtime.wrappers.OCamlUnit;
import org.ocamljava.runtime.wrappers.OCamlValue;
import org.ocamljava.runtime.wrappers.SimpleWrapper;
import org.ocamljava.runtime.wrappers.Wrapper;

public final class OCamlBool
extends OCamlValue {
    public static final Wrapper<OCamlBool> WRAPPER = new SimpleWrapper<OCamlBool>(){

        @Override
        public OCamlBool wrap(Value v) {
            return v == Value.FALSE ? FALSE : TRUE;
        }
    };
    public static final OCamlBool TRUE = new OCamlBool(Value.TRUE);
    public static final OCamlBool FALSE = new OCamlBool(Value.FALSE);

    private OCamlBool(Value v) {
        super(v);
    }

    public Wrapper<? extends OCamlBool> getWrapper() {
        return WRAPPER;
    }

    @Override
    public Wrapper<? extends OCamlValue> getWrapper(int idx) {
        return OCamlUnit.WRAPPER;
    }

    public boolean booleanValue() {
        return this.value != Value.FALSE;
    }

    @Override
    public int hashCode() {
        return this.value == Value.FALSE ? 0 : 1;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OCamlBool) {
            OCamlBool that = (OCamlBool)obj;
            return this.value == that.value;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OCamlBool(");
        sb.append(this.value == Value.FALSE ? "false" : "true");
        sb.append(")");
        return sb.toString();
    }

    public static OCamlBool create(boolean v) {
        return v ? TRUE : FALSE;
    }

    public static OCamlBool wrap(Value v) {
        assert (v != null) : "null v";
        return v == Value.FALSE ? FALSE : TRUE;
    }

    public static Wrapper<? extends OCamlBool> wrapper() {
        return WRAPPER;
    }
}

